/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.reporters.Files;
import org.testng.util.Strings;
import org.testng.xml.IPostProcessor;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.testng.xml.internal.TestNamesMatcher;
import org.testng.xml.internal.XmlSuiteUtils;

class JarFileUtils {
    private final IPostProcessor processor;
    private final String xmlPathInJar;
    private final List<String> testNames;
    private final List<XmlSuite> suites = Lists.newLinkedList();
    private final XmlSuite.ParallelMode mode;

    JarFileUtils(IPostProcessor iPostProcessor, String string, List<String> list) {
        this(iPostProcessor, string, list, XmlSuite.ParallelMode.NONE);
    }

    JarFileUtils(IPostProcessor iPostProcessor, String string, List<String> list, XmlSuite.ParallelMode parallelMode) {
        this.processor = iPostProcessor;
        this.xmlPathInJar = string;
        this.testNames = list;
        this.mode = parallelMode == null ? XmlSuite.ParallelMode.NONE : parallelMode;
    }

    List<XmlSuite> extractSuitesFrom(File file) {
        try {
            Utils.log("TestNG", 2, "Trying to open jar file:" + file);
            List list = Lists.newArrayList();
            boolean bl = this.testngXmlExistsInJar(file, list);
            if (!bl) {
                Utils.log("TestNG", 1, "Couldn't find the " + this.xmlPathInJar + " in the jar file, running all the classes");
                XmlSuite xmlSuite = XmlSuiteUtils.newXmlSuiteUsing((List)list);
                xmlSuite.setParallel(this.mode);
                this.suites.add(xmlSuite);
            }
        }
        catch (IOException iOException) {
            throw new TestNGException(iOException);
        }
        return this.suites;
    }

    private boolean testngXmlExistsInJar(File file, List<String> list) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            File file2;
            Object object;
            Object object2;
            Object object3;
            Enumeration<JarEntry> enumeration = jarFile.entries();
            File file3 = java.nio.file.Files.createTempDirectory("testngXmlPathInJar-", new FileAttribute[0]).toFile();
            String string = null;
            while (enumeration.hasMoreElements()) {
                object3 = enumeration.nextElement();
                object2 = ((ZipEntry)object3).getName();
                if (Parser.canParse((String)((String)object2).toLowerCase())) {
                    object = jarFile.getInputStream((ZipEntry)object3);
                    file2 = new File(file3, (String)object2);
                    Files.copyFile((InputStream)object, (File)file2);
                    if (!this.matchesXmlPathInJar((JarEntry)object3)) continue;
                    string = file2.toString();
                    continue;
                }
                if (!JarFileUtils.isJavaClass((JarEntry)object3)) continue;
                list.add(JarFileUtils.constructClassName((JarEntry)object3));
            }
            if (Strings.isNullOrEmpty(string)) {
                boolean bl = false;
                return bl;
            }
            object3 = Parser.parse(string, (IPostProcessor)this.processor);
            this.delete(file3);
            object2 = object3.iterator();
            if (object2.hasNext()) {
                object = (XmlSuite)object2.next();
                if (this.testNames != null) {
                    file2 = new TestNamesMatcher((XmlSuite)object, this.testNames);
                    List list2 = file2.getMissMatchedTestNames();
                    if (!list2.isEmpty()) {
                        throw new TestNGException("The test(s) <" + list2 + "> cannot be found.");
                    }
                    this.suites.addAll(file2.getSuitesMatchingTestNames());
                } else {
                    this.suites.add((XmlSuite)object);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.delete(file2);
            }
        }
        if (!file.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + file);
        }
    }

    private boolean matchesXmlPathInJar(JarEntry jarEntry) {
        return jarEntry.getName().equals(this.xmlPathInJar);
    }

    private static boolean isJavaClass(JarEntry jarEntry) {
        return jarEntry.getName().endsWith(".class");
    }

    private static String constructClassName(JarEntry jarEntry) {
        int n = jarEntry.getName().length() - ".class".length();
        return jarEntry.getName().replace("/", ".").substring(0, n);
    }
}

