/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.testng.IAttributes;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IDataProviderListener;
import org.testng.IExecutionVisualiser;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.ITestRunnerFactory2;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.Attributes;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class SuiteRunner
implements ISuite,
IInvokedMethodListener {
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> suiteResults = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private List<TestRunner> testRunners = Lists.newArrayList();
    private Map<Class<? extends ISuiteListener>, ISuiteListener> listeners = Maps.newHashMap();
    private TestListenerAdapter textReporter = new TestListenerAdapter();
    private String outputDir;
    private XmlSuite xmlSuite;
    private Injector parentInjector;
    private List<ITestListener> testListeners = Lists.newArrayList();
    private final Map<Class<? extends IClassListener>, IClassListener> classListeners = Maps.newHashMap();
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners = Maps.newHashMap();
    private ITestRunnerFactory tmpRunnerFactory;
    private boolean useDefaultListeners = true;
    private String remoteHost;
    private IConfiguration configuration;
    private ITestObjectFactory objectFactory;
    private Boolean skipFailedInvocationCounts = Boolean.FALSE;
    private List<IReporter> reporters = Lists.newArrayList();
    private Map<Class<? extends IInvokedMethodListener>, IInvokedMethodListener> invokedMethodListeners;
    private final Collection<IInvokedMethod> invokedMethods = new ConcurrentLinkedQueue<IInvokedMethod>();
    private List<ITestNGMethod> allTestMethods = Lists.newArrayList();
    private SuiteRunState suiteState = new SuiteRunState();
    private IAttributes attributes = new Attributes();
    private final Set<IExecutionVisualiser> visualisers = Sets.newHashSet();

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, Comparator<ITestNGMethod> comparator) {
        this(iConfiguration, xmlSuite, string, iTestRunnerFactory, false, comparator);
    }

    public SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, Comparator<ITestNGMethod> comparator) {
        this(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, new ArrayList<IMethodInterceptor>(), null, null, null, Collections.emptyMap(), comparator);
    }

    protected SuiteRunner(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> list, Collection<IInvokedMethodListener> collection, Collection<ITestListener> collection2, Collection<IClassListener> collection3, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map, Comparator<ITestNGMethod> comparator) {
        this.init(iConfiguration, xmlSuite, string, iTestRunnerFactory, bl, list, collection, collection2, collection3, map, comparator);
    }

    private void init(IConfiguration iConfiguration, XmlSuite xmlSuite, String string, ITestRunnerFactory iTestRunnerFactory, boolean bl, List<IMethodInterceptor> list, Collection<IInvokedMethodListener> collection, Collection<ITestListener> collection2, Collection<IClassListener> collection3, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map, Comparator<ITestNGMethod> comparator) {
        this.configuration = iConfiguration;
        this.xmlSuite = xmlSuite;
        this.useDefaultListeners = bl;
        this.tmpRunnerFactory = iTestRunnerFactory;
        List list2 = list != null ? list : Lists.newArrayList();
        this.setOutputDir(string);
        this.objectFactory = this.configuration.getObjectFactory();
        if (this.objectFactory == null) {
            this.objectFactory = xmlSuite.getObjectFactory();
        }
        this.invokedMethodListeners = Maps.newHashMap();
        if (collection != null) {
            for (IInvokedMethodListener object2 : collection) {
                this.invokedMethodListeners.put(object2.getClass(), object2);
            }
        }
        this.invokedMethodListeners.put(this.getClass(), this);
        this.skipFailedInvocationCounts = xmlSuite.skipFailedInvocationCounts();
        if (null != collection2) {
            this.testListeners.addAll(collection2);
        }
        if (null != collection3) {
            for (IClassListener iClassListener : collection3) {
                this.classListeners.put(iClassListener.getClass(), iClassListener);
            }
        }
        if (null != map) {
            this.dataProviderListeners.putAll(map);
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator must not be null");
        }
        ITestRunnerFactory2 iTestRunnerFactory2 = this.buildRunnerFactory(comparator);
        List<XmlTest> list3 = this.xmlSuite.getTests();
        list3.sort(Comparator.comparingInt(XmlTest::getIndex));
        for (XmlTest xmlTest : list3) {
            TestRunner testRunner = iTestRunnerFactory2.newTestRunner(this, xmlTest, this.invokedMethodListeners.values(), Lists.newArrayList(this.classListeners.values()), this.dataProviderListeners);
            for (IMethodInterceptor iMethodInterceptor : list2) {
                testRunner.addMethodInterceptor(iMethodInterceptor);
            }
            testRunner.addListener(this.textReporter);
            this.testRunners.add(testRunner);
            this.allTestMethods.addAll(Arrays.asList(testRunner.getAllTestMethods()));
        }
    }

    @Override
    public XmlSuite getXmlSuite() {
        return this.xmlSuite;
    }

    @Override
    public String getName() {
        return this.xmlSuite.getName();
    }

    public void setObjectFactory(ITestObjectFactory iTestObjectFactory) {
        this.objectFactory = iTestObjectFactory;
    }

    public void setReportResults(boolean bl) {
        this.useDefaultListeners = bl;
    }

    private void invokeListeners(boolean bl) {
        for (ISuiteListener iSuiteListener : this.listeners.values()) {
            if (bl) {
                iSuiteListener.onStart(this);
                continue;
            }
            iSuiteListener.onFinish(this);
        }
    }

    private void setOutputDir(String string) {
        if (Utils.isStringBlank(string) && this.useDefaultListeners) {
            string = DEFAULT_OUTPUT_DIR;
        }
        this.outputDir = null != string ? new File(string).getAbsolutePath() : null;
    }

    private ITestRunnerFactory2 buildRunnerFactory(Comparator<ITestNGMethod> comparator) {
        ITestRunnerFactory2 iTestRunnerFactory2 = null == this.tmpRunnerFactory ? new DefaultTestRunnerFactory(this.configuration, this.testListeners.toArray(new ITestListener[0]), this.useDefaultListeners, this.skipFailedInvocationCounts, comparator) : new ProxyTestRunnerFactory(this.testListeners.toArray(new ITestListener[0]), this.tmpRunnerFactory);
        return iTestRunnerFactory2;
    }

    @Override
    public String getParallel() {
        return this.xmlSuite.getParallel().toString();
    }

    @Override
    public String getParentModule() {
        return this.xmlSuite.getParentModule();
    }

    @Override
    public String getGuiceStage() {
        return this.xmlSuite.getGuiceStage();
    }

    @Override
    public Injector getParentInjector() {
        return this.parentInjector;
    }

    @Override
    public void setParentInjector(Injector injector) {
        this.parentInjector = injector;
    }

    @Override
    public void run() {
        this.invokeListeners(true);
        try {
            this.privateRun();
        }
        finally {
            this.invokeListeners(false);
        }
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> linkedHashMap = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> linkedHashMap2 = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker iInvoker = null;
        for (TestRunner object : this.testRunners) {
            iInvoker = object.getInvoker();
            for (ITestNGMethod iTestNGMethod : object.getBeforeSuiteMethods()) {
                linkedHashMap.put(iTestNGMethod.getConstructorOrMethod().getMethod(), iTestNGMethod);
            }
            for (ITestNGMethod iTestNGMethod : object.getAfterSuiteMethods()) {
                linkedHashMap2.put(iTestNGMethod.getConstructorOrMethod().getMethod(), iTestNGMethod);
            }
        }
        if (iInvoker != null) {
            if (!linkedHashMap.values().isEmpty()) {
                ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(linkedHashMap.values()).forSuite(this.xmlSuite).usingParameters(this.xmlSuite.getParameters()).build();
                iInvoker.getConfigInvoker().invokeConfigurations(configMethodArguments);
            }
            Utils.log("SuiteRunner", 3, "Created " + this.testRunners.size() + " TestRunners");
            boolean bl = XmlSuite.ParallelMode.TESTS.equals((Object)this.xmlSuite.getParallel());
            if (!bl) {
                this.runSequentially();
            } else {
                this.runInParallelTestMode();
            }
            if (!linkedHashMap2.values().isEmpty()) {
                ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(linkedHashMap2.values()).forSuite(this.xmlSuite).usingParameters(this.xmlSuite.getAllParameters()).build();
                iInvoker.getConfigInvoker().invokeConfigurations(configMethodArguments);
            }
        }
    }

    private void addVisualiser(IExecutionVisualiser iExecutionVisualiser) {
        this.visualisers.add(iExecutionVisualiser);
    }

    private void addReporter(IReporter iReporter) {
        this.reporters.add(iReporter);
    }

    void addConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.configuration.addConfigurationListener(iConfigurationListener);
    }

    public List<IReporter> getReporters() {
        return this.reporters;
    }

    public Collection<IDataProviderListener> getDataProviderListeners() {
        return this.dataProviderListeners.values();
    }

    private void runSequentially() {
        for (TestRunner testRunner : this.testRunners) {
            this.runTest(testRunner);
        }
    }

    private void runTest(TestRunner testRunner) {
        this.visualisers.forEach(testRunner::addListener);
        testRunner.run();
        SuiteResult suiteResult = new SuiteResult(this.xmlSuite, testRunner);
        this.suiteResults.put(testRunner.getName(), suiteResult);
    }

    private void runInParallelTestMode() {
        List list = Lists.newArrayList((int)this.testRunners.size());
        for (TestRunner testRunner : this.testRunners) {
            list.add(new SuiteWorker(testRunner));
        }
        ThreadUtil.execute((String)"tests", (List)list, (int)this.xmlSuite.getThreadCount(), (long)this.xmlSuite.getTimeOut(Integer.MAX_VALUE), (boolean)false);
    }

    protected void addListener(ISuiteListener iSuiteListener) {
        if (!this.listeners.containsKey(iSuiteListener.getClass())) {
            this.listeners.put(iSuiteListener.getClass(), iSuiteListener);
        }
    }

    @Override
    public void addListener(ITestNGListener iTestNGListener) {
        ITestNGListener iTestNGListener2;
        if (iTestNGListener instanceof IInvokedMethodListener) {
            iTestNGListener2 = (IInvokedMethodListener)iTestNGListener;
            this.invokedMethodListeners.put(iTestNGListener2.getClass(), (IInvokedMethodListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof ISuiteListener) {
            this.addListener((ISuiteListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IExecutionVisualiser) {
            this.addVisualiser((IExecutionVisualiser)iTestNGListener);
        }
        if (iTestNGListener instanceof IReporter) {
            this.addReporter((IReporter)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IClassListener && !this.classListeners.containsKey((iTestNGListener2 = (IClassListener)iTestNGListener).getClass())) {
            this.classListeners.put(iTestNGListener2.getClass(), (IClassListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof IDataProviderListener) {
            iTestNGListener2 = (IDataProviderListener)iTestNGListener;
            this.dataProviderListeners.put(iTestNGListener2.getClass(), (IDataProviderListener)iTestNGListener2);
        }
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDir + File.separatorChar + this.getName();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.suiteResults;
    }

    @Override
    public String getParameter(String string) {
        return this.xmlSuite.getParameter(string);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        Map map = Maps.newHashMap();
        for (TestRunner testRunner : this.testRunners) {
            ITestNGMethod[] iTestNGMethodArray;
            for (ITestNGMethod iTestNGMethod : iTestNGMethodArray = testRunner.getAllTestMethods()) {
                String[] stringArray;
                for (String string2 : stringArray = iTestNGMethod.getGroups()) {
                    Collection collection = map.computeIfAbsent(string2, string -> Lists.newArrayList());
                    collection.add(iTestNGMethod);
                }
            }
        }
        return map;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.getIncludedOrExcludedMethods(false);
    }

    private Collection<ITestNGMethod> getIncludedOrExcludedMethods(boolean bl) {
        List list = Lists.newArrayList();
        for (TestRunner testRunner : this.testRunners) {
            Collection<ITestNGMethod> collection = bl ? testRunner.getInvokedMethods() : testRunner.getExcludedMethods();
            list.addAll(collection);
        }
        return list;
    }

    @Override
    public IObjectFactory getObjectFactory() {
        return this.objectFactory instanceof IObjectFactory ? (IObjectFactory)this.objectFactory : null;
    }

    @Override
    public IObjectFactory2 getObjectFactory2() {
        return this.objectFactory instanceof IObjectFactory2 ? (IObjectFactory2)this.objectFactory : null;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder() {
        return this.configuration.getAnnotationFinder();
    }

    public static void ppp(String string) {
        System.out.println("[SuiteRunner] " + string);
    }

    public void setHost(String string) {
        this.remoteHost = string;
    }

    @Override
    public String getHost() {
        return this.remoteHost;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.suiteState;
    }

    public void setSkipFailedInvocationCounts(Boolean bl) {
        if (bl != null) {
            this.skipFailedInvocationCounts = bl;
        }
    }

    @Override
    public Object getAttribute(String string) {
        return this.attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.attributes.removeAttribute(string);
    }

    @Override
    public void afterInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
    }

    @Override
    public void beforeInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (iInvokedMethod == null) {
            throw new NullPointerException("Method should not be null");
        }
        this.invokedMethods.add(iInvokedMethod);
    }

    @Override
    public List<IInvokedMethod> getAllInvokedMethods() {
        return new ArrayList<IInvokedMethod>(this.invokedMethods);
    }

    @Override
    public List<ITestNGMethod> getAllMethods() {
        return this.allTestMethods;
    }

    private static class ProxyTestRunnerFactory
    implements ITestRunnerFactory2 {
        private ITestListener[] failureGenerators;
        private ITestRunnerFactory target;

        public ProxyTestRunnerFactory(ITestListener[] iTestListenerArray, ITestRunnerFactory iTestRunnerFactory) {
            this.failureGenerators = iTestListenerArray;
            this.target = iTestRunnerFactory;
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
            return this.newTestRunner(iSuite, xmlTest, collection, list, Collections.emptyMap());
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map) {
            TestRunner testRunner = this.target instanceof ITestRunnerFactory2 ? ((ITestRunnerFactory2)this.target).newTestRunner(iSuite, xmlTest, collection, list, map) : this.target.newTestRunner(iSuite, xmlTest, collection, list);
            testRunner.addListener((ITestNGListener)new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener iTestListener : this.failureGenerators) {
                testRunner.addListener(iTestListener);
            }
            return testRunner;
        }
    }

    private static class DefaultTestRunnerFactory
    implements ITestRunnerFactory2 {
        private ITestListener[] failureGenerators;
        private boolean useDefaultListeners;
        private boolean skipFailedInvocationCounts;
        private IConfiguration configuration;
        private final Comparator<ITestNGMethod> comparator;

        public DefaultTestRunnerFactory(IConfiguration iConfiguration, ITestListener[] iTestListenerArray, boolean bl, boolean bl2, Comparator<ITestNGMethod> comparator) {
            this.configuration = iConfiguration;
            this.failureGenerators = iTestListenerArray;
            this.useDefaultListeners = bl;
            this.skipFailedInvocationCounts = bl2;
            this.comparator = comparator;
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
            return this.newTestRunner(iSuite, xmlTest, collection, list, Collections.emptyMap());
        }

        @Override
        public TestRunner newTestRunner(ISuite iSuite, XmlTest xmlTest, Collection<IInvokedMethodListener> collection, List<IClassListener> list, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map) {
            boolean bl = this.skipFailedInvocationCounts;
            if (!bl) {
                bl = xmlTest.skipFailedInvocationCounts();
            }
            TestRunner testRunner = new TestRunner(this.configuration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list, this.comparator, map);
            if (this.useDefaultListeners) {
                testRunner.addListener((ITestNGListener)new TestHTMLReporter());
                testRunner.addListener((ITestNGListener)new JUnitXMLReporter());
                testRunner.addListener((ITestNGListener)new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener iTestListener : this.failureGenerators) {
                testRunner.addTestListener(iTestListener);
            }
            for (IConfigurationListener iConfigurationListener : this.configuration.getConfigurationListeners()) {
                testRunner.addConfigurationListener(iConfigurationListener);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private TestRunner testRunner;

        public SuiteWorker(TestRunner testRunner) {
            this.testRunner = testRunner;
        }

        @Override
        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.testRunner);
        }
    }
}

