/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.testng.CommandLineArgs;
import org.testng.IAlterSuiteListener;
import org.testng.IAnnotationTransformer;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IDataProviderListener;
import org.testng.IDynamicGraph;
import org.testng.IExecutionListener;
import org.testng.IExecutionVisualiser;
import org.testng.IHookable;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestObjectFactory;
import org.testng.ITestRunnerFactory;
import org.testng.JarFileUtils;
import org.testng.ReporterConfig;
import org.testng.SuiteRunner;
import org.testng.SuiteRunnerWorker;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.Configuration;
import org.testng.internal.DynamicGraph;
import org.testng.internal.ExitCode;
import org.testng.internal.ExitCodeListener;
import org.testng.internal.IConfiguration;
import org.testng.internal.InstanceCreator;
import org.testng.internal.OverrideProcessor;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.SuiteRunnerMap;
import org.testng.internal.Systematiser;
import org.testng.internal.Utils;
import org.testng.internal.Version;
import org.testng.internal.annotations.DefaultAnnotationTransformer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.JDK15AnnotationFinder;
import org.testng.internal.thread.graph.SuiteWorkerFactory;
import org.testng.junit.JUnitTestFinder;
import org.testng.log4testng.Logger;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.EmailableReporter2;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.JUnitReportReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.reporters.VerboseReporter;
import org.testng.reporters.XMLReporter;
import org.testng.reporters.jq.Main;
import org.testng.thread.IExecutorFactory;
import org.testng.thread.ITestNGThreadPoolExecutor;
import org.testng.thread.IThreadWorkerFactory;
import org.testng.util.Strings;
import org.testng.xml.IPostProcessor;
import org.testng.xml.Parser;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.internal.TestNamesMatcher;
import org.testng.xml.internal.XmlSuiteUtils;

public class TestNG {
    private static final Logger LOGGER = Logger.getLogger(TestNG.class);
    public static final String DEFAULT_COMMAND_LINE_SUITE_NAME = "Command line suite";
    public static final String DEFAULT_COMMAND_LINE_TEST_NAME = "Command line test";
    private static final String DEFAULT_THREADPOOL_FACTORY = "org.testng.internal.thread.DefaultThreadPoolExecutorFactory";
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    private static TestNG m_instance;
    private static JCommander m_jCommander;
    private List<String> m_commandLineMethods;
    protected List<XmlSuite> m_suites = Lists.newArrayList();
    private List<XmlSuite> m_cmdlineSuites;
    private String m_outputDir = "test-output";
    private String[] m_includedGroups;
    private String[] m_excludedGroups;
    private Boolean m_isJUnit = XmlSuite.DEFAULT_JUNIT;
    private Boolean m_isMixed = XmlSuite.DEFAULT_MIXED;
    protected boolean m_useDefaultListeners = true;
    private ITestRunnerFactory m_testRunnerFactory;
    private final Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newHashMap();
    private final Map<Class<? extends ITestListener>, ITestListener> m_testListeners = Maps.newHashMap();
    private final Map<Class<? extends ISuiteListener>, ISuiteListener> m_suiteListeners = Maps.newHashMap();
    private final Map<Class<? extends IReporter>, IReporter> m_reporters = Maps.newHashMap();
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> m_dataProviderListeners = Maps.newHashMap();
    private IExecutorFactory m_executorFactory = null;
    public static final Integer DEFAULT_VERBOSE;
    private int m_threadCount = -1;
    private XmlSuite.ParallelMode m_parallelMode = null;
    private XmlSuite.FailurePolicy m_configFailurePolicy;
    private Class[] m_commandLineTestClasses;
    private String m_defaultSuiteName = "Command line suite";
    private String m_defaultTestName = "Command line test";
    private Map<String, Integer> m_methodDescriptors = Maps.newHashMap();
    private Set<XmlMethodSelector> m_selectors = Sets.newLinkedHashSet();
    private ITestObjectFactory m_objectFactory;
    private final Map<Class<? extends IInvokedMethodListener>, IInvokedMethodListener> m_invokedMethodListeners = Maps.newHashMap();
    private Integer m_dataProviderThreadCount = null;
    private String m_jarPath;
    private String m_xmlPathInJar = "testng.xml";
    private List<String> m_stringSuites = Lists.newArrayList();
    private IHookable m_hookable;
    private IConfigurable m_configurable;
    protected long m_end;
    protected long m_start;
    private final Map<Class<? extends IAlterSuiteListener>, IAlterSuiteListener> m_alterSuiteListeners = Maps.newHashMap();
    private boolean m_isInitialized = false;
    private boolean isSuiteInitialized = false;
    private final ExitCodeListener exitCodeListener = new ExitCodeListener();
    private ExitCode exitCode;
    private final Map<Class<? extends IExecutionVisualiser>, IExecutionVisualiser> m_executionVisualisers = Maps.newHashMap();
    private Integer m_verbose = null;
    private final IAnnotationTransformer m_defaultAnnoProcessor;
    private IAnnotationTransformer m_annotationTransformer = this.m_defaultAnnoProcessor = new DefaultAnnotationTransformer();
    private Boolean m_skipFailedInvocationCounts = false;
    private List<IMethodInterceptor> m_methodInterceptors = Lists.newArrayList();
    private List<String> m_testNames;
    private Integer m_suiteThreadPoolSize = CommandLineArgs.SUITE_THREAD_POOL_SIZE_DEFAULT;
    private boolean m_randomizeSuites = Boolean.FALSE;
    private boolean m_alwaysRun = Boolean.TRUE;
    private Boolean m_preserveOrder = XmlSuite.DEFAULT_PRESERVE_ORDER;
    private Boolean m_groupByInstances;
    private IConfiguration m_configuration;
    private URLClassLoader m_serviceLoaderClassLoader;
    private Map<Class<? extends ITestNGListener>, ITestNGListener> serviceLoaderListeners = Maps.newHashMap();

    public TestNG() {
        this.init(true);
    }

    public TestNG(boolean bl) {
        this.init(bl);
    }

    private void init(boolean bl) {
        m_instance = this;
        this.m_useDefaultListeners = bl;
        this.m_configuration = new Configuration();
    }

    public int getStatus() {
        if (this.exitCodeListener.noTestsFound()) {
            return 8;
        }
        return this.exitCode.getExitCode();
    }

    public void setOutputDirectory(String string) {
        if (Utils.isStringNotEmpty(string)) {
            this.m_outputDir = string;
        }
    }

    public void setUseDefaultListeners(boolean bl) {
        this.m_useDefaultListeners = bl;
    }

    public void setTestJar(String string) {
        this.m_jarPath = string;
    }

    public void setXmlPathInJar(String string) {
        this.m_xmlPathInJar = string;
    }

    private void parseSuiteFiles() {
        OverrideProcessor overrideProcessor = this.getProcessor();
        for (XmlSuite xmlSuite : this.m_suites) {
            if (xmlSuite.isParsed()) continue;
            for (String string : xmlSuite.getSuiteFiles()) {
                try {
                    String string2 = xmlSuite.getFileName();
                    if (string2 == null || string2.trim().isEmpty()) {
                        string2 = string;
                    }
                    Collection collection = Parser.parse((String)string2, (IPostProcessor)overrideProcessor);
                    for (XmlSuite xmlSuite2 : collection) {
                        xmlSuite2.setParentSuite(xmlSuite);
                        xmlSuite.getChildSuites().add(xmlSuite2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.out);
                }
            }
        }
    }

    private OverrideProcessor getProcessor() {
        return new OverrideProcessor(this.m_includedGroups, this.m_excludedGroups);
    }

    private void parseSuite(String string) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("suiteXmlPath: \"" + string + "\"");
        }
        try {
            Collection collection = Parser.parse((String)string, (IPostProcessor)this.getProcessor());
            for (XmlSuite xmlSuite : collection) {
                if (this.m_parallelMode != null) {
                    xmlSuite.setParallel(this.m_parallelMode);
                }
                if (this.m_threadCount > 0) {
                    xmlSuite.setThreadCount(this.m_threadCount);
                }
                if (this.m_testNames == null) {
                    this.m_suites.add(xmlSuite);
                    continue;
                }
                TestNamesMatcher testNamesMatcher = new TestNamesMatcher(xmlSuite, this.m_testNames);
                List list = testNamesMatcher.getMissMatchedTestNames();
                if (!list.isEmpty()) {
                    throw new TestNGException("The test(s) <" + list + "> cannot be found.");
                }
                this.m_suites.addAll(testNamesMatcher.getSuitesMatchingTestNames());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof TestNGException) {
                throw (TestNGException)throwable;
            }
            throw new TestNGException(throwable);
        }
    }

    public void initializeSuitesAndJarFile() {
        Object object;
        if (this.isSuiteInitialized) {
            return;
        }
        this.isSuiteInitialized = true;
        if (!this.m_suites.isEmpty()) {
            this.parseSuiteFiles();
            return;
        }
        for (String object22 : this.m_stringSuites) {
            this.parseSuite(object22);
        }
        if (this.m_jarPath != null && !this.m_stringSuites.isEmpty()) {
            object = new StringBuilder();
            for (String string : this.m_stringSuites) {
                ((StringBuilder)object).append(string);
            }
            Utils.log("TestNG", 2, "Ignoring the XML file inside " + this.m_jarPath + " and using " + object + " instead");
            return;
        }
        if (Utils.isStringEmpty(this.m_jarPath)) {
            return;
        }
        object = new File(this.m_jarPath);
        JarFileUtils jarFileUtils = new JarFileUtils(this.getProcessor(), this.m_xmlPathInJar, this.m_testNames, this.m_parallelMode);
        this.m_suites.addAll(jarFileUtils.extractSuitesFrom((File)object));
    }

    public void setThreadCount(int n) {
        if (n < 1) {
            TestNG.exitWithError("Cannot use a threadCount parameter less than 1; 1 > " + n);
        }
        this.m_threadCount = n;
    }

    @Deprecated
    public void setParallel(String string) {
        if (string == null) {
            this.setParallel(XmlSuite.ParallelMode.NONE);
        } else {
            this.setParallel(XmlSuite.ParallelMode.getValidParallel(string));
        }
    }

    public void setParallel(XmlSuite.ParallelMode parallelMode) {
        this.m_parallelMode = XmlSuite.ParallelMode.skipDeprecatedValues(parallelMode);
    }

    public void setCommandLineSuite(XmlSuite xmlSuite) {
        this.m_cmdlineSuites = Lists.newArrayList();
        this.m_cmdlineSuites.add(xmlSuite);
        this.m_suites.add(xmlSuite);
    }

    public void setTestClasses(Class[] classArray) {
        this.m_suites.clear();
        this.m_commandLineTestClasses = classArray;
    }

    private String[] splitMethod(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            throw new TestNGException("Bad format for command line method:" + string + ", expected <class>.<method>");
        }
        return new String[]{string.substring(0, n), string.substring(n + 1).replaceAll("\\*", "\\.\\*")};
    }

    private List<XmlSuite> createCommandLineSuitesForMethods(List<String> list) {
        Object object;
        Set set = Sets.newHashSet();
        for (String object22 : list) {
            object = ClassHelper.forName(this.splitMethod(object22)[0]);
            if (object == null) continue;
            set.add(object);
        }
        List<XmlSuite> list2 = this.createCommandLineSuitesForClasses(set.toArray(new Class[0]));
        List list3 = Lists.newArrayList();
        object = list2.iterator();
        while (object.hasNext()) {
            Cloneable cloneable = (XmlSuite)object.next();
            for (XmlTest xmlTest : ((XmlSuite)cloneable).getTests()) {
                list3.addAll(xmlTest.getClasses());
            }
        }
        for (Cloneable cloneable : list3) {
            for (String string : list) {
                String[] stringArray = this.splitMethod(string);
                String string2 = stringArray[0];
                if (!((XmlClass)cloneable).getName().equals(string2)) continue;
                XmlInclude xmlInclude = new XmlInclude(stringArray[1]);
                ((XmlClass)cloneable).getIncludedMethods().add(xmlInclude);
            }
        }
        return list2;
    }

    private List<XmlSuite> createCommandLineSuitesForClasses(Class[] classArray) {
        XmlClass[] xmlClassArray = (XmlClass[])Arrays.stream(classArray).map(clazz -> new XmlClass((Class)clazz, true)).toArray(XmlClass[]::new);
        Map map = Maps.newHashMap();
        IAnnotationFinder iAnnotationFinder = this.m_configuration.getAnnotationFinder();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            ITestAnnotation iTestAnnotation = iAnnotationFinder.findAnnotation(clazz2, ITestAnnotation.class);
            String string = this.getDefaultSuiteName();
            String string2 = this.getDefaultTestName();
            boolean bl = false;
            if (iTestAnnotation != null) {
                string = Utils.defaultIfStringEmpty(iTestAnnotation.getSuiteName(), string);
                string2 = Utils.defaultIfStringEmpty(iTestAnnotation.getTestName(), string2);
            } else if (this.m_isMixed.booleanValue() && JUnitTestFinder.isJUnitTest(clazz2)) {
                bl = true;
                string2 = clazz2.getName();
            }
            XmlSuite xmlSuite = (XmlSuite)map.get(string);
            if (xmlSuite == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(string);
                map.put(string, xmlSuite);
            }
            if (this.m_dataProviderThreadCount != null) {
                xmlSuite.setDataProviderThreadCount(this.m_dataProviderThreadCount);
            }
            XmlTest xmlTest = null;
            for (XmlTest xmlTest2 : xmlSuite.getTests()) {
                if (!xmlTest2.getName().equals(string2)) continue;
                xmlTest = xmlTest2;
                break;
            }
            if (xmlTest == null) {
                xmlTest = new XmlTest(xmlSuite);
                xmlTest.setName(string2);
                xmlTest.setJUnit(bl);
            }
            xmlTest.getXmlClasses().add(xmlClassArray[i]);
        }
        return new ArrayList<XmlSuite>(map.values());
    }

    public void addMethodSelector(String string, int n) {
        if (Strings.isNotNullAndNotEmpty(string)) {
            this.m_methodDescriptors.put(string, n);
        }
    }

    public void addMethodSelector(XmlMethodSelector xmlMethodSelector) {
        this.m_selectors.add(xmlMethodSelector);
    }

    public void setTestSuites(List<String> list) {
        this.m_stringSuites = list;
    }

    public void setXmlSuites(List<XmlSuite> list) {
        this.m_suites = list;
    }

    public void setExcludedGroups(String string) {
        this.m_excludedGroups = Utils.split(string, ",");
    }

    public void setGroups(String string) {
        this.m_includedGroups = Utils.split(string, ",");
    }

    private void setTestRunnerFactoryClass(Class clazz) {
        this.setTestRunnerFactory((ITestRunnerFactory)ClassHelper.newInstance(clazz));
    }

    protected void setTestRunnerFactory(ITestRunnerFactory iTestRunnerFactory) {
        this.m_testRunnerFactory = iTestRunnerFactory;
    }

    public void setObjectFactory(Class clazz) {
        this.m_objectFactory = (ITestObjectFactory)ClassHelper.newInstance(clazz);
    }

    public void setObjectFactory(ITestObjectFactory iTestObjectFactory) {
        this.m_objectFactory = iTestObjectFactory;
    }

    public void setListenerClasses(List<Class<? extends ITestNGListener>> list) {
        for (Class<? extends ITestNGListener> clazz : list) {
            this.addListener(ClassHelper.newInstance(clazz));
        }
    }

    @Deprecated
    public void addListener(Object object) {
        if (!(object instanceof ITestNGListener)) {
            TestNG.exitWithError("Listener " + object + " must be one of ITestListener, ISuiteListener, IReporter,  IAnnotationTransformer, IMethodInterceptor or IInvokedMethodListener");
        }
        this.addListener((ITestNGListener)object);
    }

    private static <E> void maybeAddListener(Map<Class<? extends E>, E> map, E e) {
        TestNG.maybeAddListener(map, e.getClass(), e, false);
    }

    private static <E> void maybeAddListener(Map<Class<? extends E>, E> map, Class<? extends E> clazz, E e, boolean bl) {
        if (map.containsKey(clazz)) {
            if (!bl) {
                LOGGER.warn("Ignoring duplicate listener : " + clazz.getName());
            }
        } else {
            map.put(clazz, e);
        }
    }

    public void addListener(ITestNGListener iTestNGListener) {
        ITestNGListener iTestNGListener2;
        if (iTestNGListener == null) {
            return;
        }
        if (iTestNGListener instanceof IExecutionVisualiser) {
            iTestNGListener2 = (IExecutionVisualiser)iTestNGListener;
            TestNG.maybeAddListener(this.m_executionVisualisers, iTestNGListener2);
        }
        if (iTestNGListener instanceof ISuiteListener) {
            iTestNGListener2 = (ISuiteListener)iTestNGListener;
            TestNG.maybeAddListener(this.m_suiteListeners, iTestNGListener2);
        }
        if (iTestNGListener instanceof ITestListener) {
            iTestNGListener2 = (ITestListener)iTestNGListener;
            TestNG.maybeAddListener(this.m_testListeners, iTestNGListener2);
        }
        if (iTestNGListener instanceof IClassListener) {
            iTestNGListener2 = (IClassListener)iTestNGListener;
            TestNG.maybeAddListener(this.m_classListeners, iTestNGListener2);
        }
        if (iTestNGListener instanceof IReporter) {
            iTestNGListener2 = (IReporter)iTestNGListener;
            TestNG.maybeAddListener(this.m_reporters, iTestNGListener2);
        }
        if (iTestNGListener instanceof IAnnotationTransformer) {
            this.setAnnotationTransformer((IAnnotationTransformer)iTestNGListener);
        }
        if (iTestNGListener instanceof IMethodInterceptor) {
            this.m_methodInterceptors.add((IMethodInterceptor)iTestNGListener);
        }
        if (iTestNGListener instanceof IInvokedMethodListener) {
            iTestNGListener2 = (IInvokedMethodListener)iTestNGListener;
            TestNG.maybeAddListener(this.m_invokedMethodListeners, iTestNGListener2);
        }
        if (iTestNGListener instanceof IHookable) {
            this.setHookable((IHookable)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurable) {
            this.setConfigurable((IConfigurable)iTestNGListener);
        }
        if (iTestNGListener instanceof IExecutionListener) {
            this.m_configuration.addExecutionListenerIfAbsent((IExecutionListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurationListener) {
            this.m_configuration.addConfigurationListener((IConfigurationListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IAlterSuiteListener) {
            iTestNGListener2 = (IAlterSuiteListener)iTestNGListener;
            TestNG.maybeAddListener(this.m_alterSuiteListeners, iTestNGListener2);
        }
        if (iTestNGListener instanceof IDataProviderListener) {
            iTestNGListener2 = (IDataProviderListener)iTestNGListener;
            TestNG.maybeAddListener(this.m_dataProviderListeners, iTestNGListener2);
        }
    }

    public Set<IReporter> getReporters() {
        return Sets.newHashSet(this.m_reporters.values());
    }

    public List<ITestListener> getTestListeners() {
        return Lists.newArrayList(this.m_testListeners.values());
    }

    public List<ISuiteListener> getSuiteListeners() {
        return Lists.newArrayList(this.m_suiteListeners.values());
    }

    public void setVerbose(int n) {
        this.m_verbose = n;
    }

    public void setExecutorFactoryClass(String string) {
        this.m_executorFactory = this.createExecutorFactoryInstanceUsing(string);
    }

    private IExecutorFactory createExecutorFactoryInstanceUsing(String string) {
        Class<?> clazz = ClassHelper.forName(string);
        Object object = InstanceCreator.newInstance(clazz);
        if (object instanceof IExecutorFactory) {
            return (IExecutorFactory)object;
        }
        throw new IllegalArgumentException(string + " does not implement " + IExecutorFactory.class.getName());
    }

    public void setExecutorFactory(IExecutorFactory iExecutorFactory) {
        this.m_executorFactory = iExecutorFactory;
    }

    public IExecutorFactory getExecutorFactory() {
        if (this.m_executorFactory == null) {
            this.m_executorFactory = this.createExecutorFactoryInstanceUsing(DEFAULT_THREADPOOL_FACTORY);
        }
        return this.m_executorFactory;
    }

    private void initializeCommandLineSuites() {
        if (this.m_commandLineTestClasses != null || this.m_commandLineMethods != null) {
            this.m_cmdlineSuites = null != this.m_commandLineMethods ? this.createCommandLineSuitesForMethods(this.m_commandLineMethods) : this.createCommandLineSuitesForClasses(this.m_commandLineTestClasses);
            for (XmlSuite xmlSuite : this.m_cmdlineSuites) {
                for (XmlTest xmlTest : xmlSuite.getTests()) {
                    xmlTest.setPreserveOrder(this.m_preserveOrder);
                }
                this.m_suites.add(xmlSuite);
                if (this.m_groupByInstances == null) continue;
                xmlSuite.setGroupByInstances(this.m_groupByInstances);
            }
        }
    }

    private void initializeCommandLineSuitesParams() {
        if (null == this.m_cmdlineSuites) {
            return;
        }
        for (XmlSuite xmlSuite : this.m_cmdlineSuites) {
            if (this.m_threadCount != -1) {
                xmlSuite.setThreadCount(this.m_threadCount);
            }
            if (this.m_parallelMode != null) {
                xmlSuite.setParallel(this.m_parallelMode);
            }
            if (this.m_configFailurePolicy == null) continue;
            xmlSuite.setConfigFailurePolicy(this.m_configFailurePolicy);
        }
    }

    private void initializeCommandLineSuitesGroups() {
        List<XmlSuite> list;
        boolean bl = null != this.m_includedGroups && this.m_includedGroups.length > 0;
        boolean bl2 = null != this.m_excludedGroups && this.m_excludedGroups.length > 0;
        List<XmlSuite> list2 = list = this.m_cmdlineSuites != null ? this.m_cmdlineSuites : this.m_suites;
        if (bl || bl2) {
            for (XmlSuite xmlSuite : list) {
                TestNG.initializeCommandLineSuitesGroups(xmlSuite, bl, this.m_includedGroups, bl2, this.m_excludedGroups);
            }
        }
    }

    private static void initializeCommandLineSuitesGroups(XmlSuite xmlSuite, boolean bl, String[] stringArray, boolean bl2, String[] stringArray2) {
        if (bl) {
            xmlSuite.setIncludedGroups(Arrays.asList(stringArray));
        }
        if (bl2) {
            xmlSuite.setExcludedGroups(Arrays.asList(stringArray2));
        }
        for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
            TestNG.initializeCommandLineSuitesGroups(xmlSuite2, bl, stringArray, bl2, stringArray2);
        }
    }

    private void addReporter(Class<? extends IReporter> clazz) {
        if (!this.m_reporters.containsKey(clazz)) {
            this.m_reporters.put(clazz, ClassHelper.newInstance(clazz));
        }
    }

    private void initializeDefaultListeners() {
        this.addListener(this.exitCodeListener);
        if (this.m_useDefaultListeners) {
            this.addReporter(SuiteHTMLReporter.class);
            this.addReporter(Main.class);
            this.addReporter(FailedReporter.class);
            this.addReporter(XMLReporter.class);
            if (RuntimeBehavior.useOldTestNGEmailableReporter()) {
                this.addReporter(EmailableReporter.class);
            } else if (RuntimeBehavior.useEmailableReporter()) {
                this.addReporter(EmailableReporter2.class);
            }
            this.addReporter(JUnitReportReporter.class);
            if (this.m_verbose != null && this.m_verbose > 4) {
                this.addListener((ITestNGListener)new VerboseReporter("[TestNG] "));
            }
        }
    }

    private void initializeConfiguration() {
        ITestObjectFactory iTestObjectFactory = this.m_objectFactory;
        this.addServiceLoaderListeners();
        for (XmlSuite xmlSuite : this.m_suites) {
            this.addListeners(xmlSuite);
            for (XmlMethodSelector xmlMethodSelector : xmlSuite.getMethodSelectors()) {
                this.addMethodSelector(xmlMethodSelector.getClassName(), xmlMethodSelector.getPriority());
                this.addMethodSelector(xmlMethodSelector);
            }
            if (xmlSuite.getObjectFactory() == null) continue;
            if (iTestObjectFactory == null) {
                iTestObjectFactory = xmlSuite.getObjectFactory();
                continue;
            }
            throw new TestNGException("Found more than one object-factory tag in your suites");
        }
        this.m_configuration.setAnnotationFinder((IAnnotationFinder)new JDK15AnnotationFinder(this.getAnnotationTransformer()));
        this.m_configuration.setHookable(this.m_hookable);
        this.m_configuration.setConfigurable(this.m_configurable);
        this.m_configuration.setObjectFactory(iTestObjectFactory);
        this.m_configuration.setAlwaysRunListeners(this.m_alwaysRun);
        this.m_configuration.setExecutorFactory(this.getExecutorFactory());
    }

    private void addListeners(XmlSuite xmlSuite) {
        Class<?> clazz;
        for (String object2 : xmlSuite.getListeners()) {
            clazz = ClassHelper.forName(object2);
            if (clazz == null) {
                throw new TestNGException("Listener " + object2 + " was not found in project's classpath");
            }
            ITestNGListener iTestNGListener = (ITestNGListener)ClassHelper.newInstance(clazz);
            this.addListener(iTestNGListener);
        }
        List<XmlSuite> list = xmlSuite.getChildSuites();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            clazz = (XmlSuite)iterator.next();
            this.addListeners((XmlSuite)((Object)clazz));
        }
    }

    private void addServiceLoaderListeners() {
        ServiceLoader<ITestNGListener> serviceLoader = this.m_serviceLoaderClassLoader != null ? ServiceLoader.load(ITestNGListener.class, this.m_serviceLoaderClassLoader) : ServiceLoader.load(ITestNGListener.class);
        for (ITestNGListener iTestNGListener : serviceLoader) {
            Utils.log("[TestNG]", 2, "Adding ServiceLoader listener:" + iTestNGListener);
            this.addListener(iTestNGListener);
            this.addServiceLoaderListener(iTestNGListener);
        }
    }

    private void sanityCheck() {
        XmlSuiteUtils.validateIfSuitesContainDuplicateTests(this.m_suites);
        XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(this.m_suites);
    }

    public void initializeEverything() {
        if (this.m_isInitialized) {
            return;
        }
        this.initializeSuitesAndJarFile();
        this.initializeConfiguration();
        this.initializeDefaultListeners();
        this.initializeCommandLineSuites();
        this.initializeCommandLineSuitesParams();
        this.initializeCommandLineSuitesGroups();
        this.m_isInitialized = true;
    }

    public void run() {
        this.initializeEverything();
        this.sanityCheck();
        this.runExecutionListeners(true);
        this.runSuiteAlterationListeners();
        this.m_start = System.currentTimeMillis();
        List<ISuite> list = this.runSuites();
        this.m_end = System.currentTimeMillis();
        if (null != list) {
            this.generateReports(list);
        }
        this.runExecutionListeners(false);
        this.exitCode = this.exitCodeListener.getStatus();
        if (this.exitCodeListener.noTestsFound() && TestRunner.getVerbose() > 1) {
            System.err.println("[TestNG] No tests found. Nothing was run");
            TestNG.usage();
        }
        m_instance = null;
        m_jCommander = null;
    }

    protected List<ISuite> runSuites() {
        return this.runSuitesLocally();
    }

    private void runSuiteAlterationListeners() {
        for (IAlterSuiteListener iAlterSuiteListener : this.m_alterSuiteListeners.values()) {
            iAlterSuiteListener.alter(this.m_suites);
        }
    }

    private void runExecutionListeners(boolean bl) {
        for (IExecutionListener iExecutionListener : this.m_configuration.getExecutionListeners()) {
            if (bl) {
                iExecutionListener.onExecutionStart();
                continue;
            }
            iExecutionListener.onExecutionFinish();
        }
    }

    private static void usage() {
        if (m_jCommander == null) {
            m_jCommander = new JCommander((Object)new CommandLineArgs());
        }
        m_jCommander.usage();
    }

    private void generateReports(List<ISuite> list) {
        for (IReporter iReporter : this.m_reporters.values()) {
            try {
                long l = System.currentTimeMillis();
                iReporter.generateReport(this.m_suites, list, this.m_outputDir);
                Utils.log("TestNG", 2, "Time taken by " + iReporter + ": " + (System.currentTimeMillis() - l) + " ms");
            }
            catch (Exception exception) {
                System.err.println("[TestNG] Reporter " + iReporter + " failed");
                exception.printStackTrace(System.err);
            }
        }
    }

    public List<ISuite> runSuitesLocally() {
        if (this.m_suites.isEmpty()) {
            TestNG.error("No test suite found. Nothing to run");
            TestNG.usage();
            return Collections.emptyList();
        }
        SuiteRunnerMap suiteRunnerMap = new SuiteRunnerMap();
        if (this.m_suites.get(0).getVerbose() >= 2) {
            Version.displayBanner();
        }
        for (XmlSuite object22 : this.m_suites) {
            this.createSuiteRunners(suiteRunnerMap, object22);
        }
        if (this.m_suiteThreadPoolSize == 1 && !this.m_randomizeSuites) {
            for (XmlSuite xmlSuite : this.m_suites) {
                this.runSuitesSequentially(xmlSuite, suiteRunnerMap, this.getVerbose(xmlSuite), this.getDefaultSuiteName());
            }
            return Lists.newArrayList(suiteRunnerMap.values());
        }
        Iterator<XmlSuite> iterator = new DynamicGraph();
        for (XmlSuite xmlSuite : this.m_suites) {
            this.populateSuiteGraph((IDynamicGraph<ISuite>)((Object)iterator), suiteRunnerMap, xmlSuite);
        }
        SuiteWorkerFactory suiteWorkerFactory = new SuiteWorkerFactory(suiteRunnerMap, Integer.valueOf(0), this.getDefaultSuiteName());
        ITestNGThreadPoolExecutor iTestNGThreadPoolExecutor = this.getExecutorFactory().newSuiteExecutor("suites", (IDynamicGraph<ISuite>)((Object)iterator), (IThreadWorkerFactory<ISuite>)suiteWorkerFactory, this.m_suiteThreadPoolSize, this.m_suiteThreadPoolSize, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(), null);
        Utils.log("TestNG", 2, "Starting executor for all suites");
        iTestNGThreadPoolExecutor.run();
        try {
            iTestNGThreadPoolExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            iTestNGThreadPoolExecutor.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            TestNG.error("Error waiting for concurrent executors to finish " + interruptedException.getMessage());
        }
        return Lists.newArrayList(suiteRunnerMap.values());
    }

    private static void error(String string) {
        LOGGER.error(string);
    }

    private int getVerbose(XmlSuite xmlSuite) {
        return xmlSuite.getVerbose() != null ? xmlSuite.getVerbose() : (this.m_verbose != null ? this.m_verbose : DEFAULT_VERBOSE);
    }

    private void runSuitesSequentially(XmlSuite xmlSuite, SuiteRunnerMap suiteRunnerMap, int n, String string) {
        for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
            this.runSuitesSequentially(xmlSuite2, suiteRunnerMap, n, string);
        }
        SuiteRunnerWorker suiteRunnerWorker = new SuiteRunnerWorker(suiteRunnerMap.get(xmlSuite), suiteRunnerMap, n, string);
        suiteRunnerWorker.run();
    }

    private void populateSuiteGraph(IDynamicGraph<ISuite> iDynamicGraph, SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        ISuite iSuite = suiteRunnerMap.get(xmlSuite);
        if (xmlSuite.getChildSuites().isEmpty()) {
            iDynamicGraph.addNode(iSuite);
        } else {
            for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
                iDynamicGraph.addEdge(0, iSuite, suiteRunnerMap.get(xmlSuite2));
                this.populateSuiteGraph(iDynamicGraph, suiteRunnerMap, xmlSuite2);
            }
        }
    }

    private void createSuiteRunners(SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        if (null != this.m_isJUnit && !this.m_isJUnit.equals(XmlSuite.DEFAULT_JUNIT)) {
            xmlSuite.setJUnit(this.m_isJUnit);
        }
        if (null != this.m_skipFailedInvocationCounts) {
            xmlSuite.setSkipFailedInvocationCounts(this.m_skipFailedInvocationCounts);
        }
        if (this.m_verbose != null) {
            xmlSuite.setVerbose(this.m_verbose);
        }
        if (null != this.m_configFailurePolicy) {
            xmlSuite.setConfigFailurePolicy(this.m_configFailurePolicy);
        }
        for (XmlTest cloneable : xmlSuite.getTests()) {
            for (Map.Entry<String, Integer> entry : this.m_methodDescriptors.entrySet()) {
                XmlMethodSelector xmlMethodSelector = new XmlMethodSelector();
                xmlMethodSelector.setName(entry.getKey());
                xmlMethodSelector.setPriority(entry.getValue());
                cloneable.getMethodSelectors().add(xmlMethodSelector);
            }
            for (XmlMethodSelector xmlMethodSelector : this.m_selectors) {
                cloneable.getMethodSelectors().add(xmlMethodSelector);
            }
        }
        suiteRunnerMap.put(xmlSuite, this.createSuiteRunner(xmlSuite));
        for (XmlSuite xmlSuite2 : xmlSuite.getChildSuites()) {
            this.createSuiteRunners(suiteRunnerMap, xmlSuite2);
        }
    }

    private SuiteRunner createSuiteRunner(XmlSuite xmlSuite) {
        SuiteRunner suiteRunner = new SuiteRunner(this.getConfiguration(), xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_useDefaultListeners, this.m_methodInterceptors, this.m_invokedMethodListeners.values(), this.m_testListeners.values(), this.m_classListeners.values(), this.m_dataProviderListeners, Systematiser.getComparator());
        for (ISuiteListener iTestNGListener : this.m_suiteListeners.values()) {
            suiteRunner.addListener(iTestNGListener);
        }
        for (IReporter iReporter : suiteRunner.getReporters()) {
            TestNG.maybeAddListener(this.m_reporters, iReporter.getClass(), iReporter, true);
        }
        for (IConfigurationListener iConfigurationListener : this.m_configuration.getConfigurationListeners()) {
            suiteRunner.addConfigurationListener(iConfigurationListener);
        }
        this.m_executionVisualisers.values().forEach(suiteRunner::addListener);
        return suiteRunner;
    }

    protected IConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public static void main(String[] stringArray) {
        TestNG testNG = TestNG.privateMain(stringArray, null);
        System.exit(testNG.getStatus());
    }

    public static TestNG privateMain(String[] stringArray, ITestListener iTestListener) {
        TestNG testNG = new TestNG();
        if (null != iTestListener) {
            testNG.addListener(iTestListener);
        }
        try {
            CommandLineArgs commandLineArgs = new CommandLineArgs();
            m_jCommander = new JCommander((Object)commandLineArgs);
            m_jCommander.parse(stringArray);
            TestNG.validateCommandLineParameters(commandLineArgs);
            testNG.configure(commandLineArgs);
        }
        catch (ParameterException parameterException) {
            TestNG.exitWithError(parameterException.getMessage());
        }
        try {
            testNG.run();
        }
        catch (TestNGException testNGException) {
            if (TestRunner.getVerbose() > 1) {
                testNGException.printStackTrace(System.out);
            } else {
                TestNG.error(testNGException.getMessage());
            }
            testNG.exitCode = ExitCode.newExitCodeRepresentingFailure();
        }
        return testNG;
    }

    /*
     * WARNING - void declaration
     */
    protected void configure(CommandLineArgs commandLineArgs) {
        Object object3;
        if (commandLineArgs.verbose != null) {
            this.setVerbose(commandLineArgs.verbose);
        }
        if (commandLineArgs.threadPoolFactoryClass != null) {
            this.setExecutorFactoryClass(commandLineArgs.threadPoolFactoryClass);
        }
        this.setOutputDirectory(commandLineArgs.outputDirectory);
        String string = commandLineArgs.testClass;
        if (null != string) {
            object3 = string.split(",");
            List object2 = Lists.newArrayList();
            for (String string2 : object3) {
                object2.add(ClassHelper.fileToClass(string2));
            }
            this.setTestClasses(object2.toArray(new Class[0]));
        }
        this.setOutputDirectory(commandLineArgs.outputDirectory);
        if (commandLineArgs.testNames != null) {
            this.setTestNames(Arrays.asList(commandLineArgs.testNames.split(",")));
        }
        if (commandLineArgs.useDefaultListeners != null) {
            this.setUseDefaultListeners("true".equalsIgnoreCase(commandLineArgs.useDefaultListeners));
        }
        this.setGroups(commandLineArgs.groups);
        this.setExcludedGroups(commandLineArgs.excludedGroups);
        this.setTestJar(commandLineArgs.testJar);
        this.setXmlPathInJar(commandLineArgs.xmlPathInJar);
        this.setJUnit(commandLineArgs.junit);
        this.setMixed(commandLineArgs.mixed);
        this.setSkipFailedInvocationCounts(commandLineArgs.skipFailedInvocationCounts);
        if (commandLineArgs.parallelMode != null) {
            this.setParallel(commandLineArgs.parallelMode);
        }
        if (commandLineArgs.configFailurePolicy != null) {
            this.setConfigFailurePolicy(XmlSuite.FailurePolicy.getValidPolicy(commandLineArgs.configFailurePolicy));
        }
        if (commandLineArgs.threadCount != null) {
            this.setThreadCount(commandLineArgs.threadCount);
        }
        if (commandLineArgs.dataProviderThreadCount != null) {
            this.setDataProviderThreadCount(commandLineArgs.dataProviderThreadCount);
        }
        if (commandLineArgs.suiteName != null) {
            this.setDefaultSuiteName(commandLineArgs.suiteName);
        }
        if (commandLineArgs.testName != null) {
            this.setDefaultTestName(commandLineArgs.testName);
        }
        if (commandLineArgs.listener != null) {
            object3 = ";";
            if (commandLineArgs.listener.contains(",")) {
                object3 = ",";
            }
            String[] stringArray = Utils.split(commandLineArgs.listener, (String)object3);
            List list = Lists.newArrayList();
            for (String string3 : stringArray) {
                Class<?> clazz = ClassHelper.fileToClass(string3);
                if (!ITestNGListener.class.isAssignableFrom(clazz)) continue;
                list.add(clazz);
            }
            this.setListenerClasses(list);
        }
        if (null != commandLineArgs.methodSelectors) {
            void var6_13;
            Object object = object3 = Utils.split(commandLineArgs.methodSelectors, ",");
            int n = ((String[])object).length;
            boolean bl = false;
            while (var6_13 < n) {
                String string4 = object[var6_13];
                String[] stringArray = Utils.split(string4, ":");
                try {
                    if (stringArray.length == 2) {
                        this.addMethodSelector(stringArray[0], Integer.parseInt(stringArray[1]));
                    } else {
                        TestNG.error("Method selector value was not in the format org.example.Selector:4");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    TestNG.error("Method selector value was not in the format org.example.Selector:4");
                }
                ++var6_13;
            }
        }
        if (commandLineArgs.objectFactory != null) {
            this.setObjectFactory(ClassHelper.fileToClass(commandLineArgs.objectFactory));
        }
        if (commandLineArgs.testRunnerFactory != null) {
            this.setTestRunnerFactoryClass(ClassHelper.fileToClass(commandLineArgs.testRunnerFactory));
        }
        if (commandLineArgs.reporter != null) {
            object3 = ReporterConfig.deserialize(commandLineArgs.reporter);
            this.addReporter((ReporterConfig)object3);
        }
        if (commandLineArgs.commandLineMethods.size() > 0) {
            this.m_commandLineMethods = commandLineArgs.commandLineMethods;
        }
        if (commandLineArgs.suiteFiles != null) {
            this.setTestSuites(commandLineArgs.suiteFiles);
        }
        this.setSuiteThreadPoolSize(commandLineArgs.suiteThreadPoolSize);
        this.setRandomizeSuites(commandLineArgs.randomizeSuites);
        this.alwaysRunListeners(commandLineArgs.alwaysRunListeners);
    }

    public void setSuiteThreadPoolSize(Integer n) {
        this.m_suiteThreadPoolSize = n;
    }

    public Integer getSuiteThreadPoolSize() {
        return this.m_suiteThreadPoolSize;
    }

    public void setRandomizeSuites(boolean bl) {
        this.m_randomizeSuites = bl;
    }

    public void alwaysRunListeners(boolean bl) {
        this.m_alwaysRun = bl;
    }

    public void setSourcePath(String string) {
    }

    private static int parseInt(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof String) {
            return Integer.parseInt(String.valueOf(object));
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IllegalArgumentException("Unable to parse " + object + " as an Integer.");
    }

    @Deprecated
    public void configure(Map map) {
        String string;
        String string2;
        String string3;
        String string4;
        Object v;
        String string5;
        String string6;
        String string7;
        String string8;
        CommandLineArgs commandLineArgs = new CommandLineArgs();
        int n = TestNG.parseInt(map.get("-log"));
        if (n != -1) {
            commandLineArgs.verbose = n;
        }
        commandLineArgs.outputDirectory = (String)map.get("-d");
        String string9 = (String)map.get("-testclass");
        if (null != string9) {
            commandLineArgs.testClass = string9;
        }
        if ((string8 = (String)map.get("-testnames")) != null) {
            commandLineArgs.testNames = string8;
        }
        if (null != (string7 = (String)map.get("-usedefaultlisteners"))) {
            commandLineArgs.useDefaultListeners = string7;
        }
        commandLineArgs.groups = (String)map.get("-groups");
        commandLineArgs.excludedGroups = (String)map.get("-excludegroups");
        commandLineArgs.testJar = (String)map.get("-testjar");
        commandLineArgs.xmlPathInJar = (String)map.get("-xmlpathinjar");
        commandLineArgs.junit = (Boolean)map.get("-junit");
        commandLineArgs.mixed = (Boolean)map.get("-mixed");
        commandLineArgs.skipFailedInvocationCounts = (Boolean)map.get("-skipfailedinvocationcounts");
        String string10 = (String)map.get("-parallel");
        if (string10 != null) {
            commandLineArgs.parallelMode = XmlSuite.ParallelMode.getValidParallel(string10);
        }
        if ((n = TestNG.parseInt(map.get("-threadcount"))) != -1) {
            commandLineArgs.threadCount = n;
        }
        if ((n = TestNG.parseInt(map.get("-dataproviderthreadcount"))) != -1) {
            commandLineArgs.dataProviderThreadCount = n;
        }
        if ((string6 = (String)map.get("-suitename")) != null) {
            commandLineArgs.suiteName = string6;
        }
        if ((string5 = (String)map.get("-testname")) != null) {
            commandLineArgs.testName = string5;
        }
        commandLineArgs.listener = (v = map.get("-listener")) instanceof List ? Utils.join((List)v, ",") : (String)v;
        String string11 = (String)map.get("-methodselectors");
        if (null != string11) {
            commandLineArgs.methodSelectors = string11;
        }
        if (null != (string4 = (String)map.get("-objectfactory"))) {
            commandLineArgs.objectFactory = string4;
        }
        if (null != (string3 = (String)map.get("-testrunfactory"))) {
            commandLineArgs.testRunnerFactory = string3;
        }
        if ((string2 = (String)map.get("-reporter")) != null) {
            commandLineArgs.reporter = string2;
        }
        if ((string = (String)map.get("-configfailurepolicy")) != null) {
            commandLineArgs.configFailurePolicy = string;
        }
        if ((n = TestNG.parseInt(map.get("-suitethreadpoolsize"))) != -1) {
            commandLineArgs.suiteThreadPoolSize = n;
        }
        this.configure(commandLineArgs);
    }

    public void setTestNames(List<String> list) {
        this.m_testNames = list;
    }

    public void setSkipFailedInvocationCounts(Boolean bl) {
        this.m_skipFailedInvocationCounts = bl;
    }

    private void addReporter(ReporterConfig reporterConfig) {
        IReporter iReporter = reporterConfig.newReporterInstance();
        if (iReporter != null) {
            this.addListener(iReporter);
        } else {
            LOGGER.warn("Could not find reporter class : " + reporterConfig.getClassName());
        }
    }

    public void setJUnit(Boolean bl) {
        this.m_isJUnit = bl;
    }

    public void setMixed(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.m_isMixed = bl;
    }

    protected static void validateCommandLineParameters(CommandLineArgs commandLineArgs) {
        String string = commandLineArgs.testClass;
        List<String> list = commandLineArgs.suiteFiles;
        String string2 = commandLineArgs.testJar;
        List<String> list2 = commandLineArgs.commandLineMethods;
        if (string == null && string2 == null && (list == null || list.isEmpty()) && (list2 == null || list2.isEmpty())) {
            throw new ParameterException("You need to specify at least one testng.xml, one class or one method");
        }
        String string3 = commandLineArgs.groups;
        String string4 = commandLineArgs.excludedGroups;
        if (!(string2 != null || null == string3 && null == string4 || string != null || list != null && !list.isEmpty())) {
            throw new ParameterException("Groups option should be used with testclass option");
        }
        Boolean bl = commandLineArgs.junit;
        Boolean bl2 = commandLineArgs.mixed;
        if (bl.booleanValue() && bl2.booleanValue()) {
            throw new ParameterException("-mixed can't be combined with -junit");
        }
    }

    public boolean hasFailure() {
        return this.exitCode.hasFailure();
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return this.exitCode.hasFailureWithinSuccessPercentage();
    }

    public boolean hasSkip() {
        return this.exitCode.hasSkip();
    }

    static void exitWithError(String string) {
        System.err.println(string);
        TestNG.usage();
        System.exit(1);
    }

    public String getOutputDirectory() {
        return this.m_outputDir;
    }

    public IAnnotationTransformer getAnnotationTransformer() {
        return this.m_annotationTransformer;
    }

    private void setAnnotationTransformer(IAnnotationTransformer iAnnotationTransformer) {
        if (this.m_annotationTransformer != this.m_defaultAnnoProcessor && this.m_annotationTransformer != iAnnotationTransformer) {
            LOGGER.warn("AnnotationTransformer already set");
        }
        this.m_annotationTransformer = iAnnotationTransformer;
    }

    public String getDefaultSuiteName() {
        return this.m_defaultSuiteName;
    }

    public void setDefaultSuiteName(String string) {
        this.m_defaultSuiteName = string;
    }

    public String getDefaultTestName() {
        return this.m_defaultTestName;
    }

    public void setDefaultTestName(String string) {
        this.m_defaultTestName = string;
    }

    public void setConfigFailurePolicy(XmlSuite.FailurePolicy failurePolicy) {
        this.m_configFailurePolicy = failurePolicy;
    }

    public XmlSuite.FailurePolicy getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    @Deprecated
    public static TestNG getDefault() {
        return m_instance;
    }

    private void setConfigurable(IConfigurable iConfigurable) {
        if (this.m_configurable != null && this.m_configurable != iConfigurable) {
            LOGGER.warn("Configurable already set");
        }
        this.m_configurable = iConfigurable;
    }

    private void setHookable(IHookable iHookable) {
        if (this.m_hookable != null && this.m_hookable != iHookable) {
            LOGGER.warn("Hookable already set");
        }
        this.m_hookable = iHookable;
    }

    public void setMethodInterceptor(IMethodInterceptor iMethodInterceptor) {
        this.m_methodInterceptors.add(iMethodInterceptor);
    }

    public void setDataProviderThreadCount(int n) {
        this.m_dataProviderThreadCount = n;
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            ClassHelper.addClassLoader(classLoader);
        }
    }

    public void setPreserveOrder(boolean bl) {
        this.m_preserveOrder = bl;
    }

    protected long getStart() {
        return this.m_start;
    }

    protected long getEnd() {
        return this.m_end;
    }

    public void setGroupByInstances(boolean bl) {
        this.m_groupByInstances = bl;
    }

    public void setServiceLoaderClassLoader(URLClassLoader uRLClassLoader) {
        this.m_serviceLoaderClassLoader = uRLClassLoader;
    }

    private void addServiceLoaderListener(ITestNGListener iTestNGListener) {
        if (!this.serviceLoaderListeners.containsKey(iTestNGListener.getClass())) {
            this.serviceLoaderListeners.put(iTestNGListener.getClass(), iTestNGListener);
        }
    }

    public List<ITestNGListener> getServiceLoaderListeners() {
        return Lists.newArrayList(this.serviceLoaderListeners.values());
    }

    static {
        DEFAULT_VERBOSE = 1;
    }
}

