/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.testng.ClassMethodMap;
import org.testng.GuiceHelper;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IDataProviderListener;
import org.testng.IDynamicGraph;
import org.testng.IExecutionListener;
import org.testng.IExecutionVisualiser;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IMethodSelector;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.InstanceOrderingMethodInterceptor;
import org.testng.PreserveOrderMethodInterceptor;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.AbstractParallelWorker;
import org.testng.internal.Attributes;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.DefaultListenerFactory;
import org.testng.internal.DynamicGraph;
import org.testng.internal.DynamicGraphHelper;
import org.testng.internal.GroupsHelper;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InstanceCreator;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.Systematiser;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestMethodComparator;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.junit.IJUnitTestRunner;
import org.testng.log4testng.Logger;
import org.testng.thread.ITestNGThreadPoolExecutor;
import org.testng.thread.IThreadWorkerFactory;
import org.testng.thread.IWorker;
import org.testng.util.Strings;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestRunner
implements ITestContext,
ITestResultNotifier,
IThreadWorkerFactory<ITestNGMethod> {
    private static final String DEFAULT_PROP_OUTPUT_DIR = "test-output";
    private static final Logger LOGGER = Logger.getLogger(TestRunner.class);
    private final Comparator<ITestNGMethod> comparator;
    private ISuite m_suite;
    private XmlTest m_xmlTest;
    private String m_testName;
    private final GuiceHelper guiceHelper = new GuiceHelper(this);
    private List<XmlClass> m_testClassesFromXml = null;
    private IInvoker m_invoker = null;
    private IAnnotationFinder m_annotationFinder = null;
    private List<ITestListener> m_testListeners = Lists.newArrayList();
    private Set<IConfigurationListener> m_configurationListeners = Sets.newHashSet();
    private final Set<IExecutionVisualiser> visualisers = Sets.newHashSet();
    private IConfigurationListener m_confListener = new ConfigurationListener();
    private Collection<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();
    private final Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newHashMap();
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> m_dataProviderListeners;
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = new Date();
    private Date m_endDate = null;
    private Map<Class<?>, ITestClass> m_classMap = Maps.newLinkedHashMap();
    private String m_outputDirectory = "test-output";
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private List<ITestNGMethod> m_excludedMethods = Lists.newArrayList();
    private ConfigurationGroupMethods m_groupMethods = null;
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private IResultMap m_passedTests = new ResultMap();
    private IResultMap m_failedTests = new ResultMap();
    private IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private IResultMap m_skippedTests = new ResultMap();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private List<IMethodInterceptor> m_methodInterceptors;
    private ClassMethodMap m_classMethodMap;
    private TestNGClassFinder m_testClassFinder;
    private IConfiguration m_configuration;
    private final Collection<IInvokedMethod> m_invokedMethods = new ConcurrentLinkedQueue<IInvokedMethod>();
    private IResultMap m_passedConfigurations = new ResultMap();
    private IResultMap m_skippedConfigurations = new ResultMap();
    private IResultMap m_failedConfigurations = new ResultMap();
    private IAttributes m_attributes = new Attributes();
    private ListMultiMap<Class<? extends Module>, Module> m_guiceModules = Maps.newListMultiMap();
    private Map<List<Module>, Injector> m_injectors = Maps.newHashMap();

    protected TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, String string, IAnnotationFinder iAnnotationFinder, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list, Comparator<ITestNGMethod> comparator, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map) {
        this.comparator = comparator;
        this.m_dataProviderListeners = Maps.newHashMap(map);
        this.init(iConfiguration, iSuite, xmlTest, string, iAnnotationFinder, bl, collection, list);
    }

    public TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list, Comparator<ITestNGMethod> comparator) {
        this.comparator = comparator;
        this.m_dataProviderListeners = Collections.emptyMap();
        this.init(iConfiguration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list);
    }

    public TestRunner(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.comparator = Systematiser.getComparator();
        this.m_dataProviderListeners = Collections.emptyMap();
        this.init(iConfiguration, iSuite, xmlTest, iSuite.getOutputDirectory(), iSuite.getAnnotationFinder(), bl, collection, list);
    }

    private void init(IConfiguration iConfiguration, ISuite iSuite, XmlTest xmlTest, String string, IAnnotationFinder iAnnotationFinder, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list) {
        this.m_configuration = iConfiguration;
        this.m_xmlTest = xmlTest;
        this.m_suite = iSuite;
        this.m_testName = xmlTest.getName();
        this.m_host = iSuite.getHost();
        this.m_testClassesFromXml = xmlTest.getXmlClasses();
        this.setVerbose(xmlTest.getVerbose());
        boolean bl2 = xmlTest.getPreserveOrder();
        Object object = bl2 ? new PreserveOrderMethodInterceptor() : new InstanceOrderingMethodInterceptor();
        this.m_methodInterceptors = new ArrayList<IMethodInterceptor>();
        this.m_methodInterceptors.add((IMethodInterceptor)object);
        List<XmlPackage> list2 = this.getAllPackages();
        for (XmlPackage object2 : list2) {
            this.m_testClassesFromXml.addAll(object2.getXmlClasses());
        }
        this.m_annotationFinder = iAnnotationFinder;
        this.m_invokedMethodListeners = collection;
        this.m_classListeners.clear();
        for (IClassListener iClassListener : list) {
            this.m_classListeners.put(iClassListener.getClass(), iClassListener);
        }
        this.m_invoker = new Invoker(this.m_configuration, this, this, this.m_suite.getSuiteState(), bl, collection, list, this.m_dataProviderListeners.values());
        if (xmlTest.getParallel() != null) {
            TestRunner.log("Running the tests in '" + xmlTest.getName() + "' with parallel mode:" + (Object)((Object)xmlTest.getParallel()));
        }
        this.setOutputDirectory(string);
        this.init();
    }

    private List<XmlPackage> getAllPackages() {
        List<XmlPackage> list;
        List list2 = Lists.newArrayList();
        List<XmlPackage> list3 = this.m_xmlTest.getSuite().getPackages();
        if (list3 != null) {
            list2.addAll(list3);
        }
        if ((list = this.m_xmlTest.getPackages()) != null) {
            list2.addAll(list);
        }
        return list2;
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        if (!this.m_xmlTest.isJUnit()) {
            this.initMethods();
        }
        this.initListeners();
        this.addConfigurationListener(this.m_confListener);
        for (IConfigurationListener iConfigurationListener : this.m_configuration.getConfigurationListeners()) {
            this.addConfigurationListener(iConfigurationListener);
        }
    }

    private void initListeners() {
        Object object;
        Set set = Sets.newHashSet();
        Class clazz = null;
        for (IClass object2 : this.getTestClasses()) {
            Class clazz2 = object2.getRealClass();
            object = TestListenerHelper.findAllListeners(clazz2, (IAnnotationFinder)this.m_annotationFinder);
            if (clazz == null) {
                clazz = object.getListenerFactoryClass();
            }
            set.addAll(object.getListenerClasses());
        }
        if (clazz == null) {
            clazz = DefaultListenerFactory.class;
        }
        ITestNGListenerFactory iTestNGListenerFactory = TestListenerHelper.createListenerFactory((TestNGClassFinder)this.m_testClassFinder, clazz);
        for (Class clazz2 : set) {
            if (IClassListener.class.isAssignableFrom(clazz2) && this.m_classListeners.containsKey(clazz2)) continue;
            object = iTestNGListenerFactory.createListener(clazz2);
            this.addListener((ITestNGListener)object);
        }
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> map = xmlTest.getMetaGroups();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this.addMetaGroup(entry.getKey(), entry.getValue());
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setScript(this.m_xmlTest.getScript());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector xmlMethodSelector : xmlTest.getMethodSelectors()) {
                if (xmlMethodSelector.getClassName() == null) continue;
                IMethodSelector iMethodSelector = InstanceCreator.createSelector((org.testng.xml.XmlMethodSelector)xmlMethodSelector);
                this.m_runInfo.addMethodSelector(iMethodSelector, xmlMethodSelector.getPriority());
            }
        }
    }

    private void initMethods() {
        List list = Lists.newArrayList();
        List list2 = Lists.newArrayList();
        List list3 = Lists.newArrayList();
        List list4 = Lists.newArrayList();
        List list5 = Lists.newArrayList();
        List list6 = Lists.newArrayList();
        List list7 = Lists.newArrayList();
        ClassInfoMap classInfoMap = new ClassInfoMap(this.m_testClassesFromXml);
        this.m_testClassFinder = new TestNGClassFinder(classInfoMap, Maps.newHashMap(), this.m_configuration, this, this.m_dataProviderListeners);
        TestNGMethodFinder testNGMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder, this.comparator);
        this.m_runInfo.setTestMethods(list2);
        IClass[] iClassArray = this.m_testClassFinder.findTestClasses();
        for (IClass iClass : iClassArray) {
            TestClass testClass = new TestClass(iClass, (ITestMethodFinder)testNGMethodFinder, this.m_annotationFinder, this.m_xmlTest, classInfoMap.getXmlClass(iClass.getRealClass()), this.m_testClassFinder.getFactoryCreationFailedMessage());
            this.m_classMap.put(iClass.getRealClass(), testClass);
        }
        Map<String, List<ITestNGMethod>> map = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), true);
        Map<String, List<ITestNGMethod>> map2 = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), false);
        for (ITestClass iTestClass : this.m_classMap.values()) {
            MethodHelper.fixMethodsWithClass(iTestClass.getTestMethods(), iTestClass, list2);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeClassMethods(), iTestClass, list);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeTestMethods(), iTestClass, null);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterTestMethods(), iTestClass, null);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterClassMethods(), iTestClass, list3);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeSuiteMethods(), iTestClass, list4);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterSuiteMethods(), iTestClass, list5);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeTestConfigurationMethods(), iTestClass, list6);
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterTestConfigurationMethods(), iTestClass, list7);
            MethodHelper.fixMethodsWithClass(iTestClass.getBeforeGroupsMethods(), iTestClass, MethodHelper.uniqueMethodList(map.values()));
            MethodHelper.fixMethodsWithClass(iTestClass.getAfterGroupsMethods(), iTestClass, MethodHelper.uniqueMethodList(map2.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(list4, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(list6, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(list2, true, this.m_runInfo, this.m_annotationFinder, false, this.m_excludedMethods, this.comparator);
        this.m_classMethodMap = new ClassMethodMap(Arrays.asList(this.m_allTestMethods), this.m_xmlMethodSelector);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(list7, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(list5, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods, this.comparator);
        this.m_groupMethods = new ConfigurationGroupMethods(this.m_allTestMethods, map, map2);
    }

    public Collection<ITestClass> getTestClasses() {
        return this.m_classMap.values();
    }

    public void setTestName(String string) {
        this.m_testName = string;
    }

    public void setOutputDirectory(String string) {
        this.m_outputDirectory = string;
    }

    private void addMetaGroup(String string, List<String> list) {
        this.m_metaGroups.put(string, list);
    }

    private Map<String, String> createGroups(List<String> list) {
        return GroupsHelper.createGroups(this.m_metaGroups, list);
    }

    public void run() {
        this.beforeRun();
        try {
            XmlTest xmlTest = this.getTest();
            if (xmlTest.isJUnit()) {
                this.privateRunJUnit();
            } else {
                this.privateRun(xmlTest);
            }
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] iTestNGMethodArray = this.getBeforeTestConfigurationMethods();
        this.invokeTestConfigurations(iTestNGMethodArray);
    }

    private void invokeTestConfigurations(ITestNGMethod[] iTestNGMethodArray) {
        if (null != iTestNGMethodArray && iTestNGMethodArray.length > 0) {
            ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(iTestNGMethodArray).forSuite(this.m_xmlTest.getSuite()).usingParameters(this.m_xmlTest.getAllParameters()).build();
            this.m_invoker.getConfigInvoker().invokeConfigurations(configMethodArguments);
        }
    }

    private void privateRunJUnit() {
        final ClassInfoMap classInfoMap = new ClassInfoMap(this.m_testClassesFromXml, false);
        final Set<Class<?>> set = classInfoMap.getClasses();
        final List list = Lists.newArrayList();
        List list2 = Lists.newArrayList();
        list2.add(new IWorker<ITestNGMethod>(){

            @Override
            public long getTimeOut() {
                return 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Class clazz : set) {
                    List<XmlInclude> list3 = classInfoMap.getXmlClass(clazz).getIncludedMethods();
                    List list2 = Lists.newArrayList();
                    for (XmlInclude xmlInclude : list3) {
                        list2.add(xmlInclude.getName());
                    }
                    IJUnitTestRunner iJUnitTestRunner = IJUnitTestRunner.createTestRunner(TestRunner.this);
                    iJUnitTestRunner.setInvokedMethodListeners(TestRunner.this.m_invokedMethodListeners);
                    try {
                        iJUnitTestRunner.run(clazz, list2.toArray(new String[0]));
                    }
                    catch (Exception exception) {
                        LOGGER.error(exception.getMessage(), exception);
                    }
                    finally {
                        list.addAll(iJUnitTestRunner.getTestMethods());
                    }
                }
            }

            @Override
            public List<ITestNGMethod> getTasks() {
                throw new TestNGException("JUnit not supported");
            }

            @Override
            public int getPriority() {
                if (TestRunner.this.m_allTestMethods.length == 1) {
                    return TestRunner.this.m_allTestMethods[0].getPriority();
                }
                return 0;
            }

            @Override
            public int compareTo(@Nonnull IWorker<ITestNGMethod> iWorker) {
                return this.getPriority() - iWorker.getPriority();
            }
        });
        this.runJUnitWorkers(list2);
        this.m_allTestMethods = list.toArray(new ITestNGMethod[0]);
    }

    private static Comparator<ITestNGMethod> newComparator(boolean bl) {
        return bl ? new TestMethodComparator() : null;
    }

    private boolean sortOnPriority(ITestNGMethod[] iTestNGMethodArray) {
        return this.m_methodInterceptors.size() > 1 || Arrays.stream(iTestNGMethodArray).anyMatch(iTestNGMethod -> iTestNGMethod.getPriority() != 0);
    }

    private static BlockingQueue<Runnable> newQueue(boolean bl) {
        return bl ? new PriorityBlockingQueue() : new LinkedBlockingQueue();
    }

    private void privateRun(XmlTest xmlTest) {
        boolean bl = xmlTest.getParallel().isParallel();
        int n = bl ? xmlTest.getThreadCount() : 1;
        ITestNGMethod[] iTestNGMethodArray = this.intercept(this.m_allTestMethods);
        DynamicGraph dynamicGraph = DynamicGraphHelper.createDynamicGraph((ITestNGMethod[])iTestNGMethodArray, (XmlTest)this.getCurrentXmlTest());
        dynamicGraph.setVisualisers(this.visualisers);
        boolean bl2 = this.sortOnPriority(iTestNGMethodArray);
        Comparator<ITestNGMethod> comparator = TestRunner.newComparator(bl2);
        if (bl) {
            if (dynamicGraph.getNodeCount() <= 0) {
                return;
            }
            ITestNGThreadPoolExecutor iTestNGThreadPoolExecutor = this.m_configuration.getExecutorFactory().newTestMethodExecutor("test=" + xmlTest.getName(), dynamicGraph, this, n, n, 0L, TimeUnit.MILLISECONDS, TestRunner.newQueue(bl2), comparator);
            iTestNGThreadPoolExecutor.run();
            try {
                long l = this.m_xmlTest.getTimeOut(Integer.MAX_VALUE);
                Utils.log("TestRunner", 2, "Starting executor for test " + this.m_xmlTest.getName() + " with time out:" + l + " milliseconds.");
                iTestNGThreadPoolExecutor.awaitTermination(l, TimeUnit.MILLISECONDS);
                iTestNGThreadPoolExecutor.shutdownNow();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.error(interruptedException.getMessage(), interruptedException);
                Thread.currentThread().interrupt();
            }
            return;
        }
        List<ITestNGMethod> list = dynamicGraph.getFreeNodes();
        if (dynamicGraph.getNodeCount() > 0 && list.isEmpty()) {
            throw new TestNGException("No free nodes found in:" + dynamicGraph);
        }
        while (!list.isEmpty()) {
            if (bl2) {
                list.sort(comparator);
                list = list.subList(0, 1);
            }
            this.createWorkers(list).forEach(Runnable::run);
            dynamicGraph.setStatus(list, IDynamicGraph.Status.FINISHED);
            list = dynamicGraph.getFreeNodes();
        }
    }

    private ITestNGMethod[] intercept(ITestNGMethod[] iTestNGMethodArray) {
        List<IMethodInstance> list = MethodHelper.methodsToMethodInstances(Arrays.asList(iTestNGMethodArray));
        for (IMethodInterceptor iTestNGMethodArray22 : this.m_methodInterceptors) {
            list = iTestNGMethodArray22.intercept(list, this);
        }
        List<ITestNGMethod> list2 = MethodHelper.methodInstancesToMethods(list);
        this.m_classMethodMap = new ClassMethodMap(list2, null);
        ITestNGMethod[] iTestNGMethodArray2 = list2.toArray(new ITestNGMethod[0]);
        if (iTestNGMethodArray2.length != this.m_groupMethods.getAllTestMethods().length) {
            this.m_groupMethods = new ConfigurationGroupMethods(iTestNGMethodArray2, this.m_groupMethods.getBeforeGroupsMethods(), this.m_groupMethods.getAfterGroupsMethods());
        }
        if (this.m_methodInterceptors.size() > 1) {
            for (int i = 0; i < iTestNGMethodArray2.length; ++i) {
                iTestNGMethodArray2[i].setInterceptedPriority(i);
            }
        }
        return iTestNGMethodArray2;
    }

    @Override
    public List<IWorker<ITestNGMethod>> createWorkers(List<ITestNGMethod> list) {
        AbstractParallelWorker.Arguments arguments = new AbstractParallelWorker.Arguments.Builder().classMethodMap(this.m_classMethodMap).configMethods(this.m_groupMethods).finder(this.m_annotationFinder).invoker(this.m_invoker).methods(list).testContext((ITestContext)this).listeners(this.m_classListeners.values()).build();
        return AbstractParallelWorker.newWorker((XmlSuite.ParallelMode)this.m_xmlTest.getParallel(), (boolean)this.m_xmlTest.getGroupByInstances()).createWorkers(arguments);
    }

    private void runJUnitWorkers(List<? extends IWorker<ITestNGMethod>> list) {
        list.forEach(Runnable::run);
    }

    private void afterRun() {
        ITestNGMethod[] iTestNGMethodArray = this.getAfterTestConfigurationMethods();
        this.invokeTestConfigurations(iTestNGMethodArray);
        this.m_endDate = new Date(System.currentTimeMillis());
        this.dumpInvokedMethods();
        this.fireEvent(false);
    }

    private void logStart() {
        TestRunner.log("Running test " + this.m_testName + " on " + this.m_classMap.size() + "  classes,  included groups:[" + Strings.valueOf(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + Strings.valueOf(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass iTestClass : this.m_classMap.values()) {
                ((TestClass)iTestClass).dump();
            }
        }
    }

    private void fireEvent(boolean bl) {
        for (ITestListener iTestListener : this.m_testListeners) {
            if (bl) {
                iTestListener.onStart(this);
                continue;
            }
            iTestListener.onFinish(this);
        }
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    @Override
    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    @Override
    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> map = this.m_xmlMethodSelector.getIncludedGroups();
        return map.values().toArray(new String[0]);
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> map = this.m_xmlMethodSelector.getExcludedGroups();
        return map.values().toArray(new String[0]);
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        Map map = Maps.newHashMap();
        for (ITestNGMethod iTestNGMethod : this.m_excludedMethods) {
            map.put(iTestNGMethod, iTestNGMethod);
        }
        return map.keySet();
    }

    @Override
    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    @Override
    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    @Override
    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    @Override
    public void addPassedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.m_passedTests.addResult(iTestResult, iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getPassedTests(ITestNGMethod iTestNGMethod) {
        return this.m_passedTests.getResults(iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getFailedTests(ITestNGMethod iTestNGMethod) {
        return this.m_failedTests.getResults(iTestNGMethod);
    }

    @Override
    public Set<ITestResult> getSkippedTests(ITestNGMethod iTestNGMethod) {
        return this.m_skippedTests.getResults(iTestNGMethod);
    }

    @Override
    public void addSkippedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.m_skippedTests.addResult(iTestResult, iTestNGMethod);
    }

    @Override
    public void addInvokedMethod(InvokedMethod invokedMethod) {
        this.m_invokedMethods.add(invokedMethod);
    }

    @Override
    public void addFailedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.logFailedTest(iTestNGMethod, iTestResult, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        this.logFailedTest(iTestNGMethod, iTestResult, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        List list = Lists.newArrayList(this.m_configurationListeners);
        for (IConfigurationListener iConfigurationListener : this.m_configuration.getConfigurationListeners()) {
            boolean bl = false;
            for (IConfigurationListener iConfigurationListener2 : list) {
                if (!iConfigurationListener.getClass().equals(iConfigurationListener2.getClass())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.add(iConfigurationListener);
        }
        return Lists.newArrayList((Collection)list);
    }

    private void logFailedTest(ITestNGMethod iTestNGMethod, ITestResult iTestResult, boolean bl) {
        if (bl) {
            this.m_failedButWithinSuccessPercentageTests.addResult(iTestResult, iTestNGMethod);
        } else {
            this.m_failedTests.addResult(iTestResult, iTestNGMethod);
        }
    }

    private static void log(String string) {
        Utils.log("TestRunner", 3, string);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    void addTestListener(ITestListener iTestListener) {
        if (!this.m_testListeners.contains(iTestListener)) {
            this.m_testListeners.add(iTestListener);
        }
    }

    public void addListener(ITestNGListener iTestNGListener) {
        ITestNGListener iTestNGListener2;
        if (iTestNGListener instanceof IMethodInterceptor) {
            this.m_methodInterceptors.add((IMethodInterceptor)iTestNGListener);
        }
        if (iTestNGListener instanceof ITestListener) {
            this.addTestListener((ITestListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IClassListener && !this.m_classListeners.containsKey((iTestNGListener2 = (IClassListener)iTestNGListener).getClass())) {
            this.m_classListeners.put((Class<? extends IClassListener>)iTestNGListener2.getClass(), (IClassListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)iTestNGListener);
        }
        if (iTestNGListener instanceof IConfigurable) {
            this.m_configuration.setConfigurable((IConfigurable)iTestNGListener);
        }
        if (iTestNGListener instanceof IHookable) {
            this.m_configuration.setHookable((IHookable)iTestNGListener);
        }
        if (iTestNGListener instanceof IExecutionListener && this.m_configuration.addExecutionListenerIfAbsent((IExecutionListener)(iTestNGListener2 = (IExecutionListener)iTestNGListener))) {
            iTestNGListener2.onExecutionStart();
        }
        if (iTestNGListener instanceof IDataProviderListener) {
            iTestNGListener2 = (IDataProviderListener)iTestNGListener;
            this.m_dataProviderListeners.put(iTestNGListener2.getClass(), (IDataProviderListener)iTestNGListener2);
        }
        if (iTestNGListener instanceof IExecutionVisualiser) {
            iTestNGListener2 = (IExecutionVisualiser)iTestNGListener;
            this.visualisers.add((IExecutionVisualiser)iTestNGListener2);
        }
        this.m_suite.addListener(iTestNGListener);
    }

    void addConfigurationListener(IConfigurationListener iConfigurationListener) {
        this.m_configurationListeners.add(iConfigurationListener);
    }

    private void dumpInvokedMethods() {
        MethodHelper.dumpInvokedMethodsInfoToConsole(this.m_invokedMethods, TestRunner.getVerbose());
    }

    public List<ITestNGMethod> getInvokedMethods() {
        return MethodHelper.invokedMethodsToMethods(this.m_invokedMethods);
    }

    void addMethodInterceptor(IMethodInterceptor iMethodInterceptor) {
        if (!this.m_methodInterceptors.contains(iMethodInterceptor)) {
            this.m_methodInterceptors.add(iMethodInterceptor);
        }
    }

    @Override
    public XmlTest getCurrentXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.m_attributes.removeAttribute(string);
    }

    @Override
    public List<Module> getGuiceModules(Class<? extends Module> clazz) {
        return (List)this.m_guiceModules.get(clazz);
    }

    @Override
    public Injector getInjector(List<Module> list) {
        return this.m_injectors.get(list);
    }

    @Override
    public Injector getInjector(IClass iClass) {
        return this.guiceHelper.getInjector(iClass);
    }

    @Override
    public void addInjector(List<Module> list, Injector injector) {
        this.m_injectors.put(list, injector);
    }

    private class ConfigurationListener
    implements IConfigurationListener {
        private ConfigurationListener() {
        }

        @Override
        public void beforeConfiguration(ITestResult iTestResult) {
        }

        @Override
        public void onConfigurationFailure(ITestResult iTestResult) {
            TestRunner.this.m_failedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }

        @Override
        public void onConfigurationSkip(ITestResult iTestResult) {
            TestRunner.this.m_skippedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }

        @Override
        public void onConfigurationSuccess(ITestResult iTestResult) {
            TestRunner.this.m_passedConfigurations.addResult(iTestResult, iTestResult.getMethod());
        }
    }

    public static enum PriorityWeight {
        groupByInstance,
        preserveOrder,
        priority,
        dependsOnGroups,
        dependsOnMethods;

    }
}

