/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import org.testng.IClass;
import org.testng.ITestClassFinder;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.collections.Maps;
import org.testng.internal.ClassImpl;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;

public abstract class BaseClassFinder
implements ITestClassFinder {
    private final Map<Class<?>, IClass> m_classes = Maps.newLinkedHashMap();

    @Override
    public IClass getIClass(Class<?> clazz) {
        return this.m_classes.get(clazz);
    }

    protected void putIClass(Class<?> clazz, IClass iClass) {
        if (!this.m_classes.containsKey(clazz)) {
            this.m_classes.put(clazz, iClass);
        }
    }

    protected IClass findOrCreateIClass(ITestContext iTestContext, Class<?> clazz2, XmlClass xmlClass, Object object, IAnnotationFinder iAnnotationFinder, ITestObjectFactory iTestObjectFactory) {
        return this.m_classes.computeIfAbsent(clazz2, clazz -> new ClassImpl(iTestContext, (Class<?>)clazz, xmlClass, object, this.m_classes, iAnnotationFinder, iTestObjectFactory));
    }

    @Deprecated
    protected Map getExistingClasses() {
        return this.m_classes;
    }

    protected boolean classExists(Class<?> clazz) {
        return this.m_classes.containsKey(clazz);
    }

    @Override
    public IClass[] findTestClasses() {
        return this.m_classes.values().toArray(new IClass[0]);
    }
}

