/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.collections.Maps;
import org.testng.internal.IConfiguration;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.InvokedMethodListenerInvoker;
import org.testng.internal.invokers.InvokedMethodListenerMethod;

class BaseInvoker {
    private final Collection<IInvokedMethodListener> m_invokedMethodListeners;
    protected final ITestResultNotifier m_notifier;
    protected final ITestContext m_testContext;
    protected final SuiteRunState m_suiteState;
    protected IConfiguration m_configuration;
    protected final Map<Class<?>, Set<Object>> m_classInvocationResults = Maps.newConcurrentMap();

    public BaseInvoker(ITestResultNotifier iTestResultNotifier, Collection<IInvokedMethodListener> collection, ITestContext iTestContext, SuiteRunState suiteRunState, IConfiguration iConfiguration) {
        this.m_notifier = iTestResultNotifier;
        this.m_invokedMethodListeners = collection;
        this.m_testContext = iTestContext;
        this.m_suiteState = suiteRunState;
        this.m_configuration = iConfiguration;
    }

    protected IAnnotationFinder annotationFinder() {
        return this.m_configuration.getAnnotationFinder();
    }

    protected void runInvokedMethodListeners(InvokedMethodListenerMethod invokedMethodListenerMethod, IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (this.noListenersPresent()) {
            return;
        }
        InvokedMethodListenerInvoker invokedMethodListenerInvoker = new InvokedMethodListenerInvoker(invokedMethodListenerMethod, iTestResult, this.m_testContext);
        for (IInvokedMethodListener iInvokedMethodListener : this.m_invokedMethodListeners) {
            invokedMethodListenerInvoker.invokeListener(iInvokedMethodListener, iInvokedMethod);
        }
    }

    private boolean noListenersPresent() {
        return this.m_invokedMethodListeners == null || this.m_invokedMethodListeners.isEmpty();
    }

    protected void handleException(Throwable throwable, ITestNGMethod iTestNGMethod, ITestResult iTestResult, int n) {
        int n2;
        int n3;
        float f;
        if (throwable != null && iTestResult.getThrowable() == null) {
            iTestResult.setThrowable(throwable);
        }
        if ((float)n < (f = (float)((100 - (n3 = iTestNGMethod.getSuccessPercentage())) * (n2 = iTestNGMethod.getInvocationCount())) / 100.0f)) {
            iTestResult.setStatus(4);
        } else {
            iTestResult.setStatus(2);
        }
    }

    protected boolean isSkipExceptionAndSkip(Throwable throwable) {
        return SkipException.class.isAssignableFrom(throwable.getClass()) && ((SkipException)throwable).isSkip();
    }

    static void log(int n, String string) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), n, string);
    }
}

