/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.testng.IClass;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.IParameterInfo;
import org.testng.internal.InstanceCreator;
import org.testng.internal.MethodHelper;
import org.testng.internal.annotations.DisabledRetryAnalyzer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

public abstract class BaseTestMethod
implements ITestNGMethod {
    private static final Pattern SPACE_SEPARATOR_PATTERN = Pattern.compile(" +");
    protected ITestClass m_testClass;
    protected final Class<?> m_methodClass;
    protected final ConstructorOrMethod m_method;
    private String m_signature;
    protected String m_id = "";
    protected long m_date = -1L;
    protected final IAnnotationFinder m_annotationFinder;
    protected String[] m_groups = new String[0];
    protected String[] m_groupsDependedUpon = new String[0];
    protected String[] m_methodsDependedUpon = new String[0];
    protected String[] m_beforeGroups = new String[0];
    protected String[] m_afterGroups = new String[0];
    private boolean m_isAlwaysRun;
    private boolean m_enabled;
    private final String m_methodName;
    private String m_missingGroup;
    private String m_description = null;
    protected AtomicInteger m_currentInvocationCount = new AtomicInteger(0);
    private int m_parameterInvocationCount = 1;
    private Callable<Boolean> m_moreInvocationChecker;
    private IRetryAnalyzer m_retryAnalyzer = null;
    private Class<? extends IRetryAnalyzer> m_retryAnalyzerClass = null;
    private boolean m_skipFailedInvocations = true;
    private long m_invocationTimeOut = 0L;
    private List<Integer> m_invocationNumbers = Lists.newArrayList();
    private final Collection<Integer> m_failedInvocationNumbers = new ConcurrentLinkedQueue<Integer>();
    private long m_timeOut = 0L;
    private boolean m_ignoreMissingDependencies;
    private int m_priority;
    private int m_interceptedPriority;
    private XmlTest m_xmlTest;
    private Object m_instance;
    private final Map<String, IRetryAnalyzer> m_testMethodToRetryAnalyzer = Maps.newConcurrentMap();

    public BaseTestMethod(String string, ConstructorOrMethod constructorOrMethod, IAnnotationFinder iAnnotationFinder, Object object) {
        this.m_methodClass = constructorOrMethod.getDeclaringClass();
        this.m_method = constructorOrMethod;
        this.m_methodName = string;
        this.m_annotationFinder = iAnnotationFinder;
        this.m_instance = object;
    }

    @Override
    public boolean isAlwaysRun() {
        return this.m_isAlwaysRun;
    }

    protected void setAlwaysRun(boolean bl) {
        this.m_isAlwaysRun = bl;
    }

    @Override
    public Class<?> getRealClass() {
        return this.m_methodClass;
    }

    @Override
    public ITestClass getTestClass() {
        return this.m_testClass;
    }

    @Override
    public void setTestClass(ITestClass iTestClass) {
        if (iTestClass == null) {
            throw new IllegalArgumentException("test class cannot be null");
        }
        boolean bl = this.m_method.getDeclaringClass().isAssignableFrom(iTestClass.getRealClass());
        if (!bl) {
            throw new IllegalArgumentException("mismatch in classes between " + iTestClass.getName() + " and " + this.m_method.getDeclaringClass().getName());
        }
        this.m_testClass = iTestClass;
    }

    @Override
    public String getMethodName() {
        return this.m_methodName;
    }

    @Override
    public Object getInstance() {
        return IParameterInfo.embeddedInstance(this.m_instance);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_testClass.getInstanceHashCodes();
    }

    @Override
    public String[] getGroups() {
        return this.m_groups;
    }

    @Override
    public String[] getGroupsDependedUpon() {
        return this.m_groupsDependedUpon;
    }

    @Override
    public String[] getMethodsDependedUpon() {
        return this.m_methodsDependedUpon;
    }

    @Override
    public boolean isTest() {
        return false;
    }

    @Override
    public boolean isBeforeSuiteConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterSuiteConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeTestConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterTestConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeGroupsConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterGroupsConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeClassConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterClassConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeMethodConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterMethodConfiguration() {
        return false;
    }

    @Override
    public long getTimeOut() {
        return this.m_timeOut != 0L ? this.m_timeOut : (this.m_xmlTest != null ? this.m_xmlTest.getTimeOut(0L) : 0L);
    }

    @Override
    public void setTimeOut(long l) {
        this.m_timeOut = l;
    }

    @Override
    public int getInvocationCount() {
        return 1;
    }

    @Override
    public void setInvocationCount(int n) {
    }

    @Override
    public int getSuccessPercentage() {
        return 100;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setId(String string) {
        this.m_id = string;
    }

    @Override
    public long getDate() {
        return this.m_date;
    }

    @Override
    public void setDate(long l) {
        this.m_date = l;
    }

    @Override
    public boolean canRunFromClass(IClass iClass) {
        return this.m_methodClass.isAssignableFrom(iClass.getRealClass());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BaseTestMethod baseTestMethod = (BaseTestMethod)object;
        boolean bl = this.m_testClass == null ? baseTestMethod.m_testClass == null : baseTestMethod.m_testClass != null && this.m_testClass.getRealClass().equals(baseTestMethod.m_testClass.getRealClass()) && this.getInstance() == baseTestMethod.getInstance();
        return bl && this.getConstructorOrMethod().equals(baseTestMethod.getConstructorOrMethod());
    }

    public int hashCode() {
        return this.m_method.hashCode();
    }

    protected void initGroups(Class<? extends ITestOrConfiguration> clazz) {
        ITestOrConfiguration iTestOrConfiguration = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod(), clazz);
        Object object = this.getInstance();
        Class<?> clazz2 = this.getConstructorOrMethod().getDeclaringClass();
        if (object != null) {
            clazz2 = object.getClass();
        }
        ITestOrConfiguration iTestOrConfiguration2 = this.getAnnotationFinder().findAnnotation(clazz2, clazz);
        this.setGroups(this.getStringArray(null != iTestOrConfiguration ? iTestOrConfiguration.getGroups() : null, null != iTestOrConfiguration2 ? iTestOrConfiguration2.getGroups() : null));
        this.initRestOfGroupDependencies(clazz);
    }

    protected void initBeforeAfterGroups(Class<? extends ITestOrConfiguration> clazz, String[] stringArray) {
        String[] stringArray2 = this.calculateGroupsTouseConsideringValuesAndGroupValues(clazz, stringArray);
        this.setGroups(this.getStringArray(stringArray2, null));
        this.initRestOfGroupDependencies(clazz);
    }

    private String[] calculateGroupsTouseConsideringValuesAndGroupValues(Class<? extends ITestOrConfiguration> clazz, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            ITestOrConfiguration iTestOrConfiguration = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod(), clazz);
            stringArray = null != iTestOrConfiguration ? iTestOrConfiguration.getGroups() : null;
        }
        return stringArray;
    }

    private void initRestOfGroupDependencies(Class<? extends ITestOrConfiguration> clazz) {
        ITestOrConfiguration iTestOrConfiguration = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod(), clazz);
        ITestOrConfiguration iTestOrConfiguration2 = this.getAnnotationFinder().findAnnotation(this.getConstructorOrMethod().getDeclaringClass(), clazz);
        Map<String, Set<String>> map = BaseTestMethod.calculateXmlGroupDependencies(this.m_xmlTest);
        List list = Lists.newArrayList();
        for (String string : this.getGroups()) {
            Set<String> set = map.get(string);
            if (set == null) continue;
            list.addAll(set);
        }
        this.setGroupsDependedUpon(this.getStringArray(null != iTestOrConfiguration ? iTestOrConfiguration.getDependsOnGroups() : null, null != iTestOrConfiguration2 ? iTestOrConfiguration2.getDependsOnGroups() : null), list);
        String[] stringArray = this.getStringArray(null != iTestOrConfiguration ? iTestOrConfiguration.getDependsOnMethods() : null, null != iTestOrConfiguration2 ? iTestOrConfiguration2.getDependsOnMethods() : null);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.contains(".")) continue;
            string = MethodHelper.calculateMethodCanonicalName(this.m_methodClass, stringArray[i]);
            stringArray[i] = string != null ? string : stringArray[i];
        }
        this.setMethodsDependedUpon(stringArray);
    }

    private static Map<String, Set<String>> calculateXmlGroupDependencies(XmlTest xmlTest) {
        Map map = Maps.newHashMap();
        if (xmlTest == null) {
            return map;
        }
        for (Map.Entry<String, String> entry : xmlTest.getXmlDependencyGroups().entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            Set set = map.computeIfAbsent(string2, string -> Sets.newHashSet());
            set.addAll(Arrays.asList(SPACE_SEPARATOR_PATTERN.split(string3)));
        }
        return map;
    }

    protected IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    protected IClass getIClass() {
        return this.m_testClass;
    }

    static StringBuilder stringify(String string, ConstructorOrMethod constructorOrMethod) {
        StringBuilder stringBuilder = new StringBuilder(string).append(".").append(constructorOrMethod.getName()).append("(");
        return stringBuilder.append(constructorOrMethod.stringifyParameterTypes()).append(")");
    }

    private String computeSignature() {
        String string = this.m_method.getDeclaringClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        StringBuilder stringBuilder = BaseTestMethod.stringify(string2, this.m_method);
        stringBuilder.append("[pri:").append(this.getPriority()).append(", instance:").append(this.getInstance()).append(this.instanceParameters()).append("]");
        return stringBuilder.toString();
    }

    public String getSimpleName() {
        return this.m_method.getDeclaringClass().getSimpleName() + "." + this.m_method.getName();
    }

    private String instanceParameters() {
        IParameterInfo iParameterInfo = this.getFactoryMethodParamsInfo();
        if (iParameterInfo != null) {
            return ", instance params:" + Arrays.toString(iParameterInfo.getParameters());
        }
        return "";
    }

    protected String getSignature() {
        if (this.m_signature == null) {
            this.m_signature = this.computeSignature();
        }
        return this.m_signature;
    }

    public String toString() {
        return this.getSignature();
    }

    protected String[] getStringArray(String[] stringArray, String[] stringArray2) {
        Set set = Sets.newHashSet();
        if (null != stringArray) {
            Collections.addAll(set, stringArray);
        }
        if (null != stringArray2) {
            Collections.addAll(set, stringArray2);
        }
        return set.toArray(new String[0]);
    }

    protected void setGroups(String[] stringArray) {
        this.m_groups = stringArray;
    }

    protected void setGroupsDependedUpon(String[] stringArray, Collection<String> collection) {
        List list = Lists.newArrayList();
        list.addAll(Arrays.asList(stringArray));
        list.addAll(collection);
        this.m_groupsDependedUpon = list.toArray(new String[0]);
    }

    protected void setMethodsDependedUpon(String[] stringArray) {
        this.m_methodsDependedUpon = stringArray;
    }

    @Override
    public void addMethodDependedUpon(String string) {
        String[] stringArray = new String[this.m_methodsDependedUpon.length + 1];
        stringArray[0] = string;
        System.arraycopy(this.m_methodsDependedUpon, 0, stringArray, 1, this.m_methodsDependedUpon.length);
        this.m_methodsDependedUpon = stringArray;
    }

    @Override
    public String getMissingGroup() {
        return this.m_missingGroup;
    }

    @Override
    public void setMissingGroup(String string) {
        this.m_missingGroup = string;
    }

    @Override
    public int getThreadPoolSize() {
        return 0;
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    @Override
    public void setDescription(String string) {
        this.m_description = string;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    @Override
    public boolean getEnabled() {
        return this.m_enabled;
    }

    @Override
    public String[] getBeforeGroups() {
        return this.m_beforeGroups;
    }

    @Override
    public String[] getAfterGroups() {
        return this.m_afterGroups;
    }

    @Override
    public void incrementCurrentInvocationCount() {
        this.m_currentInvocationCount.incrementAndGet();
    }

    @Override
    public int getCurrentInvocationCount() {
        return this.m_currentInvocationCount.get();
    }

    @Override
    public void setParameterInvocationCount(int n) {
        this.m_parameterInvocationCount = n;
    }

    @Override
    public int getParameterInvocationCount() {
        return this.m_parameterInvocationCount;
    }

    @Override
    public void setMoreInvocationChecker(Callable<Boolean> callable) {
        this.m_moreInvocationChecker = callable;
    }

    @Override
    public boolean hasMoreInvocation() {
        if (this.m_moreInvocationChecker != null) {
            try {
                return this.m_moreInvocationChecker.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.getCurrentInvocationCount() < this.getInvocationCount() * this.getParameterInvocationCount();
    }

    @Override
    public abstract ITestNGMethod clone();

    @Override
    public IRetryAnalyzer getRetryAnalyzer() {
        return this.m_retryAnalyzer;
    }

    @Override
    public IRetryAnalyzer getRetryAnalyzer(ITestResult iTestResult) {
        return this.getRetryAnalyzerConsideringMethodParameteters(iTestResult);
    }

    @Override
    public void setRetryAnalyzer(IRetryAnalyzer iRetryAnalyzer) {
        this.m_retryAnalyzer = iRetryAnalyzer;
    }

    @Override
    public void setRetryAnalyzerClass(Class<? extends IRetryAnalyzer> clazz) {
        this.m_retryAnalyzerClass = clazz == null ? DisabledRetryAnalyzer.class : clazz;
        this.m_retryAnalyzer = (IRetryAnalyzer)InstanceCreator.newInstance(this.m_retryAnalyzerClass);
    }

    @Override
    public Class<? extends IRetryAnalyzer> getRetryAnalyzerClass() {
        return this.m_retryAnalyzerClass;
    }

    @Override
    public boolean skipFailedInvocations() {
        return this.m_skipFailedInvocations;
    }

    @Override
    public void setSkipFailedInvocations(boolean bl) {
        this.m_skipFailedInvocations = bl;
    }

    public void setInvocationTimeOut(long l) {
        this.m_invocationTimeOut = l;
    }

    @Override
    public long getInvocationTimeOut() {
        return this.m_invocationTimeOut;
    }

    @Override
    public boolean ignoreMissingDependencies() {
        return this.m_ignoreMissingDependencies;
    }

    @Override
    public void setIgnoreMissingDependencies(boolean bl) {
        this.m_ignoreMissingDependencies = bl;
    }

    @Override
    public List<Integer> getInvocationNumbers() {
        return this.m_invocationNumbers;
    }

    @Override
    public void setInvocationNumbers(List<Integer> list) {
        this.m_invocationNumbers = list;
    }

    @Override
    public List<Integer> getFailedInvocationNumbers() {
        return new ArrayList<Integer>(this.m_failedInvocationNumbers);
    }

    @Override
    public void addFailedInvocationNumber(int n) {
        this.m_failedInvocationNumbers.add(n);
    }

    @Override
    public int getPriority() {
        return this.m_priority;
    }

    @Override
    public void setPriority(int n) {
        this.m_priority = n;
    }

    @Override
    public int getInterceptedPriority() {
        return this.m_interceptedPriority;
    }

    @Override
    public void setInterceptedPriority(int n) {
        this.m_interceptedPriority = n;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    public void setXmlTest(XmlTest xmlTest) {
        this.m_xmlTest = xmlTest;
    }

    @Override
    public ConstructorOrMethod getConstructorOrMethod() {
        return this.m_method;
    }

    @Override
    public Map<String, String> findMethodParameters(XmlTest xmlTest) {
        Map<String, String> map = xmlTest.getAllParameters();
        block0: for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
            if (!xmlClass.getName().equals(this.getTestClass().getName())) continue;
            map.putAll(xmlClass.getLocalParameters());
            for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                if (!xmlInclude.getName().equals(this.getMethodName())) continue;
                map.putAll(xmlInclude.getLocalParameters());
                continue block0;
            }
        }
        return map;
    }

    @Override
    public String getQualifiedName() {
        return this.getRealClass().getName() + "." + this.getMethodName();
    }

    @Override
    public IParameterInfo getFactoryMethodParamsInfo() {
        if (this.m_instance instanceof IParameterInfo) {
            return (IParameterInfo)this.m_instance;
        }
        return null;
    }

    private IRetryAnalyzer getRetryAnalyzerConsideringMethodParameteters(ITestResult iTestResult) {
        Object[] objectArray = iTestResult.getParameters();
        IRetryAnalyzer iRetryAnalyzer = this.m_retryAnalyzer;
        if (objectArray != null && objectArray.length != 0 && iRetryAnalyzer != null) {
            String string2 = this.getMethodName() + "_" + Arrays.toString(objectArray);
            iRetryAnalyzer = this.m_testMethodToRetryAnalyzer.computeIfAbsent(string2, string -> (IRetryAnalyzer)InstanceCreator.newInstance(this.m_retryAnalyzer.getClass()));
        }
        return iRetryAnalyzer;
    }
}

