/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IObjectFactory;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.InstanceCreator;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class ClassHelper {
    private static final List<ClassLoader> classLoaders = new Vector<ClassLoader>();
    private static final String CLASS_HELPER = ClassHelper.class.getSimpleName();
    private static int lastGoodRootIndex = -1;

    private ClassHelper() {
    }

    public static void addClassLoader(ClassLoader classLoader) {
        classLoaders.add(classLoader);
    }

    @Deprecated
    public static <T> T newInstance(Class<T> clazz) {
        return (T)InstanceCreator.newInstance(clazz);
    }

    @Deprecated
    public static <T> T newInstanceOrNull(Class<T> clazz) {
        return (T)InstanceCreator.newInstanceOrNull(clazz);
    }

    @Deprecated
    public static <T> T newInstance(Constructor<T> constructor, Object ... objectArray) {
        return (T)InstanceCreator.newInstance(constructor, (Object[])objectArray);
    }

    static List<ClassLoader> appendContextualClassLoaders(List<ClassLoader> list) {
        List list2 = Lists.newArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            list2.add(classLoader);
        }
        list2.addAll(list);
        return list2;
    }

    public static Class<?> forName(String string) {
        List<ClassLoader> list = ClassHelper.appendContextualClassLoaders(classLoaders);
        for (ClassLoader classLoader : list) {
            if (null == classLoader) continue;
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!classLoaders.isEmpty()) continue;
                ClassHelper.logClassNotFoundError(string, classNotFoundException);
            }
        }
        if (RuntimeBehavior.shouldSkipUsingCallerClassLoader()) {
            return null;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassHelper.logClassNotFoundError(string, classNotFoundException);
            return null;
        }
    }

    private static void logClassNotFoundError(String string, Exception exception) {
        Utils.log(CLASS_HELPER, 2, "Could not instantiate " + string + " : Class doesn't exist (" + exception.getMessage() + ")");
    }

    public static List<ConstructorOrMethod> findDeclaredFactoryMethods(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        ArrayList<ConstructorOrMethod> arrayList = new ArrayList<ConstructorOrMethod>();
        BiConsumer<IFactoryAnnotation, Executable> biConsumer = (iFactoryAnnotation, executable) -> {
            if (iFactoryAnnotation != null) {
                ConstructorOrMethod constructorOrMethod = new ConstructorOrMethod((Executable)executable);
                constructorOrMethod.setEnabled(iFactoryAnnotation.getEnabled());
                arrayList.add(constructorOrMethod);
            }
        };
        for (Method method : ClassHelper.getAvailableMethods(clazz)) {
            IFactoryAnnotation iFactoryAnnotation2 = iAnnotationFinder.findAnnotation(method, IFactoryAnnotation.class);
            biConsumer.accept(iFactoryAnnotation2, method);
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            IFactoryAnnotation iFactoryAnnotation3 = iAnnotationFinder.findAnnotation(constructor, IFactoryAnnotation.class);
            biConsumer.accept(iFactoryAnnotation3, constructor);
        }
        return arrayList;
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        Map map = Maps.newHashMap();
        for (Method entry : ReflectionHelper.getLocalMethods(clazz)) {
            ClassHelper.appendMethod(map, entry);
        }
        Object object = clazz.getSuperclass();
        if (null != object) {
            while (!Object.class.equals(object)) {
                Set<Map.Entry<String, Set<Method>>> set = ClassHelper.extractMethods(clazz, object, map).entrySet();
                for (Map.Entry<String, Set<Method>> entry : set) {
                    Set set2 = (Set)map.get(entry.getKey());
                    if (set2 == null) {
                        map.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    set2.addAll((Collection)entry.getValue());
                }
                object = ((Class)object).getSuperclass();
            }
        }
        Set set = Sets.newHashSet();
        for (Set set3 : map.values()) {
            set.addAll(set3);
        }
        return set;
    }

    @Deprecated
    public static IJUnitTestRunner createTestRunner(TestRunner testRunner) {
        return IJUnitTestRunner.createTestRunner(testRunner);
    }

    private static void appendMethod(Map<String, Set<Method>> map, Method method) {
        Set set = map.computeIfAbsent(method.getName(), string -> Sets.newHashSet());
        set.add(method);
    }

    private static Map<String, Set<Method>> extractMethods(Class<?> clazz, Class<?> clazz2, Map<String, Set<Method>> map) {
        Map map2 = Maps.newHashMap();
        Method[] methodArray = clazz2.getDeclaredMethods();
        Package package_ = clazz.getPackage();
        Package package_2 = clazz2.getPackage();
        boolean bl = ClassHelper.isSamePackage(package_, package_2);
        for (Method method : methodArray) {
            if (!ClassHelper.canInclude(bl, method, map)) continue;
            ClassHelper.appendMethod(map2, method);
        }
        return map2;
    }

    private static boolean canInclude(boolean bl, Method method, Map<String, Set<Method>> map) {
        int n = method.getModifiers();
        boolean bl2 = Modifier.isPublic(n) || Modifier.isProtected(n) || bl && !Modifier.isPrivate(n);
        boolean bl3 = !ClassHelper.isOverridden(method, map) && !Modifier.isAbstract(n);
        return bl2 && bl3;
    }

    private static boolean isSamePackage(Package package_, Package package_2) {
        boolean bl = false;
        if (null == package_ && null == package_2) {
            bl = true;
        }
        if (null != package_ && null != package_2) {
            bl = package_.getName().equals(package_2.getName());
        }
        return bl;
    }

    private static boolean isOverridden(Method method, Map<String, Set<Method>> map) {
        Set<Method> set = map.get(method.getName());
        if (set == null) {
            return false;
        }
        Class<?> clazz = method.getDeclaringClass();
        Class<?>[] classArray = method.getParameterTypes();
        for (Method method2 : set) {
            Class<?>[] classArray2 = method2.getParameterTypes();
            if (!clazz.isAssignableFrom(method2.getDeclaringClass()) || classArray.length != classArray2.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].equals(classArray2[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static IMethodSelector createSelector(XmlMethodSelector xmlMethodSelector) {
        return InstanceCreator.createSelector((XmlMethodSelector)xmlMethodSelector);
    }

    @Deprecated
    public static Object createInstance(Class<?> clazz, Map<Class<?>, IClass> map, XmlTest xmlTest, IAnnotationFinder iAnnotationFinder, ITestObjectFactory iTestObjectFactory, boolean bl) {
        return InstanceCreator.createInstance(clazz, map, (XmlTest)xmlTest, (IAnnotationFinder)iAnnotationFinder, (ITestObjectFactory)iTestObjectFactory, (boolean)bl, (String)"");
    }

    @Deprecated
    public static Object createInstance1(Class<?> clazz, Map<Class<?>, IClass> map, XmlTest xmlTest, IAnnotationFinder iAnnotationFinder, IObjectFactory iObjectFactory, boolean bl) {
        return InstanceCreator.createInstanceUsingObjectFactory(clazz, map, (XmlTest)xmlTest, (IAnnotationFinder)iAnnotationFinder, (IObjectFactory)iObjectFactory, (boolean)bl, (String)"");
    }

    static Constructor<?> findAnnotatedConstructor(IAnnotationFinder iAnnotationFinder, Class<?> clazz) {
        Constructor<?>[] constructorArray;
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            Object object;
            IParametersAnnotation iParametersAnnotation = iAnnotationFinder.findAnnotation(constructor, IParametersAnnotation.class);
            if (iParametersAnnotation != null) {
                Class<?>[] classArray;
                object = iParametersAnnotation.getValue();
                if (((String[])object).length != (classArray = constructor.getParameterTypes()).length) {
                    throw new TestNGException("Parameter count mismatch:  " + constructor + "\naccepts " + classArray.length + " parameters but the @Test annotation declares " + ((String[])object).length);
                }
                return constructor;
            }
            object = iAnnotationFinder.findAnnotation(constructor, IFactoryAnnotation.class);
            if (object == null) continue;
            return constructor;
        }
        return null;
    }

    public static <T> T tryOtherConstructor(Class<T> clazz) {
        T t;
        try {
            if (clazz.getModifiers() == 0) {
                return null;
            }
            Constructor<T> constructor = clazz.getConstructor(String.class);
            t = constructor.newInstance("Default test name");
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null && exception.getCause() != null) {
                string = exception.getCause().getMessage();
            }
            String string2 = "Could not create an instance of class " + clazz + (string != null ? ": " + string : "") + ".\nPlease make sure it has a constructor that accepts either a String or no parameter.";
            throw new TestNGException(string2);
        }
        return t;
    }

    public static Class<?> fileToClass(String string) {
        int n;
        CharSequence charSequence;
        Class<?> clazz = null;
        if (!string.endsWith(".class") && !string.endsWith(".java")) {
            if (string.startsWith("class ")) {
                string = string.substring("class ".length());
            }
            if (null == (clazz = ClassHelper.forName(string))) {
                throw new TestNGException("Cannot load class from file: " + string);
            }
            return clazz;
        }
        int n2 = string.lastIndexOf(".class");
        if (-1 == n2) {
            n2 = string.lastIndexOf(".java");
        }
        String string2 = string.substring(0, n2);
        String[] stringArray = string2.split("[/\\\\]", -1);
        if (-1 != lastGoodRootIndex) {
            charSequence = new StringBuilder(stringArray[lastGoodRootIndex]);
            for (n = lastGoodRootIndex + 1; n < stringArray.length; ++n) {
                ((StringBuilder)charSequence).append(".").append(stringArray[n]);
            }
            clazz = ClassHelper.forName(((StringBuilder)charSequence).toString());
            if (null != clazz) {
                return clazz;
            }
        }
        charSequence = "";
        for (n = stringArray.length - 1; n >= 0; --n) {
            clazz = ClassHelper.forName((String)(charSequence = ((String)charSequence).length() == 0 ? stringArray[n] : stringArray[n] + "." + (String)charSequence));
            if (null == clazz) continue;
            lastGoodRootIndex = n;
            break;
        }
        if (null == clazz) {
            throw new TestNGException("Cannot load class from file: " + string);
        }
        return clazz;
    }

    public static XmlClass[] findClassesInSameTest(Class<?> clazz, XmlSuite xmlSuite) {
        Set set = Sets.newHashSet();
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            set.addAll(ClassHelper.findClassesInSameTest(clazz, xmlTest));
        }
        return set.toArray(new XmlClass[0]);
    }

    private static Collection<XmlClass> findClassesInSameTest(Class<?> clazz, XmlTest xmlTest) {
        Set set = Sets.newHashSet();
        String string = clazz.getName();
        for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
            if (!xmlClass.getName().equals(string)) continue;
            set.addAll(xmlTest.getXmlClasses());
            break;
        }
        return set;
    }
}

