/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Injector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.GuiceHelper;
import org.testng.IClass;
import org.testng.ISuite;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.IParameterInfo;
import org.testng.internal.InstanceCreator;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public class ClassImpl
implements IClass {
    private final Class<?> m_class;
    private Object m_defaultInstance = null;
    private final IAnnotationFinder m_annotationFinder;
    private List<Object> m_instances = Lists.newArrayList();
    private final Map<Class<?>, IClass> m_classes;
    private long[] m_instanceHashCodes;
    private final Object m_instance;
    private final ITestObjectFactory m_objectFactory;
    private String m_testName = null;
    private final XmlClass m_xmlClass;
    private final ITestContext m_testContext;
    private final boolean m_hasParentModule;

    public ClassImpl(ITestContext iTestContext, Class<?> clazz, XmlClass xmlClass, Object object, Map<Class<?>, IClass> map, IAnnotationFinder iAnnotationFinder, ITestObjectFactory iTestObjectFactory) {
        ITestAnnotation iTestAnnotation;
        this.m_testContext = iTestContext;
        this.m_class = clazz;
        this.m_classes = map;
        this.m_xmlClass = xmlClass;
        this.m_annotationFinder = iAnnotationFinder;
        this.m_instance = object;
        this.m_objectFactory = iTestObjectFactory;
        if (object instanceof ITest) {
            this.m_testName = ((ITest)object).getTestName();
        }
        if (this.m_testName == null && (iTestAnnotation = this.m_annotationFinder.findAnnotation(clazz, ITestAnnotation.class)) != null && !iTestAnnotation.getTestName().isEmpty()) {
            this.m_testName = iTestAnnotation.getTestName();
        }
        this.m_hasParentModule = Utils.isStringNotEmpty(this.m_testContext.getSuite().getParentModule());
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    public Class getRealClass() {
        return this.m_class;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashCodes;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_testContext.getCurrentXmlTest();
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    private Object getDefaultInstance(boolean bl, String string) {
        if (this.m_defaultInstance == null) {
            Object object;
            this.m_defaultInstance = this.m_instance != null ? this.m_instance : ((object = this.getInstanceFromGuice()) != null ? object : InstanceCreator.createInstance(this.m_class, this.m_classes, (XmlTest)this.m_testContext.getCurrentXmlTest(), (IAnnotationFinder)this.m_annotationFinder, (ITestObjectFactory)this.m_objectFactory, (boolean)bl, (String)string));
        }
        return this.m_defaultInstance;
    }

    private Object getInstanceFromGuice() {
        Injector injector = this.m_testContext.getInjector(this);
        if (injector == null) {
            return null;
        }
        return injector.getInstance(this.m_class);
    }

    public Injector getParentInjector() {
        ISuite iSuite = this.m_testContext.getSuite();
        Injector injector = iSuite.getParentInjector();
        if (injector == null) {
            injector = GuiceHelper.createInjector(this.m_testContext, Collections.emptyList());
            iSuite.setParentInjector(injector);
        }
        return injector;
    }

    @Override
    public Object[] getInstances(boolean bl) {
        return this.getInstances(bl, "");
    }

    @Override
    public Object[] getInstances(boolean bl, String string) {
        Object[] objectArray = new Object[]{};
        if (this.m_testContext.getCurrentXmlTest().isJUnit() && bl) {
            objectArray = new Object[]{InstanceCreator.createInstance(this.m_class, this.m_classes, (XmlTest)this.m_testContext.getCurrentXmlTest(), (IAnnotationFinder)this.m_annotationFinder, (ITestObjectFactory)this.m_objectFactory, (boolean)bl, (String)string)};
        }
        if (this.m_instances.size() > 0) {
            objectArray = this.m_instances.toArray(new Object[0]);
        } else {
            Object object = this.getDefaultInstance(bl, string);
            if (object != null) {
                objectArray = new Object[]{object};
            }
        }
        int n = this.m_instances.size();
        this.m_instanceHashCodes = new long[n];
        for (int i = 0; i < n; ++i) {
            this.m_instanceHashCodes[i] = ClassImpl.computeHashCode(this.m_instances.get(i));
        }
        return objectArray;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_class.getName()).toString();
    }

    @Override
    public void addInstance(Object object) {
        this.m_instances.add(object);
    }

    private static int computeHashCode(Object object) {
        return IParameterInfo.embeddedInstance(object).hashCode();
    }
}

