/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IClass;
import org.testng.IConfigurable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SuiteRunState;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.BaseInvoker;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.GroupConfigMethodArguments;
import org.testng.internal.IConfigInvoker;
import org.testng.internal.IConfiguration;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.Parameters;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestNgMethodUtils;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;

class ConfigInvoker
extends BaseInvoker
implements IConfigInvoker {
    protected final Map<ITestNGMethod, Set<Object>> m_methodInvocationResults = Maps.newConcurrentMap();
    private final boolean m_continueOnFailedConfiguration;
    private final Set<ITestNGMethod> m_executedConfigMethods = ConcurrentHashMap.newKeySet();
    private final Map<String, Boolean> m_beforegroupsFailures = Maps.newConcurrentMap();

    public ConfigInvoker(ITestResultNotifier iTestResultNotifier, Collection<IInvokedMethodListener> collection, ITestContext iTestContext, SuiteRunState suiteRunState, IConfiguration iConfiguration) {
        super(iTestResultNotifier, collection, iTestContext, suiteRunState, iConfiguration);
        this.m_continueOnFailedConfiguration = iTestContext.getSuite().getXmlSuite().getConfigFailurePolicy() == XmlSuite.FailurePolicy.CONTINUE;
    }

    @Override
    public boolean hasConfigurationFailureFor(ITestNGMethod iTestNGMethod, String[] stringArray, IClass iClass, Object object) {
        boolean bl = false;
        Class<?> clazz = iClass.getRealClass();
        if (this.m_suiteState.isFailed()) {
            bl = true;
        } else {
            boolean bl2 = this.classConfigurationFailed(clazz, object);
            if (bl2) {
                if (!this.m_continueOnFailedConfiguration) {
                    bl = true;
                } else {
                    Set<Object> set = this.getInvocationResults(iClass);
                    bl = set.contains(object);
                }
                return bl;
            }
            if (this.m_continueOnFailedConfiguration && this.hasConfigFailure(iTestNGMethod)) {
                Iterator iterator = TestNgMethodUtils.getMethodInvocationToken(iTestNGMethod, object);
                bl = this.m_methodInvocationResults.get(iTestNGMethod).contains(iterator);
            } else if (!this.m_continueOnFailedConfiguration) {
                for (Class clazz2 : this.m_classInvocationResults.keySet()) {
                    if (!clazz2.isAssignableFrom(clazz) || !((Set)this.m_classInvocationResults.get(clazz2)).contains(object)) continue;
                    bl = true;
                    break;
                }
            }
        }
        for (String string : stringArray) {
            if (!this.m_beforegroupsFailures.containsKey(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void invokeBeforeGroupsConfigurations(GroupConfigMethodArguments groupConfigMethodArguments) {
        List list = Lists.newArrayList();
        String[] stringArray = groupConfigMethodArguments.getTestMethod().getGroups();
        for (String string : stringArray) {
            List<ITestNGMethod> list2 = groupConfigMethodArguments.getGroupMethods().getBeforeGroupMethodsForGroup(string);
            if (list2 == null) continue;
            list.addAll(list2);
        }
        Object[] objectArray = list.toArray(new ITestNGMethod[0]);
        if (objectArray.length > 0) {
            ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs((ITestNGMethod[])objectArray).forSuite(groupConfigMethodArguments.getSuite()).usingParameters(groupConfigMethodArguments.getParameters()).usingInstance(groupConfigMethodArguments.getInstance()).build();
            this.invokeConfigurations(configMethodArguments);
        }
        groupConfigMethodArguments.getGroupMethods().removeBeforeGroups(stringArray);
    }

    @Override
    public void invokeAfterGroupsConfigurations(GroupConfigMethodArguments groupConfigMethodArguments) {
        if (groupConfigMethodArguments.getTestMethod().getGroups().length == 0) {
            return;
        }
        Map map = Maps.newHashMap();
        String[] stringArray = groupConfigMethodArguments.getTestMethod().getGroups();
        for (String list : stringArray) {
            if (!groupConfigMethodArguments.getGroupMethods().isLastMethodForGroup(list, groupConfigMethodArguments.getTestMethod())) continue;
            map.put(list, list);
        }
        if (map.isEmpty()) {
            return;
        }
        Map map2 = Maps.newHashMap();
        for (String string : map.values()) {
            List<ITestNGMethod> list = groupConfigMethodArguments.getGroupMethods().getAfterGroupMethodsForGroup(string);
            if (list == null) continue;
            for (ITestNGMethod iTestNGMethod : list) {
                map2.put(iTestNGMethod, iTestNGMethod);
            }
        }
        ITestNGMethod[] iTestNGMethodArray = map2.keySet().toArray(new ITestNGMethod[0]);
        ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(iTestNGMethodArray).forSuite(groupConfigMethodArguments.getSuite()).usingParameters(groupConfigMethodArguments.getParameters()).usingInstance(groupConfigMethodArguments.getInstance()).build();
        this.invokeConfigurations(configMethodArguments);
        groupConfigMethodArguments.getGroupMethods().removeAfterGroups(map.keySet());
    }

    @Override
    public void invokeConfigurations(ConfigMethodArguments configMethodArguments) {
        if (configMethodArguments.getConfigMethods().length == 0) {
            ConfigInvoker.log(5, "No configuration methods found");
            return;
        }
        ITestNGMethod[] iTestNGMethodArray = TestNgMethodUtils.filterMethods(configMethodArguments.getTestClass(), configMethodArguments.getConfigMethods(), Invoker.SAME_CLASS);
        Object[] objectArray = new Object[]{};
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            if (null == configMethodArguments.getTestClass()) {
                configMethodArguments.setTestClass(iTestNGMethod.getTestClass());
            }
            TestResult testResult = TestResult.newContextAwareTestResult(iTestNGMethod, this.m_testContext);
            testResult.setStatus(16);
            IConfigurationAnnotation iConfigurationAnnotation = null;
            try {
                Object object;
                boolean bl;
                Object object2 = iTestNGMethod.getInstance();
                if (object2 == null) {
                    object2 = configMethodArguments.getInstance();
                }
                Class<?> clazz = object2.getClass();
                ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
                iConfigurationAnnotation = AnnotationHelper.findConfiguration((IAnnotationFinder)this.annotationFinder(), (ConstructorOrMethod)constructorOrMethod);
                boolean bl2 = MethodHelper.isAlwaysRun(iConfigurationAnnotation);
                boolean bl3 = bl = MethodHelper.isEnabled(clazz, this.annotationFinder()) || bl2;
                if (!bl) {
                    ConfigInvoker.log(3, "Skipping " + Utils.detailedMethodName(iTestNGMethod, true) + " because " + clazz.getName() + " is not enabled");
                    continue;
                }
                if (MethodHelper.isDisabled(iConfigurationAnnotation)) {
                    ConfigInvoker.log(3, "Skipping " + Utils.detailedMethodName(iTestNGMethod, true) + " because it is not enabled");
                    continue;
                }
                if (this.hasConfigurationFailureFor(configMethodArguments.getTestMethod(), iTestNGMethod.getGroups(), configMethodArguments.getTestClass(), configMethodArguments.getInstance()) && !bl2) {
                    ConfigInvoker.log(3, "Skipping " + Utils.detailedMethodName(iTestNGMethod, true));
                    object = new InvokedMethod(configMethodArguments.getInstance(), iTestNGMethod, System.currentTimeMillis(), testResult);
                    this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, (IInvokedMethod)object, testResult);
                    testResult.setStatus(3);
                    this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, (IInvokedMethod)object, testResult);
                    this.handleConfigurationSkip(iTestNGMethod, testResult, iConfigurationAnnotation, configMethodArguments.getTestMethod(), configMethodArguments.getInstance(), configMethodArguments.getSuite());
                    continue;
                }
                ConfigInvoker.log(3, "Invoking " + Utils.detailedMethodName(iTestNGMethod, true));
                if (configMethodArguments.getTestMethodResult() != null) {
                    ((TestResult)configMethodArguments.getTestMethodResult()).setMethod(configMethodArguments.getTestMethod());
                }
                objectArray = Parameters.createConfigurationParameters(iTestNGMethod.getConstructorOrMethod().getMethod(), configMethodArguments.getParameters(), configMethodArguments.getParameterValues(), configMethodArguments.getTestMethod(), this.annotationFinder(), configMethodArguments.getSuite(), this.m_testContext, configMethodArguments.getTestMethodResult());
                testResult.setParameters(objectArray);
                this.runConfigurationListeners(testResult, true);
                object = ConfigInvoker.computeInstance(configMethodArguments.getInstance(), object2, iTestNGMethod);
                if (ConfigInvoker.isConfigMethodEligibleForScrutiny(iTestNGMethod)) {
                    if (this.m_executedConfigMethods.add(configMethodArguments.getTestMethod())) {
                        this.invokeConfigurationMethod(object, iTestNGMethod, objectArray, testResult);
                    }
                } else {
                    this.invokeConfigurationMethod(object, iTestNGMethod, objectArray, testResult);
                }
                ConfigInvoker.copyAttributesFromNativelyInjectedTestResult(objectArray, configMethodArguments.getTestMethodResult());
                this.runConfigurationListeners(testResult, false);
            }
            catch (Throwable throwable) {
                this.handleConfigurationFailure(throwable, iTestNGMethod, testResult, iConfigurationAnnotation, configMethodArguments.getTestMethod(), configMethodArguments.getInstance(), configMethodArguments.getSuite());
                ConfigInvoker.copyAttributesFromNativelyInjectedTestResult(objectArray, configMethodArguments.getTestMethodResult());
            }
        }
    }

    private void invokeConfigurationMethod(Object object, ITestNGMethod iTestNGMethod, Object[] objectArray, ITestResult iTestResult) throws InvocationTargetException, IllegalAccessException {
        iTestNGMethod.setId(ThreadUtil.currentThreadInfo());
        InvokedMethod invokedMethod = new InvokedMethod(object, iTestNGMethod, System.currentTimeMillis(), iTestResult);
        this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, iTestResult);
        this.m_notifier.addInvokedMethod(invokedMethod);
        try {
            Reporter.setCurrentTestResult((ITestResult)iTestResult);
            ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
            IConfigurable iConfigurable = this.computeConfigurableInstance(constructorOrMethod, object);
            if (RuntimeBehavior.isDryRun()) {
                iTestResult.setStatus(1);
                return;
            }
            if (iConfigurable != null) {
                MethodInvocationHelper.invokeConfigurable((Object)object, (Object[])objectArray, (IConfigurable)iConfigurable, (Method)constructorOrMethod.getMethod(), (ITestResult)iTestResult);
            } else {
                MethodInvocationHelper.invokeMethodConsideringTimeout((ITestNGMethod)iTestNGMethod, (ConstructorOrMethod)constructorOrMethod, (Object)object, (Object[])objectArray, (ITestResult)iTestResult);
            }
            iTestResult.setStatus(1);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            this.throwConfigurationFailure(iTestResult, reflectiveOperationException);
            iTestResult.setStatus(2);
            throw reflectiveOperationException;
        }
        catch (Throwable throwable) {
            this.throwConfigurationFailure(iTestResult, throwable);
            iTestResult.setStatus(2);
            throw new TestNGException(throwable);
        }
        finally {
            iTestResult.setEndMillis(System.currentTimeMillis());
            Reporter.setCurrentTestResult((ITestResult)iTestResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, iTestResult);
            Reporter.setCurrentTestResult(null);
        }
    }

    private void throwConfigurationFailure(ITestResult iTestResult, Throwable throwable) {
        iTestResult.setStatus(2);
        iTestResult.setThrowable(throwable.getCause() == null ? throwable : throwable.getCause());
    }

    private IConfigurable computeConfigurableInstance(ConstructorOrMethod constructorOrMethod, Object object) {
        return IConfigurable.class.isAssignableFrom(constructorOrMethod.getDeclaringClass()) ? (IConfigurable)object : this.m_configuration.getConfigurable();
    }

    private void runConfigurationListeners(ITestResult iTestResult, boolean bl) {
        if (bl) {
            TestListenerHelper.runPreConfigurationListeners((ITestResult)iTestResult, this.m_notifier.getConfigurationListeners());
        } else {
            TestListenerHelper.runPostConfigurationListeners((ITestResult)iTestResult, this.m_notifier.getConfigurationListeners());
        }
    }

    private void handleConfigurationSkip(ITestNGMethod iTestNGMethod, ITestResult iTestResult, IConfigurationAnnotation iConfigurationAnnotation, ITestNGMethod iTestNGMethod2, Object object, XmlSuite xmlSuite) {
        this.recordConfigurationInvocationFailed(iTestNGMethod, iTestResult.getTestClass(), iConfigurationAnnotation, iTestNGMethod2, object, xmlSuite);
        iTestResult.setStatus(3);
        this.runConfigurationListeners(iTestResult, false);
    }

    private boolean hasConfigFailure(ITestNGMethod iTestNGMethod) {
        return iTestNGMethod != null && this.m_methodInvocationResults.containsKey(iTestNGMethod);
    }

    private void handleConfigurationFailure(Throwable throwable, ITestNGMethod iTestNGMethod, ITestResult iTestResult, IConfigurationAnnotation iConfigurationAnnotation, ITestNGMethod iTestNGMethod2, Object object, XmlSuite xmlSuite) {
        Throwable throwable2;
        Throwable throwable3 = throwable2 = throwable.getCause() != null ? throwable.getCause() : throwable;
        if (this.isSkipExceptionAndSkip(throwable2)) {
            iTestResult.setThrowable(throwable2);
            this.handleConfigurationSkip(iTestNGMethod, iTestResult, iConfigurationAnnotation, iTestNGMethod2, object, xmlSuite);
            return;
        }
        Utils.log("", 3, "Failed to invoke configuration method " + iTestNGMethod.getQualifiedName() + ":" + throwable2.getMessage());
        this.handleException(throwable2, iTestNGMethod, iTestResult, 1);
        iTestResult.setStatus(2);
        this.runConfigurationListeners(iTestResult, false);
        if (null != iConfigurationAnnotation) {
            this.recordConfigurationInvocationFailed(iTestNGMethod, iTestResult.getTestClass(), iConfigurationAnnotation, iTestNGMethod2, object, xmlSuite);
        }
    }

    private static boolean isConfigMethodEligibleForScrutiny(ITestNGMethod iTestNGMethod) {
        if (!iTestNGMethod.isBeforeMethodConfiguration()) {
            return false;
        }
        if (!(iTestNGMethod instanceof ConfigurationMethod)) {
            return false;
        }
        ConfigurationMethod configurationMethod = (ConfigurationMethod)iTestNGMethod;
        return configurationMethod.isFirstTimeOnly();
    }

    private boolean classConfigurationFailed(Class<?> clazz, Object object) {
        return this.m_classInvocationResults.entrySet().stream().anyMatch(entry -> {
            Set set = (Set)entry.getValue();
            Class clazz2 = (Class)entry.getKey();
            boolean bl = set.contains(null);
            return clazz2 == clazz || clazz2.isAssignableFrom(clazz) && (set.contains(object) || bl);
        });
    }

    private static void copyAttributesFromNativelyInjectedTestResult(Object[] objectArray, ITestResult iTestResult) {
        if (objectArray == null || iTestResult == null) {
            return;
        }
        Arrays.stream(objectArray).filter(object -> object instanceof ITestResult).findFirst().ifPresent(object -> TestResult.copyAttributes((ITestResult)object, iTestResult));
    }

    private void setMethodInvocationFailure(ITestNGMethod iTestNGMethod2, Object object) {
        Set set = this.m_methodInvocationResults.computeIfAbsent(iTestNGMethod2, iTestNGMethod -> Sets.newHashSet());
        set.add(TestNgMethodUtils.getMethodInvocationToken(iTestNGMethod2, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClassInvocationFailure(Class<?> clazz2, Object object) {
        Map map = this.m_classInvocationResults;
        synchronized (map) {
            Set set = this.m_classInvocationResults.computeIfAbsent(clazz2, clazz -> Sets.newHashSet());
            set.add(object);
        }
    }

    private void recordConfigurationInvocationFailed(ITestNGMethod iTestNGMethod, IClass iClass, IConfigurationAnnotation iConfigurationAnnotation, ITestNGMethod iTestNGMethod2, Object object, XmlSuite xmlSuite) {
        Object[] objectArray;
        if (iConfigurationAnnotation.getBeforeTestClass() || iConfigurationAnnotation.getAfterTestClass()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setClassInvocationFailure(iClass.getRealClass(), object);
            } else {
                this.setClassInvocationFailure(iTestNGMethod.getRealClass(), object);
            }
        } else if (iConfigurationAnnotation.getBeforeTestMethod() || iConfigurationAnnotation.getAfterTestMethod()) {
            if (this.m_continueOnFailedConfiguration) {
                this.setMethodInvocationFailure(iTestNGMethod2, object);
            } else {
                this.setClassInvocationFailure(iTestNGMethod.getRealClass(), object);
            }
        } else if (iConfigurationAnnotation.getBeforeSuite() || iConfigurationAnnotation.getAfterSuite()) {
            this.m_suiteState.failed();
        } else if (iConfigurationAnnotation.getBeforeTest() || iConfigurationAnnotation.getAfterTest()) {
            this.setClassInvocationFailure(iTestNGMethod.getRealClass(), object);
            objectArray = ClassHelper.findClassesInSameTest(iTestNGMethod.getRealClass(), xmlSuite);
            for (Object object2 : objectArray) {
                this.setClassInvocationFailure(((XmlClass)object2).getSupportClass(), object);
            }
        }
        objectArray = iConfigurationAnnotation.getBeforeGroups();
        for (Object object2 : objectArray) {
            this.m_beforegroupsFailures.put((String)object2, Boolean.FALSE);
        }
    }

    private static Object computeInstance(Object object, Object object2, ITestNGMethod iTestNGMethod) {
        if (object == null || !iTestNGMethod.getConstructorOrMethod().getDeclaringClass().isAssignableFrom(object.getClass())) {
            return object2;
        }
        return object;
    }

    private Set<Object> getInvocationResults(IClass iClass) {
        Class<?> clazz = iClass.getRealClass();
        Set set = null;
        while (!clazz.equals(Object.class) && (set = (Set)this.m_classInvocationResults.get(clazz)) == null) {
            clazz = clazz.getSuperclass();
        }
        if (set == null) {
            throw new IllegalStateException("No failure logs for " + iClass.getRealClass());
        }
        return set;
    }
}

