/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Map;
import org.testng.IClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.MethodArguments;
import org.testng.xml.XmlSuite;

public class ConfigMethodArguments
extends MethodArguments {
    private IClass testClass;
    private final ITestNGMethod[] allMethods;
    private final XmlSuite suite;
    private final ITestResult testMethodResult;

    private ConfigMethodArguments(IClass iClass, ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray, XmlSuite xmlSuite, Map<String, String> map, Object[] objectArray, Object object, ITestResult iTestResult) {
        super(object, iTestNGMethod, map, objectArray);
        this.testClass = iClass;
        this.allMethods = iTestNGMethodArray;
        this.suite = xmlSuite;
        this.testMethodResult = iTestResult;
    }

    public IClass getTestClass() {
        return this.testClass;
    }

    public ITestNGMethod[] getConfigMethods() {
        return this.allMethods;
    }

    public XmlSuite getSuite() {
        return this.suite;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.params;
    }

    @Override
    public Object[] getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    public ITestResult getTestMethodResult() {
        return this.testMethodResult;
    }

    public void setTestClass(IClass iClass) {
        this.testClass = iClass;
    }

    public static class Builder {
        private IClass testClass;
        private ITestNGMethod currentTestMethod;
        private ITestNGMethod[] allMethods;
        private XmlSuite suite;
        private Map<String, String> params;
        private Object[] parameterValues;
        private Object instance;
        private ITestResult testMethodResult;

        public Builder forTestClass(IClass iClass) {
            this.testClass = iClass;
            return this;
        }

        public Builder forTestMethod(ITestNGMethod iTestNGMethod) {
            this.currentTestMethod = iTestNGMethod;
            return this;
        }

        public Builder usingConfigMethodsAs(ITestNGMethod[] iTestNGMethodArray) {
            if (iTestNGMethodArray == null) {
                iTestNGMethodArray = new ITestNGMethod[]{};
            }
            this.allMethods = iTestNGMethodArray;
            return this;
        }

        public Builder usingConfigMethodsAs(Collection<ITestNGMethod> collection) {
            return this.usingConfigMethodsAs(collection.toArray(new ITestNGMethod[0]));
        }

        public Builder forSuite(XmlSuite xmlSuite) {
            this.suite = xmlSuite;
            return this;
        }

        public Builder usingParameters(Map<String, String> map) {
            this.params = map;
            return this;
        }

        public Builder usingParameterValues(Object[] objectArray) {
            this.parameterValues = objectArray;
            return this;
        }

        public Builder usingInstance(Object object) {
            this.instance = object;
            return this;
        }

        public Builder withResult(ITestResult iTestResult) {
            this.testMethodResult = iTestResult;
            return this;
        }

        public ConfigMethodArguments build() {
            return new ConfigMethodArguments(this.testClass, this.currentTestMethod, this.allMethods, this.suite, this.params, this.parameterValues, this.instance, this.testMethodResult);
        }
    }
}

