/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;

public class ConfigurationGroupMethods {
    private final Map<String, List<ITestNGMethod>> m_beforeGroupsMethods;
    private final Set<String> beforeGroupsThatHaveAlreadyRun = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> afterGroupsThatHaveAlreadyRun = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, List<ITestNGMethod>> m_afterGroupsMethods;
    private final ITestNGMethod[] m_allMethods;
    private volatile Map<String, List<ITestNGMethod>> m_afterGroupsMap = null;

    public ConfigurationGroupMethods(ITestNGMethod[] iTestNGMethodArray, Map<String, List<ITestNGMethod>> map, Map<String, List<ITestNGMethod>> map2) {
        this.m_allMethods = iTestNGMethodArray;
        this.m_beforeGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(map);
        this.m_afterGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(map2);
    }

    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allMethods;
    }

    public Map<String, List<ITestNGMethod>> getBeforeGroupsMethods() {
        return this.m_beforeGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getAfterGroupsMethods() {
        return this.m_afterGroupsMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastMethodForGroup(String string, ITestNGMethod iTestNGMethod) {
        if (iTestNGMethod.hasMoreInvocation()) {
            return false;
        }
        ConfigurationGroupMethods configurationGroupMethods = this;
        synchronized (configurationGroupMethods) {
            List<ITestNGMethod> list;
            if (this.m_afterGroupsMap == null) {
                this.m_afterGroupsMap = this.initializeAfterGroupsMap();
            }
            if (null == (list = this.m_afterGroupsMap.get(string)) || list.isEmpty()) {
                return false;
            }
            list.remove(iTestNGMethod);
            return list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<ITestNGMethod>> initializeAfterGroupsMap() {
        Map map = Maps.newConcurrentMap();
        for (ITestNGMethod iTestNGMethod : this.m_allMethods) {
            String[] stringArray;
            for (String string2 : stringArray = iTestNGMethod.getGroups()) {
                List list = map.computeIfAbsent(string2, string -> Lists.newArrayList());
                list.add(iTestNGMethod);
            }
        }
        Set<String> set = this.afterGroupsThatHaveAlreadyRun;
        synchronized (set) {
            this.afterGroupsThatHaveAlreadyRun.clear();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getBeforeGroupMethodsForGroup(String string) {
        Set<String> set = this.beforeGroupsThatHaveAlreadyRun;
        synchronized (set) {
            return ConfigurationGroupMethods.retrieve(this.beforeGroupsThatHaveAlreadyRun, this.m_beforeGroupsMethods, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getAfterGroupMethodsForGroup(String string) {
        Set<String> set = this.afterGroupsThatHaveAlreadyRun;
        synchronized (set) {
            return ConfigurationGroupMethods.retrieve(this.afterGroupsThatHaveAlreadyRun, this.m_afterGroupsMethods, string);
        }
    }

    public void removeBeforeGroups(String[] stringArray) {
        for (String string : stringArray) {
            this.m_beforeGroupsMethods.remove(string);
        }
    }

    public void removeAfterGroups(Collection<String> collection) {
        for (String string : collection) {
            this.m_afterGroupsMethods.remove(string);
        }
    }

    private static List<ITestNGMethod> retrieve(Set<String> set, Map<String, List<ITestNGMethod>> map, String string) {
        if (set.contains(string)) {
            return Collections.emptyList();
        }
        set.add(string);
        return map.get(string);
    }
}

