/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBaseBeforeAfterMethod;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;

public class ConfigurationMethod
extends BaseTestMethod {
    private final boolean m_isBeforeSuiteConfiguration;
    private final boolean m_isAfterSuiteConfiguration;
    private final boolean m_isBeforeTestConfiguration;
    private final boolean m_isAfterTestConfiguration;
    private final boolean m_isBeforeClassConfiguration;
    private final boolean m_isAfterClassConfiguration;
    private final boolean m_isBeforeMethodConfiguration;
    private final boolean m_isAfterMethodConfiguration;
    private boolean m_inheritGroupsFromTestClass = false;

    private ConfigurationMethod(ConstructorOrMethod constructorOrMethod, IAnnotationFinder iAnnotationFinder, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String[] stringArray, String[] stringArray2, boolean bl9, Object object) {
        super(constructorOrMethod.getName(), constructorOrMethod, iAnnotationFinder, object);
        if (bl9) {
            this.init();
        }
        this.m_isBeforeSuiteConfiguration = bl;
        this.m_isAfterSuiteConfiguration = bl2;
        this.m_isBeforeTestConfiguration = bl3;
        this.m_isAfterTestConfiguration = bl4;
        this.m_isBeforeClassConfiguration = bl5;
        this.m_isAfterClassConfiguration = bl6;
        this.m_isBeforeMethodConfiguration = bl7;
        this.m_isAfterMethodConfiguration = bl8;
        this.m_beforeGroups = stringArray;
        this.m_afterGroups = stringArray2;
    }

    public ConfigurationMethod(ConstructorOrMethod constructorOrMethod, IAnnotationFinder iAnnotationFinder, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String[] stringArray, String[] stringArray2, Object object) {
        this(constructorOrMethod, iAnnotationFinder, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, stringArray, stringArray2, true, object);
    }

    private static ITestNGMethod[] createMethods(ITestNGMethod[] iTestNGMethodArray, IAnnotationFinder iAnnotationFinder, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, Object object) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            list.add(new ConfigurationMethod(iTestNGMethod.getConstructorOrMethod(), iAnnotationFinder, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, new String[0], new String[0], object));
        }
        return list.toArray(new ITestNGMethod[0]);
    }

    public static ITestNGMethod[] createSuiteConfigurationMethods(ITestNGMethod[] iTestNGMethodArray, IAnnotationFinder iAnnotationFinder, boolean bl, Object object) {
        return ConfigurationMethod.createMethods(iTestNGMethodArray, iAnnotationFinder, bl, !bl, false, false, false, false, false, false, object);
    }

    public static ITestNGMethod[] createTestConfigurationMethods(ITestNGMethod[] iTestNGMethodArray, IAnnotationFinder iAnnotationFinder, boolean bl, Object object) {
        return ConfigurationMethod.createMethods(iTestNGMethodArray, iAnnotationFinder, false, false, bl, !bl, false, false, false, false, object);
    }

    public static ITestNGMethod[] createClassConfigurationMethods(ITestNGMethod[] iTestNGMethodArray, IAnnotationFinder iAnnotationFinder, boolean bl, Object object) {
        return ConfigurationMethod.createMethods(iTestNGMethodArray, iAnnotationFinder, false, false, false, false, bl, !bl, false, false, object);
    }

    public static ITestNGMethod[] createBeforeConfigurationMethods(ITestNGMethod[] iTestNGMethodArray, IAnnotationFinder iAnnotationFinder, boolean bl, Object object) {
        ITestNGMethod[] iTestNGMethodArray2 = new ITestNGMethod[iTestNGMethodArray.length];
        for (int i = 0; i < iTestNGMethodArray.length; ++i) {
            iTestNGMethodArray2[i] = new ConfigurationMethod(iTestNGMethodArray[i].getConstructorOrMethod(), iAnnotationFinder, false, false, false, false, false, false, false, false, bl ? iTestNGMethodArray[i].getBeforeGroups() : new String[]{}, new String[0], object);
        }
        return iTestNGMethodArray2;
    }

    public static ITestNGMethod[] createAfterConfigurationMethods(ITestNGMethod[] iTestNGMethodArray, IAnnotationFinder iAnnotationFinder, boolean bl, Object object) {
        ITestNGMethod[] iTestNGMethodArray2 = new ITestNGMethod[iTestNGMethodArray.length];
        for (int i = 0; i < iTestNGMethodArray.length; ++i) {
            iTestNGMethodArray2[i] = new ConfigurationMethod(iTestNGMethodArray[i].getConstructorOrMethod(), iAnnotationFinder, false, false, false, false, false, false, false, false, new String[]{}, bl ? new String[]{} : iTestNGMethodArray[i].getAfterGroups(), object);
        }
        return iTestNGMethodArray2;
    }

    public static ITestNGMethod[] createTestMethodConfigurationMethods(ITestNGMethod[] iTestNGMethodArray, IAnnotationFinder iAnnotationFinder, boolean bl, Object object) {
        return ConfigurationMethod.createMethods(iTestNGMethodArray, iAnnotationFinder, false, false, false, false, false, false, bl, !bl, object);
    }

    @Override
    public boolean isAfterClassConfiguration() {
        return this.m_isAfterClassConfiguration;
    }

    @Override
    public boolean isAfterMethodConfiguration() {
        return this.m_isAfterMethodConfiguration;
    }

    @Override
    public boolean isBeforeClassConfiguration() {
        return this.m_isBeforeClassConfiguration;
    }

    @Override
    public boolean isBeforeMethodConfiguration() {
        return this.m_isBeforeMethodConfiguration;
    }

    @Override
    public boolean isAfterSuiteConfiguration() {
        return this.m_isAfterSuiteConfiguration;
    }

    @Override
    public boolean isBeforeSuiteConfiguration() {
        return this.m_isBeforeSuiteConfiguration;
    }

    @Override
    public boolean isBeforeTestConfiguration() {
        return this.m_isBeforeTestConfiguration;
    }

    @Override
    public boolean isAfterTestConfiguration() {
        return this.m_isAfterTestConfiguration;
    }

    @Override
    public boolean isBeforeGroupsConfiguration() {
        return this.m_beforeGroups != null && this.m_beforeGroups.length > 0;
    }

    @Override
    public boolean isAfterGroupsConfiguration() {
        return this.m_afterGroups != null && this.m_afterGroups.length > 0;
    }

    private boolean inheritGroupsFromTestClass() {
        return this.m_inheritGroupsFromTestClass;
    }

    private void init() {
        ITestAnnotation iTestAnnotation;
        IConfigurationAnnotation iConfigurationAnnotation = AnnotationHelper.findConfiguration((IAnnotationFinder)this.m_annotationFinder, (Method)this.m_method.getMethod());
        if (iConfigurationAnnotation != null) {
            this.m_inheritGroupsFromTestClass = iConfigurationAnnotation.getInheritGroups();
            this.setEnabled(iConfigurationAnnotation.getEnabled());
            this.setDescription(iConfigurationAnnotation.getDescription());
        }
        if (iConfigurationAnnotation != null && iConfigurationAnnotation.isFakeConfiguration()) {
            if (iConfigurationAnnotation.getBeforeSuite()) {
                this.initGroups(IBeforeSuite.class);
            }
            if (iConfigurationAnnotation.getAfterSuite()) {
                this.initGroups(IAfterSuite.class);
            }
            if (iConfigurationAnnotation.getBeforeTest()) {
                this.initGroups(IBeforeTest.class);
            }
            if (iConfigurationAnnotation.getAfterTest()) {
                this.initGroups(IAfterTest.class);
            }
            if (iConfigurationAnnotation.getBeforeGroups().length != 0) {
                this.initBeforeAfterGroups(IBeforeGroups.class, iConfigurationAnnotation.getBeforeGroups());
            }
            if (iConfigurationAnnotation.getAfterGroups().length != 0) {
                this.initBeforeAfterGroups(IAfterGroups.class, iConfigurationAnnotation.getAfterGroups());
            }
            if (iConfigurationAnnotation.getBeforeTestClass()) {
                this.initGroups(IBeforeClass.class);
            }
            if (iConfigurationAnnotation.getAfterTestClass()) {
                this.initGroups(IAfterClass.class);
            }
            if (iConfigurationAnnotation.getBeforeTestMethod()) {
                this.initGroups(IBeforeMethod.class);
            }
            if (iConfigurationAnnotation.getAfterTestMethod()) {
                this.initGroups(IAfterMethod.class);
            }
        } else {
            this.initGroups(IConfigurationAnnotation.class);
        }
        if (this.inheritGroupsFromTestClass() && (iTestAnnotation = this.m_annotationFinder.findAnnotation(this.m_methodClass, ITestAnnotation.class)) != null) {
            String[] stringArray = iTestAnnotation.getGroups();
            Map map = Maps.newHashMap();
            for (String string : this.getGroups()) {
                map.put(string, string);
            }
            if (stringArray != null) {
                for (String string : stringArray) {
                    map.put(string, string);
                }
                this.setGroups(map.values().toArray(new String[0]));
            }
        }
        if (iConfigurationAnnotation != null) {
            this.setTimeOut(iConfigurationAnnotation.getTimeOut());
        }
    }

    @Override
    public ConfigurationMethod clone() {
        ConfigurationMethod configurationMethod = new ConfigurationMethod(this.getConstructorOrMethod(), this.getAnnotationFinder(), this.isBeforeSuiteConfiguration(), this.isAfterSuiteConfiguration(), this.isBeforeTestConfiguration(), this.isAfterTestConfiguration(), this.isBeforeClassConfiguration(), this.isAfterClassConfiguration(), this.isBeforeMethodConfiguration(), this.isAfterMethodConfiguration(), this.getBeforeGroups(), this.getAfterGroups(), false, this.getInstance());
        configurationMethod.m_testClass = this.getTestClass();
        configurationMethod.setDate(this.getDate());
        configurationMethod.setGroups(this.getGroups());
        configurationMethod.setGroupsDependedUpon(this.getGroupsDependedUpon(), Collections.emptyList());
        configurationMethod.setMethodsDependedUpon(this.getMethodsDependedUpon());
        configurationMethod.setAlwaysRun(this.isAlwaysRun());
        configurationMethod.setMissingGroup(this.getMissingGroup());
        configurationMethod.setDescription(this.getDescription());
        configurationMethod.setEnabled(this.getEnabled());
        configurationMethod.setParameterInvocationCount(this.getParameterInvocationCount());
        configurationMethod.m_inheritGroupsFromTestClass = this.inheritGroupsFromTestClass();
        return configurationMethod;
    }

    public boolean isFirstTimeOnly() {
        boolean bl = false;
        IBeforeMethod iBeforeMethod = this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IBeforeMethod.class);
        if (iBeforeMethod != null) {
            bl = ((ConfigurationAnnotation)iBeforeMethod).isFirstTimeOnly();
        }
        return bl;
    }

    public boolean isLastTimeOnly() {
        boolean bl = false;
        IAfterMethod iAfterMethod = this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IAfterMethod.class);
        if (iAfterMethod != null) {
            bl = ((ConfigurationAnnotation)iAfterMethod).isLastTimeOnly();
        }
        return bl;
    }

    public String[] getGroupFilters() {
        IBaseBeforeAfterMethod iBaseBeforeAfterMethod = (IBaseBeforeAfterMethod)this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IBeforeMethod.class);
        if (iBaseBeforeAfterMethod == null) {
            iBaseBeforeAfterMethod = (IBaseBeforeAfterMethod)this.m_annotationFinder.findAnnotation(this.getConstructorOrMethod(), IAfterMethod.class);
        }
        if (iBaseBeforeAfterMethod == null) {
            return new String[0];
        }
        return iBaseBeforeAfterMethod.getGroupFilters();
    }
}

