/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;

public class ConstructorOrMethod {
    private Method m_method;
    private Constructor m_constructor;
    private boolean m_enabled = true;

    public ConstructorOrMethod(Method method) {
        this.m_method = method;
    }

    public ConstructorOrMethod(Constructor constructor) {
        this.m_constructor = constructor;
    }

    public ConstructorOrMethod(Executable executable) {
        if (executable instanceof Constructor) {
            this.m_constructor = (Constructor)executable;
        } else {
            this.m_method = (Method)executable;
        }
    }

    public Class<?> getDeclaringClass() {
        return this.getMethod() != null ? this.getMethod().getDeclaringClass() : this.getConstructor().getDeclaringClass();
    }

    public String getName() {
        return this.getMethod() != null ? this.getMethod().getName() : this.getConstructor().getName();
    }

    public Class[] getParameterTypes() {
        return this.getMethod() != null ? this.getMethod().getParameterTypes() : this.getConstructor().getParameterTypes();
    }

    public Method getMethod() {
        return this.m_method;
    }

    public Constructor getConstructor() {
        return this.m_constructor;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getConstructor() == null ? 0 : this.getConstructor().hashCode());
        n = 31 * n + (this.getMethod() == null ? 0 : this.getMethod().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConstructorOrMethod constructorOrMethod = (ConstructorOrMethod)object;
        if (this.getConstructor() == null ? constructorOrMethod.getConstructor() != null : !this.getConstructor().equals(constructorOrMethod.getConstructor())) {
            return false;
        }
        return !(this.getMethod() == null ? constructorOrMethod.getMethod() != null : !this.getMethod().equals(constructorOrMethod.getMethod()));
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public String toString() {
        if (this.m_method != null) {
            return this.m_method.toString();
        }
        return this.m_constructor.toString();
    }

    public String stringifyParameterTypes() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Class clazz : this.getParameterTypes()) {
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(clazz.getName());
        }
        return stringBuilder.toString();
    }
}

