/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IDynamicGraph;
import org.testng.IExecutionVisualiser;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;

public class DynamicGraph<T>
implements IDynamicGraph<T> {
    private final Set<T> m_nodesReady = Sets.newLinkedHashSet();
    private final Set<T> m_nodesRunning = Sets.newLinkedHashSet();
    private final Set<T> m_nodesFinished = Sets.newLinkedHashSet();
    private final Edges<T> m_edges = new Edges();
    private Set<IExecutionVisualiser> visualisers = Sets.newHashSet();

    @Override
    public boolean addNode(T t) {
        return this.m_nodesReady.add(t);
    }

    @Override
    public void addEdge(int n, T t, T t2) {
        this.m_edges.addEdge(n, t, t2, false);
    }

    @Override
    public void setVisualisers(Set<IExecutionVisualiser> set) {
        this.visualisers = set;
    }

    @Override
    public void addEdges(int n, T t, Iterable<T> iterable) {
        for (T t2 : iterable) {
            this.addEdge(n, t, t2);
        }
    }

    @Override
    public List<T> getFreeNodes() {
        Set set = Sets.newLinkedHashSet(this.m_nodesReady);
        set.removeAll(this.m_edges.fromNodes());
        if (set.isEmpty() && this.m_nodesRunning.isEmpty()) {
            int n = this.m_edges.getLowestEdgeWeight(this.m_nodesReady);
            for (Object object : this.m_nodesReady) {
                if (!this.m_edges.hasAllEdgesWithWeight(object, n)) continue;
                set.add(object);
            }
        }
        List list = Lists.newArrayList();
        for (Object object : set) {
            Map<T, Integer> map = this.m_edges.from(object);
            if (map != null && !Collections.disjoint(map.keySet(), set)) continue;
            list.add(object);
        }
        return list;
    }

    @Override
    public List<T> getDependenciesFor(T t) {
        Map<T, Integer> map = this.m_edges.to(t);
        if (map == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(map.keySet());
    }

    @Override
    public void setStatus(Collection<T> collection, IDynamicGraph.Status status) {
        for (T t : collection) {
            this.setStatus(t, status);
        }
    }

    @Override
    public void setStatus(T t, IDynamicGraph.Status status) {
        switch (status) {
            case RUNNING: {
                this.m_nodesReady.remove(t);
                this.m_nodesRunning.add(t);
                break;
            }
            case FINISHED: {
                this.m_nodesReady.remove(t);
                this.m_nodesRunning.remove(t);
                this.m_nodesFinished.add(t);
                Map<T, Integer> map = this.m_edges.from(t);
                Map<T, Integer> map2 = this.m_edges.to(t);
                if (map != null && map2 != null) {
                    for (Map.Entry<T, Integer> entry : map.entrySet()) {
                        for (Map.Entry<T, Integer> entry2 : map2.entrySet()) {
                            if (entry2.getKey() == entry.getKey() || entry2.getValue() > entry.getValue()) continue;
                            int n = Math.max(entry2.getValue(), entry.getValue());
                            this.m_edges.addEdge(n, entry2.getKey(), entry.getKey(), true);
                        }
                    }
                }
                this.m_edges.removeNode(t);
                break;
            }
            case READY: {
                this.m_nodesReady.add(t);
                this.m_nodesRunning.remove(t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status: " + (Object)((Object)status));
            }
        }
        this.visualisers.forEach(iExecutionVisualiser -> iExecutionVisualiser.consumeDotDefinition(this.toDot()));
    }

    @Override
    public int getNodeCount() {
        return this.m_nodesReady.size() + this.m_nodesRunning.size() + this.m_nodesFinished.size();
    }

    @Override
    public int getNodeCountWithStatus(IDynamicGraph.Status status) {
        return this.getNodesWithStatus(status).size();
    }

    @Override
    public Set<T> getNodesWithStatus(IDynamicGraph.Status status) {
        switch (status) {
            case READY: {
                return this.m_nodesReady;
            }
            case RUNNING: {
                return this.m_nodesRunning;
            }
            case FINISHED: {
                return this.m_nodesFinished;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "[DynamicGraph \n  Ready:" + this.m_nodesReady + "\n  Running:" + this.m_nodesRunning + "\n  Finished:" + this.m_nodesFinished + "\n  Edges:\n" + this.m_edges + "]";
    }

    private static <T> String dotShortName(T t) {
        String string = t.toString();
        int n = string.indexOf(40);
        return string.substring(0, n).replaceAll("\\Q.\\E", "_");
    }

    @Override
    public String toDot() {
        String string;
        String string2 = "[style=filled color=yellow]";
        String string3 = "[style=filled color=green]";
        String string4 = "[style=filled color=grey]";
        StringBuilder stringBuilder = new StringBuilder("digraph g {\n");
        List<T> list = this.getFreeNodes();
        for (T t : this.m_nodesReady) {
            string = list.contains(t) ? string2 : "";
            stringBuilder.append("  ").append(DynamicGraph.dotShortName(t)).append(string).append("\n");
        }
        for (T t : this.m_nodesRunning) {
            string = list.contains(t) ? string2 : string3;
            stringBuilder.append("  ").append(DynamicGraph.dotShortName(t)).append(string).append("\n");
        }
        for (T t : this.m_nodesFinished) {
            stringBuilder.append("  ").append(DynamicGraph.dotShortName(t)).append(string4).append("\n");
        }
        this.m_edges.appendDotEdges(stringBuilder, this.m_nodesFinished);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    Map<T, Map<T, Integer>> getEdges() {
        return this.m_edges.getEdges();
    }

    private static class Edges<T> {
        private final Map<T, Map<T, Integer>> m_incomingEdges = new HashMap<T, Map<T, Integer>>();
        private final Map<T, Map<T, Integer>> m_outgoingEdges = new HashMap<T, Map<T, Integer>>();

        private Edges() {
        }

        public void addEdge(int n, T t, T t2, boolean bl) {
            if (t.equals(t2)) {
                return;
            }
            Integer n2 = this.findReversedEdge(t, t2);
            if (n2 != null && n2 == n) {
                if (!bl) {
                    throw new IllegalStateException("Circular dependency: " + t + " <-> " + t2);
                }
                return;
            }
            Edges.addEdgeToMap(this.m_incomingEdges, t2, t, n);
            Edges.addEdgeToMap(this.m_outgoingEdges, t, t2, n);
        }

        Set<T> fromNodes() {
            return this.m_outgoingEdges.keySet();
        }

        Map<T, Integer> from(T t) {
            Map<T, Integer> map = this.m_outgoingEdges.get(t);
            return map == null ? null : Collections.unmodifiableMap(map);
        }

        Map<T, Integer> to(T t) {
            Map<T, Integer> map = this.m_incomingEdges.get(t);
            return map == null ? null : Collections.unmodifiableMap(map);
        }

        private Integer findReversedEdge(T t, T t2) {
            Map<T, Integer> map = this.m_outgoingEdges.get(t2);
            return map == null ? null : map.get(t);
        }

        void removeNode(T t) {
            Map<T, Integer> map;
            Map<T, Integer> map2 = this.m_outgoingEdges.remove(t);
            if (map2 != null) {
                Edges.removeEdgesFromMap(this.m_incomingEdges, map2.keySet(), t);
            }
            if ((map = this.m_incomingEdges.remove(t)) != null) {
                Edges.removeEdgesFromMap(this.m_outgoingEdges, map.keySet(), t);
            }
        }

        int getLowestEdgeWeight(Set<T> set) {
            if (set.isEmpty()) {
                return 0;
            }
            Set set2 = Sets.newHashSet(set);
            set2.retainAll(this.m_outgoingEdges.keySet());
            if (set2.isEmpty()) {
                return 0;
            }
            int n = Integer.MAX_VALUE;
            for (Object e : set2) {
                Map<T, Integer> map = this.m_outgoingEdges.get(e);
                n = Math.min(n, Collections.min(map.values()));
            }
            return n;
        }

        boolean hasAllEdgesWithWeight(T t, int n) {
            Map<T, Integer> map = this.m_outgoingEdges.get(t);
            if (map == null) {
                return true;
            }
            for (int n2 : map.values()) {
                if (n2 == n) continue;
                return false;
            }
            return true;
        }

        private static <T> void removeEdgesFromMap(Map<T, Map<T, Integer>> map, Collection<T> collection, T t) {
            for (T t2 : collection) {
                Map<T, Integer> map2 = map.get(t2);
                if (map2 == null) {
                    throw new IllegalStateException("Edge not found in map.");
                }
                map2.remove(t);
                if (!map2.isEmpty()) continue;
                map.remove(t2);
            }
        }

        private static <T> void addEdgeToMap(Map<T, Map<T, Integer>> map, T t, T t2, int n) {
            Map map2;
            Integer n2 = (Integer)(map2 = map.computeIfAbsent(t, object -> new HashMap())).get(t2);
            map2.put(t2, Math.max(n, n2 != null ? n2 : Integer.MIN_VALUE));
        }

        Map<T, Map<T, Integer>> getEdges() {
            Map map = Maps.newHashMap();
            for (Map.Entry<T, Map<T, Integer>> entry : this.m_outgoingEdges.entrySet()) {
                map.put(entry.getKey(), Collections.unmodifiableMap(entry.getValue()));
            }
            return Collections.unmodifiableMap(map);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<T, Map<T, Integer>> entry : this.m_outgoingEdges.entrySet()) {
                stringBuilder.append("     ").append(entry.getKey()).append("\n");
                for (Map.Entry<T, Integer> entry2 : entry.getValue().entrySet()) {
                    stringBuilder.append("        (").append(entry2.getValue()).append(") ").append(entry2.getKey()).append("\n");
                }
            }
            return stringBuilder.toString();
        }

        void appendDotEdges(StringBuilder stringBuilder, Set<T> set) {
            for (Map.Entry<T, Map<T, Integer>> entry : this.m_outgoingEdges.entrySet()) {
                T t = entry.getKey();
                for (T t2 : entry.getValue().keySet()) {
                    String string = set.contains(t) ? "style=dotted" : "";
                    stringBuilder.append("  ").append(DynamicGraph.dotShortName(t)).append(" -> ").append(DynamicGraph.dotShortName(t2)).append(" [dir=back ").append(string).append("]\n");
                }
            }
        }
    }
}

