/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.internal.ExitCode;
import org.testng.xml.XmlSuite;

public class ExitCodeListener
implements ITestListener,
IReporter {
    private boolean hasTests = false;
    private final ExitCode status = new ExitCode();

    public ExitCode getStatus() {
        return this.status;
    }

    public boolean noTestsFound() {
        return !this.hasTests;
    }

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        for (ISuite iSuite : list2) {
            for (ISuiteResult iSuiteResult : iSuite.getResults().values()) {
                ITestContext iTestContext = iSuiteResult.getTestContext();
                this.status.computeAndUpdate(iTestContext);
            }
        }
    }

    @Override
    public void onTestStart(ITestResult iTestResult) {
        this.hasTests = true;
    }

    @Override
    public void onTestSuccess(ITestResult iTestResult) {
        this.hasTests = true;
    }

    @Override
    public void onTestFailure(ITestResult iTestResult) {
        this.hasTests = true;
    }

    @Override
    public void onTestSkipped(ITestResult iTestResult) {
        this.hasTests = true;
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        this.hasTests = true;
    }

    @Override
    public void onStart(ITestContext iTestContext) {
    }

    @Override
    public void onFinish(ITestContext iTestContext) {
    }
}

