/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import org.testng.IExpectedExceptionsHolder;
import org.testng.ITestNGMethod;
import org.testng.TestException;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;

public class ExpectedExceptionsHolder {
    protected final IAnnotationFinder finder;
    protected final ITestNGMethod method;
    private final Class<?>[] expectedClasses;
    private final IExpectedExceptionsHolder holder;

    protected ExpectedExceptionsHolder(IAnnotationFinder iAnnotationFinder, ITestNGMethod iTestNGMethod, IExpectedExceptionsHolder iExpectedExceptionsHolder) {
        this.finder = iAnnotationFinder;
        this.method = iTestNGMethod;
        this.expectedClasses = ExpectedExceptionsHolder.findExpectedClasses(iAnnotationFinder, iTestNGMethod);
        this.holder = iExpectedExceptionsHolder;
    }

    private static Class<?>[] findExpectedClasses(IAnnotationFinder iAnnotationFinder, ITestNGMethod iTestNGMethod) {
        ITestAnnotation iTestAnnotation = iAnnotationFinder.findAnnotation(iTestNGMethod, ITestAnnotation.class);
        if (iTestAnnotation != null) {
            return iTestAnnotation.getExpectedExceptions();
        }
        return new Class[0];
    }

    public boolean isExpectedException(Throwable throwable) {
        if (this.hasNoExpectedClasses()) {
            return false;
        }
        if (throwable.getClass() == TestException.class) {
            return false;
        }
        Class<?> clazz = throwable.getClass();
        for (Class<?> clazz2 : this.expectedClasses) {
            if (!clazz2.isAssignableFrom(clazz) || !this.holder.isThrowableMatching(throwable)) continue;
            return true;
        }
        return false;
    }

    public Throwable wrongException(Throwable throwable) {
        if (this.hasNoExpectedClasses()) {
            return throwable;
        }
        if (this.holder.isThrowableMatching(throwable)) {
            return new TestException("Expected exception of " + this.getExpectedExceptionsPluralize() + " but got " + throwable, throwable);
        }
        return new TestException(this.holder.getWrongExceptionMessage(throwable), throwable);
    }

    public TestException noException(ITestNGMethod iTestNGMethod) {
        if (this.hasNoExpectedClasses()) {
            return null;
        }
        return new TestException("Method " + iTestNGMethod + " should have thrown an exception of " + this.getExpectedExceptionsPluralize());
    }

    private boolean hasNoExpectedClasses() {
        return this.expectedClasses == null || this.expectedClasses.length == 0;
    }

    private String getExpectedExceptionsPluralize() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.expectedClasses.length > 1) {
            stringBuilder.append("any of types ");
            stringBuilder.append(Arrays.toString(this.expectedClasses));
        } else {
            stringBuilder.append("type ");
            stringBuilder.append(this.expectedClasses[0]);
        }
        return stringBuilder.toString();
    }
}

