/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.IDataProviderListener;
import org.testng.IInstanceInfo;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.IParameterInfo;
import org.testng.internal.InstanceCreator;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.ParameterInfo;
import org.testng.internal.Parameters;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FactoryMethod
extends BaseTestMethod {
    private final IFactoryAnnotation factoryAnnotation;
    private final Object m_instance;
    private final ITestContext m_testContext;
    private final ITestObjectFactory objectFactory;
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> m_dataProviderListeners;
    private String m_factoryCreationFailedMessage = null;

    public String getFactoryCreationFailedMessage() {
        return this.m_factoryCreationFailedMessage;
    }

    private void init(Object object, IAnnotationFinder iAnnotationFinder, ConstructorOrMethod constructorOrMethod) {
        Class<? extends ITestNGListener>[] classArray;
        IListenersAnnotation iListenersAnnotation = iAnnotationFinder.findAnnotation(constructorOrMethod.getDeclaringClass(), IListenersAnnotation.class);
        if (iListenersAnnotation == null) {
            return;
        }
        for (Class<? extends ITestNGListener> clazz : classArray = iListenersAnnotation.getValue()) {
            Class<? extends ITestNGListener> clazz2;
            if (!IDataProviderListener.class.isAssignableFrom(clazz) || this.m_dataProviderListeners.containsKey(clazz2 = clazz)) continue;
            if (object != null && IDataProviderListener.class.isAssignableFrom(object.getClass())) {
                this.m_dataProviderListeners.put(clazz2, (IDataProviderListener)object);
                continue;
            }
            Object object2 = InstanceCreator.newInstanceOrNull(clazz);
            if (object2 == null) continue;
            this.m_dataProviderListeners.put(clazz2, (IDataProviderListener)object2);
        }
    }

    FactoryMethod(ConstructorOrMethod constructorOrMethod, Object object, IAnnotationFinder iAnnotationFinder, ITestContext iTestContext, ITestObjectFactory iTestObjectFactory, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map) {
        super(constructorOrMethod.getName(), constructorOrMethod, iAnnotationFinder, object);
        this.m_dataProviderListeners = map;
        this.init(object, iAnnotationFinder, constructorOrMethod);
        Utils.checkInstanceOrStatic(object, constructorOrMethod.getMethod());
        Utils.checkReturnType(constructorOrMethod.getMethod(), Object[].class, IInstanceInfo[].class);
        Class<?> clazz = constructorOrMethod.getDeclaringClass();
        if (object != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new TestNGException("Mismatch between instance/method classes:" + object.getClass() + " " + clazz);
        }
        if (object == null && constructorOrMethod.getMethod() != null && !Modifier.isStatic(constructorOrMethod.getMethod().getModifiers())) {
            throw new TestNGException("An inner factory method MUST be static. But '" + constructorOrMethod.getMethod().getName() + "' from '" + clazz.getName() + "' is not.");
        }
        if (constructorOrMethod.getMethod() != null && !Modifier.isPublic(constructorOrMethod.getMethod().getModifiers())) {
            try {
                constructorOrMethod.getMethod().setAccessible(true);
            }
            catch (SecurityException securityException) {
                throw new TestNGException(constructorOrMethod.getMethod().getName() + " must be public", securityException);
            }
        }
        this.factoryAnnotation = iAnnotationFinder.findAnnotation(constructorOrMethod, IFactoryAnnotation.class);
        this.m_instance = object;
        this.m_testContext = iTestContext;
        NoOpTestClass noOpTestClass = new NoOpTestClass();
        noOpTestClass.setTestClass(clazz);
        this.m_testClass = noOpTestClass;
        this.objectFactory = iTestObjectFactory;
        this.m_groups = FactoryMethod.getAllGroups(clazz, iTestContext.getCurrentXmlTest(), iAnnotationFinder);
    }

    private static String[] getAllGroups(Class<?> clazz, XmlTest xmlTest, IAnnotationFinder iAnnotationFinder) {
        TestNGMethodFinder testNGMethodFinder = new TestNGMethodFinder(new RunInfo(), iAnnotationFinder);
        ITestNGMethod[] iTestNGMethodArray = testNGMethodFinder.getTestMethods(clazz, xmlTest);
        HashSet<String> hashSet = new HashSet<String>();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            hashSet.addAll(Arrays.asList(iTestNGMethod.getGroups()));
        }
        return hashSet.toArray(new String[0]);
    }

    public IParameterInfo[] invoke() {
        List list = Lists.newArrayList();
        Map map = Maps.newHashMap();
        Parameters.MethodParameters methodParameters = new Parameters.MethodParameters(this.m_testContext.getCurrentXmlTest().getAllParameters(), this.findMethodParameters(this.m_testContext.getCurrentXmlTest()), null, null, this.m_testContext, null);
        Iterator<Object[]> iterator = Parameters.handleParameters((ITestNGMethod)this, (Map<String, String>)map, (Object)this.m_instance, (Parameters.MethodParameters)methodParameters, (XmlSuite)this.m_testContext.getCurrentXmlTest().getSuite(), (IAnnotationFinder)this.m_annotationFinder, null, this.m_dataProviderListeners.values(), (String)"@Factory").parameters;
        try {
            List<Integer> list2 = this.factoryAnnotation.getIndices();
            int n = 0;
            while (iterator.hasNext()) {
                Object object2;
                Object[] objectArray = iterator.next();
                if (objectArray == null) continue;
                ConstructorOrMethod constructorOrMethod = this.getConstructorOrMethod();
                if (constructorOrMethod.getMethod() != null) {
                    object2 = (Object[])constructorOrMethod.getMethod().invoke(this.m_instance, objectArray);
                    if (object2 == null) {
                        object2 = new Object[]{};
                    }
                    if (((Object[])object2).length == 0) {
                        this.m_factoryCreationFailedMessage = String.format("The Factory method %s.%s() should have produced at-least one instance.", constructorOrMethod.getDeclaringClass().getName(), constructorOrMethod.getName());
                    }
                    if (list2 == null || list2.isEmpty()) {
                        list.addAll(Arrays.stream(object2).map(object -> new ParameterInfo(object, objectArray)).collect(Collectors.toList()));
                    } else {
                        for (Integer n2 : list2) {
                            int n3 = n2 - n;
                            if (n3 < 0 || n3 >= ((Object[])object2).length) continue;
                            list.add(new ParameterInfo(object2[n3], objectArray));
                        }
                    }
                    n += ((Object[])object2).length;
                    continue;
                }
                if (list2 == null || list2.isEmpty() || list2.contains(n)) {
                    if (this.objectFactory instanceof IObjectFactory) {
                        object2 = ((IObjectFactory)this.objectFactory).newInstance(constructorOrMethod.getConstructor(), objectArray);
                    } else if (this.objectFactory instanceof IObjectFactory2) {
                        object2 = ((IObjectFactory2)this.objectFactory).newInstance(constructorOrMethod.getDeclaringClass());
                    } else {
                        throw new IllegalStateException("Unsupported ITestObjectFactory " + this.objectFactory.getClass());
                    }
                    list.add(new ParameterInfo(object2, objectArray));
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            ConstructorOrMethod constructorOrMethod = this.getConstructorOrMethod();
            throw new TestNGException("The factory method " + constructorOrMethod.getDeclaringClass() + "." + constructorOrMethod.getName() + "() threw an exception", throwable);
        }
        return list.toArray(new IParameterInfo[0]);
    }

    @Override
    public ITestNGMethod clone() {
        throw new IllegalStateException("clone is not supported for FactoryMethod");
    }
}

