/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Tarjan;

public class Graph<T> {
    private static boolean m_verbose = false;
    private Map<T, Node<T>> m_nodes = Maps.newLinkedHashMap();
    private List<T> m_strictlySortedNodes = null;
    private final Comparator<Node<T>> comparator;
    private Map<T, Node<T>> m_independentNodes = null;

    public Graph(Comparator<Node<T>> comparator) {
        this.comparator = comparator;
    }

    public void addNode(T t) {
        Graph.ppp("ADDING NODE " + t + " " + t.hashCode());
        this.m_nodes.put(t, new Node<T>(t));
    }

    public Set<T> getPredecessors(T t) {
        return this.findNode(t).getPredecessors().keySet();
    }

    public boolean isIndependent(T t) {
        return this.m_independentNodes.containsKey(t);
    }

    private Node<T> findNode(T t) {
        return this.m_nodes.get(t);
    }

    public void addPredecessor(T t, T t2) {
        Node<T> node = this.findNode(t);
        if (null == node) {
            throw new TestNGException("Non-existing node: " + t);
        }
        node.addPredecessor(t2);
        this.addNeighbor(t, t2);
        this.initializeIndependentNodes();
        this.m_independentNodes.remove(t2);
        this.m_independentNodes.remove(t);
        Graph.ppp("  REMOVED " + t2 + " FROM INDEPENDENT OBJECTS");
    }

    private void addNeighbor(T t, T t2) {
        this.findNode(t).addNeighbor(this.findNode(t2));
    }

    private Collection<Node<T>> getNodes() {
        return this.m_nodes.values();
    }

    public Set<T> getIndependentNodes() {
        return this.m_independentNodes.keySet();
    }

    public List<T> getStrictlySortedNodes() {
        return this.m_strictlySortedNodes;
    }

    public void topologicalSort() {
        Graph.ppp("================ SORTING");
        this.m_strictlySortedNodes = Lists.newArrayList();
        this.initializeIndependentNodes();
        List list = Lists.newArrayList();
        for (Node<T> node2 : this.getNodes()) {
            if (!this.isIndependent(node2.getObject())) {
                Graph.ppp("ADDING FOR SORT: " + node2.getObject());
                list.add(node2.clone());
                continue;
            }
            Graph.ppp("SKIPPING INDEPENDENT NODE " + node2);
        }
        list.sort(this.comparator);
        while (!list.isEmpty()) {
            Node<T> node = this.findNodeWithNoPredecessors(list);
            if (null == node) {
                Node<T> node2;
                node2 = new Tarjan(this, ((Node)list.get(0)).getObject()).getCycle();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The following methods have cyclic dependencies:\n");
                Iterator iterator = node2.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    stringBuilder.append(e).append("\n");
                }
                throw new TestNGException(stringBuilder.toString());
            }
            this.m_strictlySortedNodes.add(node.getObject());
            this.removeFromNodes(list, node);
        }
        Graph.ppp("=============== DONE SORTING");
        if (m_verbose) {
            this.dumpSortedNodes();
        }
    }

    private void initializeIndependentNodes() {
        if (null == this.m_independentNodes) {
            List list = Lists.newArrayList(this.m_nodes.values());
            list.sort(this.comparator);
            this.m_independentNodes = Maps.newLinkedHashMap();
            for (Node node : list) {
                this.m_independentNodes.put(node.getObject(), node);
            }
        }
    }

    private void dumpSortedNodes() {
        System.out.println("====== SORTED NODES");
        for (T t : this.m_strictlySortedNodes) {
            System.out.println("              " + t);
        }
        System.out.println("====== END SORTED NODES");
    }

    private void removeFromNodes(List<Node<T>> list, Node<T> node) {
        list.remove(node);
        for (Node<T> node2 : list) {
            node2.removePredecessor(node.getObject());
        }
    }

    private static void ppp(String string) {
        if (m_verbose) {
            System.out.println("[Graph] " + string);
        }
    }

    private Node<T> findNodeWithNoPredecessors(List<Node<T>> list) {
        for (Node<T> node : list) {
            if (node.hasPredecessors()) continue;
            return node;
        }
        return null;
    }

    public List<T> findPredecessors(T t) {
        Node<T> node = this.findNode(t);
        if (null == node) {
            return Lists.newArrayList();
        }
        LinkedList linkedList = new LinkedList();
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        hashSet.add(t);
        linkedList2.addLast(t);
        while (!linkedList2.isEmpty()) {
            for (Object e : this.getPredecessors(linkedList2.removeFirst())) {
                if (hashSet.contains(e)) continue;
                hashSet.add(e);
                linkedList2.addLast(e);
                linkedList.addFirst(e);
            }
        }
        return linkedList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Graph ");
        for (T t : this.m_nodes.keySet()) {
            stringBuilder.append(this.findNode(t)).append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class Node<T> {
        private T m_object;
        private Map<T, T> m_predecessors = Maps.newHashMap();
        private Set<Node<T>> m_neighbors = new HashSet<Node<T>>();

        public Node(T t) {
            this.m_object = t;
        }

        public void addNeighbor(Node<T> node) {
            this.m_neighbors.add(node);
        }

        public Node<T> clone() {
            Node<T> node = new Node<T>(this.m_object);
            for (T t : this.m_predecessors.values()) {
                node.addPredecessor(t);
            }
            return node;
        }

        public T getObject() {
            return this.m_object;
        }

        public Map<T, T> getPredecessors() {
            return this.m_predecessors;
        }

        public boolean removePredecessor(T t) {
            boolean bl = false;
            T t2 = this.m_predecessors.get(t);
            if (null != t2) {
                boolean bl2 = bl = null != this.m_predecessors.remove(t);
                if (bl) {
                    Graph.ppp("  REMOVED PRED " + t + " FROM NODE " + this.m_object);
                } else {
                    Graph.ppp("  FAILED TO REMOVE PRED " + t + " FROM NODE " + this.m_object);
                }
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[Node:" + this.m_object);
            stringBuilder.append("  pred:");
            for (T t : this.m_predecessors.values()) {
                stringBuilder.append(" ").append(t);
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public void addPredecessor(T t) {
            Graph.ppp("  ADDING PREDECESSOR FOR " + this.m_object + " ==> " + t);
            this.m_predecessors.put(t, t);
        }

        public boolean hasPredecessors() {
            return this.m_predecessors.size() > 0;
        }
    }
}

