/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IDataProviderListener;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SuiteRunState;
import org.testng.internal.ConfigInvoker;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.TestInvoker;
import org.testng.internal.Utils;
import org.testng.xml.XmlSuite;

public class Invoker
implements IInvoker {
    static final BiPredicate<ITestNGMethod, IClass> CAN_RUN_FROM_CLASS = ITestNGMethod::canRunFromClass;
    static final BiPredicate<ITestNGMethod, IClass> SAME_CLASS = (iTestNGMethod, iClass) -> iClass == null || iTestNGMethod.getTestClass().getName().equals(iClass.getName());
    private final TestInvoker m_testInvoker;
    private final ConfigInvoker m_configInvoker;

    public Invoker(IConfiguration iConfiguration, ITestContext iTestContext, ITestResultNotifier iTestResultNotifier, SuiteRunState suiteRunState, boolean bl, Collection<IInvokedMethodListener> collection, List<IClassListener> list, Collection<IDataProviderListener> collection2) {
        this.m_configInvoker = new ConfigInvoker(iTestResultNotifier, collection, iTestContext, suiteRunState, iConfiguration);
        this.m_testInvoker = new TestInvoker(iTestResultNotifier, iTestContext, suiteRunState, iConfiguration, collection, collection2, list, bl, this.m_configInvoker);
    }

    @Override
    public ConfigInvoker getConfigInvoker() {
        return this.m_configInvoker;
    }

    @Override
    public TestInvoker getTestInvoker() {
        return this.m_testInvoker;
    }

    @Override
    public void invokeConfigurations(IClass iClass, ITestNGMethod[] iTestNGMethodArray, XmlSuite xmlSuite, Map<String, String> map, Object[] objectArray, Object object) {
        ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().forTestClass(iClass).usingConfigMethodsAs(iTestNGMethodArray).forSuite(xmlSuite).usingParameters(map).usingParameterValues(objectArray).usingInstance(object).build();
        this.m_configInvoker.invokeConfigurations(configMethodArguments);
    }

    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod iTestNGMethod, Map<String, String> map, ConfigurationGroupMethods configurationGroupMethods, Object object, ITestContext iTestContext) {
        return this.m_testInvoker.invokeTestMethods(iTestNGMethod, configurationGroupMethods, object, iTestContext);
    }

    static void log(int n, String string) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), n, string);
    }
}

