/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodGroupsHelper {
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    static void collectMethodsByGroup(ITestNGMethod[] iTestNGMethodArray, boolean bl, List<ITestNGMethod> list, List<ITestNGMethod> list2, RunInfo runInfo, IAnnotationFinder iAnnotationFinder, boolean bl2) {
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            boolean bl3 = false;
            Method method = iTestNGMethod.getConstructorOrMethod().getMethod();
            if (bl) {
                bl3 = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest((IAnnotationFinder)iAnnotationFinder, (Method)method), runInfo, iTestNGMethod, bl, bl2, list);
            } else {
                IConfigurationAnnotation iConfigurationAnnotation = AnnotationHelper.findConfiguration((IAnnotationFinder)iAnnotationFinder, (Method)method);
                if (iConfigurationAnnotation.getAlwaysRun()) {
                    if (!bl2 || MethodGroupsHelper.isMethodAlreadyNotPresent(list, iTestNGMethod)) {
                        bl3 = true;
                    }
                } else {
                    bl3 = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest((IAnnotationFinder)iAnnotationFinder, (ITestNGMethod)iTestNGMethod), runInfo, iTestNGMethod, bl, bl2, list);
                }
            }
            if (bl3) {
                list.add(iTestNGMethod);
                continue;
            }
            list2.add(iTestNGMethod);
        }
    }

    private static boolean includeMethod(ITestOrConfiguration iTestOrConfiguration, RunInfo runInfo, ITestNGMethod iTestNGMethod, boolean bl, boolean bl2, List<ITestNGMethod> list) {
        boolean bl3 = false;
        if (MethodHelper.isEnabled(iTestOrConfiguration) && runInfo.includeMethod(iTestNGMethod, bl)) {
            if (bl2) {
                if (MethodGroupsHelper.isMethodAlreadyNotPresent(list, iTestNGMethod)) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
        }
        return bl3;
    }

    private static boolean isMethodAlreadyNotPresent(List<ITestNGMethod> list, ITestNGMethod iTestNGMethod) {
        for (ITestNGMethod iTestNGMethod2 : list) {
            Class<?> clazz;
            Class<?> clazz2;
            ConstructorOrMethod constructorOrMethod = iTestNGMethod2.getConstructorOrMethod();
            ConstructorOrMethod constructorOrMethod2 = iTestNGMethod.getConstructorOrMethod();
            if (!constructorOrMethod.getName().equals(constructorOrMethod2.getName()) || !(clazz2 = constructorOrMethod.getDeclaringClass()).isAssignableFrom(clazz = constructorOrMethod2.getDeclaringClass()) && !clazz.isAssignableFrom(clazz2)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, List<ITestNGMethod>> findGroupsMethods(Collection<ITestClass> collection, boolean bl) {
        Map map = Maps.newHashMap();
        for (ITestClass iTestClass : collection) {
            ITestNGMethod[] iTestNGMethodArray;
            for (ITestNGMethod iTestNGMethod : iTestNGMethodArray = bl ? iTestClass.getBeforeGroupsMethods() : iTestClass.getAfterGroupsMethods()) {
                String[] stringArray = bl ? iTestNGMethod.getBeforeGroups() : iTestNGMethod.getAfterGroups();
                List list = Stream.concat(Arrays.stream(stringArray), Arrays.stream(iTestNGMethod.getGroups())).collect(Collectors.toList());
                for (String string2 : list) {
                    List list2 = map.computeIfAbsent(string2, string -> Lists.newArrayList());
                    if (list2.contains(iTestNGMethod)) continue;
                    list2.add(iTestNGMethod);
                }
            }
        }
        return map;
    }

    protected static void findGroupTransitiveClosure(List<ITestNGMethod> list, List<ITestNGMethod> list2, String[] stringArray, Set<String> set, Set<ITestNGMethod> set2) {
        Map<ITestNGMethod, ITestNGMethod> map = list.stream().collect(Collectors.toMap(iTestNGMethod -> iTestNGMethod, iTestNGMethod -> iTestNGMethod));
        Map<String, String> map2 = Arrays.stream(stringArray).collect(Collectors.toMap(string -> string, string -> string));
        boolean bl = true;
        Map map3 = Maps.newHashMap();
        while (bl) {
            for (ITestNGMethod iTestNGMethod2 : list) {
                ITestNGMethod[] iTestNGMethodArray;
                int n;
                String[] stringArray2;
                String[] stringArray3 = stringArray2 = iTestNGMethod2.getGroupsDependedUpon();
                int n2 = stringArray3.length;
                for (n = 0; n < n2; ++n) {
                    String string2 = stringArray3[n];
                    if (map2.containsKey(string2)) continue;
                    map2.put(string2, string2);
                    for (ITestNGMethod iTestNGMethod3 : iTestNGMethodArray = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethod2, list2.toArray(new ITestNGMethod[0]), string2)) {
                        if (map.containsKey(iTestNGMethod3)) continue;
                        map.put(iTestNGMethod3, iTestNGMethod3);
                        map3.put(iTestNGMethod3, iTestNGMethod3);
                    }
                }
                String[] stringArray4 = stringArray3 = iTestNGMethod2.getMethodsDependedUpon();
                n = stringArray4.length;
                for (int i = 0; i < n; ++i) {
                    iTestNGMethodArray = stringArray4[i];
                    ITestNGMethod[] iTestNGMethodArray2 = MethodGroupsHelper.findMethodNamed((String)iTestNGMethodArray, list2);
                    if (iTestNGMethodArray2 == null || map.containsKey(iTestNGMethodArray2)) continue;
                    map.put((ITestNGMethod)iTestNGMethodArray2, (ITestNGMethod)iTestNGMethodArray2);
                    map3.put(iTestNGMethodArray2, iTestNGMethodArray2);
                }
            }
            bl = map3.size() > 0;
            list = Lists.newArrayList();
            list.addAll(map3.keySet());
            map3 = Maps.newHashMap();
        }
        set2.addAll(map.keySet());
        set.addAll(map2.keySet());
    }

    private static ITestNGMethod findMethodNamed(String string, List<ITestNGMethod> list) {
        return list.stream().filter(iTestNGMethod -> iTestNGMethod.getQualifiedName().equals(string)).findFirst().orElse(null);
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray, String string) {
        ITestNGMethod[] iTestNGMethodArray2 = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethodArray, string);
        if (iTestNGMethodArray2.length == 0) {
            iTestNGMethod.setMissingGroup(string);
        }
        return iTestNGMethodArray2;
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod[] iTestNGMethodArray, String string) {
        Pattern pattern = MethodGroupsHelper.getPattern(string);
        Predicate<ITestNGMethod> predicate = iTestNGMethod -> Arrays.stream(iTestNGMethod.getGroups()).anyMatch(string -> MethodGroupsHelper.isMatch(pattern, string));
        return (ITestNGMethod[])Arrays.stream(iTestNGMethodArray).filter(predicate).toArray(ITestNGMethod[]::new);
    }

    private static Boolean isMatch(Pattern pattern, String string) {
        Pair<String, String> pair = Pair.create(pattern.pattern(), string);
        Boolean bl = MATCH_CACHE.get(pair);
        if (bl == null) {
            bl = pattern.matcher(string).matches();
            MATCH_CACHE.put(pair, bl);
        }
        return bl;
    }

    private static Pattern getPattern(String string) {
        Pattern pattern = PATTERN_CACHE.get(string);
        if (pattern == null) {
            pattern = Pattern.compile(string);
            PATTERN_CACHE.put(string, pattern);
        }
        return pattern;
    }
}

