/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Comparator;
import java.util.List;
import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;
import org.testng.collections.Objects;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

public class MethodInstance
implements IMethodInstance {
    private ITestNGMethod m_method;
    public static final Comparator<IMethodInstance> SORT_BY_INDEX = new Comparator<IMethodInstance>(){

        @Override
        public int compare(IMethodInstance iMethodInstance, IMethodInstance iMethodInstance2) {
            XmlTest xmlTest = iMethodInstance.getMethod().getTestClass().getXmlTest();
            XmlTest xmlTest2 = iMethodInstance2.getMethod().getTestClass().getXmlTest();
            if (!xmlTest.getName().equals(xmlTest2.getName())) {
                return 0;
            }
            int n = 0;
            XmlClass xmlClass = iMethodInstance.getMethod().getTestClass().getXmlClass();
            XmlClass xmlClass2 = iMethodInstance2.getMethod().getTestClass().getXmlClass();
            if (xmlClass == null || xmlClass2 == null) {
                if (xmlClass != null) {
                    return -1;
                }
                if (xmlClass2 != null) {
                    return 1;
                }
                return 0;
            }
            if (!xmlClass.getName().equals(xmlClass2.getName())) {
                int n2 = xmlClass.getIndex();
                int n3 = xmlClass2.getIndex();
                n = n2 - n3;
            } else {
                XmlInclude xmlInclude = this.findXmlInclude(xmlClass.getIncludedMethods(), iMethodInstance.getMethod().getMethodName());
                XmlInclude xmlInclude2 = this.findXmlInclude(xmlClass2.getIncludedMethods(), iMethodInstance2.getMethod().getMethodName());
                if (xmlInclude != null && xmlInclude2 != null) {
                    n = xmlInclude.getIndex() - xmlInclude2.getIndex();
                }
            }
            return n;
        }

        private XmlInclude findXmlInclude(List<XmlInclude> list, String string) {
            for (XmlInclude xmlInclude : list) {
                if (!xmlInclude.getName().equals(string)) continue;
                return xmlInclude;
            }
            return null;
        }
    };

    public MethodInstance(ITestNGMethod iTestNGMethod) {
        this.m_method = iTestNGMethod;
    }

    @Override
    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    @Override
    public Object getInstance() {
        return this.m_method.getInstance();
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("method", (Object)this.m_method).add("instance", this.getInstance()).toString();
    }
}

