/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.Maps;

class ScriptMethodSelector {
    private final ScriptEngine engine;
    private final String expression;

    ScriptMethodSelector(ScriptEngine scriptEngine, String string) {
        this.engine = scriptEngine;
        this.expression = string.trim();
    }

    boolean includeMethodFromExpression(ITestNGMethod iTestNGMethod) {
        Map map = Maps.newHashMap();
        for (String string : iTestNGMethod.getGroups()) {
            map.put(string, string);
        }
        try {
            ScriptMethodSelector.setContext(this.engine, map, iTestNGMethod);
            Object scriptException = this.engine.eval(this.expression);
            if (scriptException == null) {
                String string = String.format("The " + this.engine.getFactory().getLanguageName() + " expression [%s] evaluated to null.", this.expression);
                throw new TestNGException(string);
            }
            int string = ((Boolean)scriptException).booleanValue() ? 1 : 0;
            return string != 0;
        }
        catch (ScriptException scriptException) {
            throw new TestNGException(scriptException);
        }
        finally {
            ScriptMethodSelector.resetContext(this.engine);
        }
    }

    private static void setContext(ScriptEngine scriptEngine, Map<String, String> map, ITestNGMethod iTestNGMethod) {
        ScriptContext scriptContext = scriptEngine.getContext();
        Method method = iTestNGMethod.getConstructorOrMethod().getMethod();
        scriptContext.setAttribute("method", method, 100);
        scriptContext.setAttribute("groups", map, 100);
        scriptContext.setAttribute("testngMethod", iTestNGMethod, 100);
    }

    private static void resetContext(ScriptEngine scriptEngine) {
        ScriptContext scriptContext = scriptEngine.getContext();
        scriptContext.removeAttribute("method", 100);
        scriptContext.removeAttribute("groups", 100);
        scriptContext.removeAttribute("testngMethod", 100);
    }
}

