/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.IClassListener;
import org.testng.IDataProviderListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SuiteRunState;
import org.testng.SuiteRunner;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.BaseInvoker;
import org.testng.internal.ConfigInvoker;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ExpectedExceptionsHolder;
import org.testng.internal.GroupConfigMethodArguments;
import org.testng.internal.IConfiguration;
import org.testng.internal.IMethodRunner;
import org.testng.internal.ITestInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.ParameterHandler;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Parameters;
import org.testng.internal.SingleTestMethodWorker;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestMethodArguments;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNgMethodUtils;
import org.testng.internal.TestResult;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.thread.ThreadUtil;
import org.testng.thread.IWorker;
import org.testng.xml.XmlSuite;

class TestInvoker
extends BaseInvoker
implements ITestInvoker {
    private final ConfigInvoker invoker;
    private final Collection<IDataProviderListener> m_dataproviderListeners;
    private final List<IClassListener> m_classListeners;
    private final boolean m_skipFailedInvocationCounts;

    public TestInvoker(ITestResultNotifier iTestResultNotifier, ITestContext iTestContext, SuiteRunState suiteRunState, IConfiguration iConfiguration, Collection<IInvokedMethodListener> collection, Collection<IDataProviderListener> collection2, List<IClassListener> list, boolean bl, ConfigInvoker configInvoker) {
        super(iTestResultNotifier, collection, iTestContext, suiteRunState, iConfiguration);
        this.m_dataproviderListeners = collection2;
        this.m_classListeners = list;
        this.m_skipFailedInvocationCounts = bl;
        this.invoker = configInvoker;
    }

    @Override
    public ITestResultNotifier getNotifier() {
        return this.m_notifier;
    }

    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod iTestNGMethod, ConfigurationGroupMethods configurationGroupMethods, Object object, ITestContext iTestContext) {
        if (iTestNGMethod.getTestClass() == null) {
            throw new IllegalArgumentException("COULDN'T FIND TESTCLASS FOR " + iTestNGMethod.getRealClass());
        }
        XmlSuite xmlSuite = iTestContext.getSuite().getXmlSuite();
        if (!MethodHelper.isEnabled(iTestNGMethod.getConstructorOrMethod().getMethod(), this.annotationFinder())) {
            return Collections.emptyList();
        }
        Map<String, String> map = iTestNGMethod.findMethodParameters(iTestContext.getCurrentXmlTest());
        String string = this.checkDependencies(iTestNGMethod, iTestContext.getAllTestMethods());
        if (string != null) {
            ITestResult iTestResult = this.registerSkippedTestResult(iTestNGMethod, System.currentTimeMillis(), new Throwable(string));
            this.m_notifier.addSkippedTest(iTestNGMethod, iTestResult);
            InvokedMethod invokedMethod = new InvokedMethod(iTestResult.getInstance(), iTestNGMethod, System.currentTimeMillis(), iTestResult);
            this.invokeListenersForSkippedTestResult(iTestResult, invokedMethod);
            iTestNGMethod.incrementCurrentInvocationCount();
            GroupConfigMethodArguments groupConfigMethodArguments = new GroupConfigMethodArguments.Builder().forTestMethod(iTestNGMethod).withGroupConfigMethods(configurationGroupMethods).forSuite(xmlSuite).forInstance(object).withParameters(map).build();
            this.invoker.invokeAfterGroupsConfigurations(groupConfigMethodArguments);
            return Collections.singletonList(iTestResult);
        }
        if (iTestNGMethod.getInvocationCount() > 1 && iTestNGMethod.getThreadPoolSize() > 1) {
            return this.invokePooledTestMethods(iTestNGMethod, xmlSuite, map, configurationGroupMethods, iTestContext);
        }
        long l = iTestNGMethod.getInvocationTimeOut();
        boolean bl = iTestNGMethod.getThreadPoolSize() > 1 || l > 0L;
        ITestClass iTestClass = iTestNGMethod.getTestClass();
        ITestNGMethod[] iTestNGMethodArray = TestNgMethodUtils.filterBeforeTestMethods(iTestClass, Invoker.CAN_RUN_FROM_CLASS);
        ITestNGMethod[] iTestNGMethodArray2 = TestNgMethodUtils.filterAfterTestMethods(iTestClass, Invoker.CAN_RUN_FROM_CLASS);
        int n = bl ? 1 : iTestNGMethod.getInvocationCount();
        TestMethodArguments testMethodArguments = new TestMethodArguments.Builder().usingInstance(object).forTestMethod(iTestNGMethod).withParameters(map).forTestClass(iTestClass).usingBeforeMethods(iTestNGMethodArray).usingAfterMethods(iTestNGMethodArray2).usingGroupMethods(configurationGroupMethods).build();
        MethodInvocationAgent methodInvocationAgent = new MethodInvocationAgent(testMethodArguments, this, iTestContext);
        while (n-- > 0) {
            n = methodInvocationAgent.invoke(n);
        }
        return methodInvocationAgent.getResult();
    }

    @Override
    public ITestResult invokeTestMethod(TestMethodArguments testMethodArguments, XmlSuite xmlSuite, ITestInvoker.FailureContext failureContext) {
        testMethodArguments.getTestMethod().setId(ThreadUtil.currentThreadInfo());
        return this.invokeMethod(testMethodArguments, xmlSuite, failureContext);
    }

    @Override
    public ITestInvoker.FailureContext retryFailed(TestMethodArguments testMethodArguments, List<ITestResult> list, int n, ITestContext iTestContext) {
        ITestInvoker.FailureContext failureContext = new ITestInvoker.FailureContext();
        failureContext.count = n;
        Collection<IDataProviderListener> collection = this.dataProviderListeners();
        do {
            failureContext.instances = Lists.newArrayList();
            Map map = Maps.newHashMap();
            ParameterHandler parameterHandler = new ParameterHandler(this.annotationFinder(), collection);
            ParameterHandler.ParameterBag parameterBag = parameterHandler.createParameters(testMethodArguments.getTestMethod(), testMethodArguments.getParameters(), map, iTestContext);
            Object[] objectArray = Parameters.getParametersFromIndex(Objects.requireNonNull(parameterBag.parameterHolder).parameters, testMethodArguments.getParametersIndex());
            if (parameterBag.parameterHolder.origin == ParameterHolder.ParameterOrigin.NATIVE) {
                objectArray = testMethodArguments.getParameterValues();
            }
            TestMethodArguments testMethodArguments2 = new TestMethodArguments.Builder().usingArguments(testMethodArguments).withParameterValues(objectArray).withParameters(map).build();
            list.add(this.invokeMethod(testMethodArguments2, iTestContext.getSuite().getXmlSuite(), failureContext));
        } while (!failureContext.instances.isEmpty());
        return failureContext;
    }

    @Override
    public void runTestResultListener(ITestResult iTestResult) {
        TestListenerHelper.runTestListeners((ITestResult)iTestResult, this.m_notifier.getTestListeners());
    }

    private Collection<IDataProviderListener> dataProviderListeners() {
        ISuite iSuite = this.m_testContext.getSuite();
        Set set = Sets.newHashSet(this.m_dataproviderListeners);
        if (iSuite instanceof SuiteRunner) {
            Collection<IDataProviderListener> collection = ((SuiteRunner)iSuite).getDataProviderListeners();
            set.addAll(collection);
        }
        return set;
    }

    private String checkDependencies(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        Object[] objectArray;
        if (iTestNGMethod.isAlwaysRun()) {
            return null;
        }
        if (iTestNGMethod.getMissingGroup() != null && !iTestNGMethod.ignoreMissingDependencies()) {
            return "Method " + iTestNGMethod + " depends on nonexistent group \"" + iTestNGMethod.getMissingGroup() + "\"";
        }
        String[] stringArray = iTestNGMethod.getGroupsDependedUpon();
        if (null != stringArray && stringArray.length > 0) {
            objectArray = stringArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                ITestNGMethod[] iTestNGMethodArray2 = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethod, this.m_testContext.getAllTestMethods(), (String)object);
                if (iTestNGMethodArray2.length == 0 && !iTestNGMethod.ignoreMissingDependencies()) {
                    return "Method " + iTestNGMethod + " depends on nonexistent group \"" + (String)object + "\"";
                }
                if (!this.failuresPresentInUpstreamDependency(iTestNGMethod, iTestNGMethodArray2)) continue;
                return "Method " + iTestNGMethod + " depends on not successfully finished methods in group \"" + (String)object + "\"";
            }
        }
        if (TestNgMethodUtils.cannotRunMethodIndependently(iTestNGMethod) && this.failuresPresentInUpstreamDependency(iTestNGMethod, (ITestNGMethod[])(objectArray = MethodHelper.findDependedUponMethods(iTestNGMethod, iTestNGMethodArray)))) {
            return "Method " + iTestNGMethod + " depends on not successfully finished methods";
        }
        return null;
    }

    private List<ITestResult> runWorkers(ITestNGMethod iTestNGMethod, List<IWorker<ITestNGMethod>> list, int n, ConfigurationGroupMethods configurationGroupMethods, XmlSuite xmlSuite, Map<String, String> map) {
        Object[] objectArray;
        ITestClass iTestClass = iTestNGMethod.getTestClass();
        for (Object object : objectArray = iTestClass.getInstances(true)) {
            GroupConfigMethodArguments groupConfigMethodArguments = new GroupConfigMethodArguments.Builder().forTestMethod(iTestNGMethod).withGroupConfigMethods(configurationGroupMethods).forSuite(xmlSuite).withParameters(map).forInstance(object).build();
            this.invoker.invokeBeforeGroupsConfigurations(groupConfigMethodArguments);
        }
        long l = -1L;
        for (IWorker<ITestNGMethod> iWorker : list) {
            long l2 = iWorker.getTimeOut();
            if (l2 <= l) continue;
            l = l2;
        }
        ThreadUtil.execute((String)"methods", list, (int)n, (long)l, (boolean)true);
        List list2 = Lists.newArrayList();
        for (IWorker<ITestNGMethod> iWorker : list) {
            if (!(iWorker instanceof TestMethodWorker)) continue;
            list2.addAll(((TestMethodWorker)iWorker).getTestResults());
        }
        for (Object object : objectArray) {
            GroupConfigMethodArguments groupConfigMethodArguments = new GroupConfigMethodArguments.Builder().forTestMethod(iTestNGMethod).withGroupConfigMethods(configurationGroupMethods).forSuite(xmlSuite).withParameters(map).forInstance(object).build();
            this.invoker.invokeAfterGroupsConfigurations(groupConfigMethodArguments);
        }
        return list2;
    }

    private boolean failuresPresentInUpstreamDependency(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
            boolean bl;
            Set<ITestResult> set = this.keepSameInstances(iTestNGMethod, this.m_notifier.getPassedTests(iTestNGMethod2));
            Set set2 = Sets.newHashSet();
            Set<ITestResult> set3 = this.m_notifier.getSkippedTests(iTestNGMethod2);
            set2.addAll(this.m_notifier.getFailedTests(iTestNGMethod2));
            set2.addAll(set3);
            Set<ITestResult> set4 = this.keepSameInstances(iTestNGMethod, set2);
            boolean bl2 = bl = !set.isEmpty() && !set3.isEmpty();
            if (!bl && !set4.isEmpty()) {
                return true;
            }
            for (ITestResult iTestResult : set) {
                if (iTestResult.isSuccess()) continue;
                return true;
            }
        }
        return false;
    }

    private Set<ITestResult> keepSameInstances(ITestNGMethod iTestNGMethod, Set<ITestResult> set) {
        Set set2 = Sets.newHashSet();
        for (ITestResult iTestResult : set) {
            Object object;
            Object object2 = iTestNGMethod.getInstance();
            Object object3 = object = iTestResult.getInstance() != null ? iTestResult.getInstance() : iTestResult.getMethod().getInstance();
            if (iTestResult.getTestClass() == iTestNGMethod.getTestClass() && object != object2) continue;
            set2.add(iTestResult);
        }
        return set2;
    }

    private List<ITestResult> invokePooledTestMethods(ITestNGMethod iTestNGMethod, XmlSuite xmlSuite, Map<String, String> map, ConfigurationGroupMethods configurationGroupMethods, ITestContext iTestContext) {
        List list = Lists.newArrayList();
        for (int i = 0; i < iTestNGMethod.getInvocationCount(); ++i) {
            ITestNGMethod iTestNGMethod2 = iTestNGMethod.clone();
            iTestNGMethod2.setInvocationCount(1);
            iTestNGMethod2.setThreadPoolSize(1);
            MethodInstance methodInstance = new MethodInstance(iTestNGMethod2);
            list.add(new SingleTestMethodWorker(this, this.invoker, methodInstance, map, iTestContext, this.m_classListeners));
        }
        return this.runWorkers(iTestNGMethod, list, iTestNGMethod.getThreadPoolSize(), configurationGroupMethods, xmlSuite, map);
    }

    private void collectResults(ITestNGMethod iTestNGMethod, ITestResult iTestResult) {
        int n = iTestResult.getStatus();
        if (1 == n) {
            this.m_notifier.addPassedTest(iTestNGMethod, iTestResult);
        } else if (3 == n) {
            this.m_notifier.addSkippedTest(iTestNGMethod, iTestResult);
        } else if (2 == n) {
            this.m_notifier.addFailedTest(iTestNGMethod, iTestResult);
        } else if (4 == n) {
            this.m_notifier.addFailedButWithinSuccessPercentageTest(iTestNGMethod, iTestResult);
        } else assert (false) : "UNKNOWN STATUS:" + n;
    }

    @Override
    public void invokeListenersForSkippedTestResult(ITestResult iTestResult, IInvokedMethod iInvokedMethod) {
        if (this.m_configuration.alwaysRunListeners()) {
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, iInvokedMethod, iTestResult);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, iInvokedMethod, iTestResult);
        }
        this.runTestResultListener(iTestResult);
    }

    private static void setTestStatus(ITestResult iTestResult, int n) {
        if (iTestResult.getStatus() == 16) {
            iTestResult.setStatus(n);
        }
    }

    private void handleInvocationResults(ITestNGMethod iTestNGMethod, ITestResult iTestResult, ITestInvoker.FailureContext failureContext, StatusHolder statusHolder, boolean bl) {
        boolean bl2;
        List list = Lists.newArrayList();
        Throwable throwable = iTestResult.getThrowable();
        int n = TestInvoker.computeTestStatusComparingTestResultAndStatusHolder(iTestResult, statusHolder, bl);
        boolean bl3 = statusHolder.handled;
        IRetryAnalyzer iRetryAnalyzer = iTestNGMethod.getRetryAnalyzer(iTestResult);
        boolean bl4 = bl2 = iRetryAnalyzer != null && n == 2 && failureContext.instances != null && iRetryAnalyzer.retry(iTestResult);
        if (bl2) {
            list.add(iTestResult);
            Object object = iTestResult.getInstance();
            if (!failureContext.instances.contains(object)) {
                failureContext.instances.add(object);
            }
            iTestResult.setStatus(3);
            iTestResult.setWasRetried(true);
        } else {
            iTestResult.setStatus(n);
            if (n == 2 && !bl3) {
                int n2 = failureContext.count++;
                if (iTestNGMethod.isDataDriven()) {
                    n2 = 0;
                }
                this.handleException(throwable, iTestNGMethod, iTestResult, n2);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private ITestResult invokeMethod(TestMethodArguments var1_1, XmlSuite var2_2, ITestInvoker.FailureContext var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runAfterGroupsConfigurations(TestMethodArguments testMethodArguments, XmlSuite xmlSuite, TestResult testResult) {
        ITestNGMethod[] iTestNGMethodArray = TestNgMethodUtils.filterTeardownConfigurationMethods(testMethodArguments.getTestMethod(), testMethodArguments.getAfterMethods());
        this.runConfigMethods(testMethodArguments, xmlSuite, testResult, iTestNGMethodArray);
        GroupConfigMethodArguments groupConfigMethodArguments = new GroupConfigMethodArguments.Builder().forTestMethod(testMethodArguments.getTestMethod()).withGroupConfigMethods(testMethodArguments.getGroupMethods()).forSuite(xmlSuite).withParameters(testMethodArguments.getParameters()).forInstance(testMethodArguments.getInstance()).build();
        this.invoker.invokeAfterGroupsConfigurations(groupConfigMethodArguments);
    }

    private void runConfigMethods(TestMethodArguments testMethodArguments, XmlSuite xmlSuite, TestResult testResult, ITestNGMethod[] iTestNGMethodArray) {
        ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().forTestClass(testMethodArguments.getTestClass()).forTestMethod(testMethodArguments.getTestMethod()).usingConfigMethodsAs(iTestNGMethodArray).forSuite(xmlSuite).usingParameters(testMethodArguments.getParameters()).usingParameterValues(testMethodArguments.getParameterValues()).usingInstance(testMethodArguments.getInstance()).withResult(testResult).build();
        this.invoker.invokeConfigurations(configMethodArguments);
    }

    @Override
    public ITestResult registerSkippedTestResult(ITestNGMethod iTestNGMethod, long l, Throwable throwable) {
        TestResult testResult = TestResult.newEndTimeAwareTestResult(iTestNGMethod, this.m_testContext, throwable, l);
        testResult.setStatus(16);
        this.runTestResultListener(testResult);
        testResult.setStatus(3);
        Reporter.setCurrentTestResult((ITestResult)testResult);
        return testResult;
    }

    private StatusHolder considerExceptions(ITestNGMethod iTestNGMethod, ITestResult iTestResult, ExpectedExceptionsHolder expectedExceptionsHolder, ITestInvoker.FailureContext failureContext) {
        TestException testException;
        StatusHolder statusHolder = new StatusHolder();
        statusHolder.status = iTestResult.getStatus();
        statusHolder.handled = false;
        Throwable throwable = iTestResult.getThrowable();
        if (statusHolder.status == 2 && throwable != null) {
            if (expectedExceptionsHolder != null) {
                if (expectedExceptionsHolder.isExpectedException(throwable)) {
                    iTestResult.setStatus(1);
                    statusHolder.status = 1;
                } else if (this.isSkipExceptionAndSkip(throwable)) {
                    statusHolder.status = 3;
                } else {
                    iTestResult.setThrowable(expectedExceptionsHolder.wrongException(throwable));
                    statusHolder.status = 2;
                }
            } else {
                this.handleException(throwable, iTestNGMethod, iTestResult, failureContext.count++);
                statusHolder.handled = true;
                statusHolder.status = iTestResult.getStatus();
            }
        } else if (statusHolder.status != 3 && expectedExceptionsHolder != null && (testException = expectedExceptionsHolder.noException(iTestNGMethod)) != null) {
            iTestResult.setThrowable(testException);
            statusHolder.status = 2;
        }
        return statusHolder;
    }

    private static int computeTestStatusComparingTestResultAndStatusHolder(ITestResult iTestResult, StatusHolder statusHolder, boolean bl) {
        if (bl) {
            return statusHolder.status;
        }
        return iTestResult.getStatus();
    }

    private class MethodInvocationAgent {
        private final ITestContext context;
        private final List<ITestResult> result = Lists.newArrayList();
        private final ITestInvoker.FailureContext failure = new ITestInvoker.FailureContext();
        private final ITestInvoker invoker;
        private final TestMethodArguments arguments;

        public MethodInvocationAgent(TestMethodArguments testMethodArguments, ITestInvoker iTestInvoker, ITestContext iTestContext) {
            this.arguments = testMethodArguments;
            this.invoker = iTestInvoker;
            this.context = iTestContext;
        }

        public List<ITestResult> getResult() {
            return this.result;
        }

        public int invoke(int n) {
            AtomicInteger atomicInteger = new AtomicInteger(n);
            long l = System.currentTimeMillis();
            Map map = Maps.newHashMap();
            ParameterHandler parameterHandler = new ParameterHandler(TestInvoker.this.annotationFinder(), TestInvoker.this.dataProviderListeners());
            ParameterHandler.ParameterBag parameterBag = parameterHandler.createParameters(this.arguments.getTestMethod(), this.arguments.getParameters(), map, this.context, this.arguments.getInstance());
            if (parameterBag.hasErrors()) {
                ITestResult iTestResult = parameterBag.errorResult;
                Throwable throwable = Objects.requireNonNull(iTestResult).getThrowable();
                if (throwable instanceof TestNGException) {
                    iTestResult.setStatus(2);
                    TestInvoker.this.m_notifier.addFailedTest(this.arguments.getTestMethod(), iTestResult);
                } else {
                    iTestResult.setStatus(3);
                    TestInvoker.this.m_notifier.addSkippedTest(this.arguments.getTestMethod(), iTestResult);
                }
                TestInvoker.this.runTestResultListener(iTestResult);
                this.result.add(iTestResult);
                return atomicInteger.get();
            }
            Iterator<Object[]> iterator = Objects.requireNonNull(parameterBag.parameterHolder).parameters;
            try {
                IMethodRunner iMethodRunner = this.invoker.getRunner();
                if (parameterBag.runInParallel()) {
                    List<ITestResult> list = iMethodRunner.runInParallel(this.arguments, this.invoker, this.context, atomicInteger, this.failure, iterator, TestInvoker.this.m_skipFailedInvocationCounts);
                    this.result.addAll(list);
                } else {
                    List<ITestResult> list = iMethodRunner.runInSequence(this.arguments, this.invoker, this.context, atomicInteger, this.failure, iterator, TestInvoker.this.m_skipFailedInvocationCounts);
                    this.result.addAll(list);
                }
            }
            catch (Throwable throwable) {
                TestResult testResult = TestResult.newEndTimeAwareTestResult(this.arguments.getTestMethod(), TestInvoker.this.m_testContext, throwable, l);
                testResult.setStatus(2);
                this.result.add(testResult);
                TestInvoker.this.runTestResultListener(testResult);
                TestInvoker.this.m_notifier.addFailedTest(this.arguments.getTestMethod(), testResult);
            }
            return atomicInteger.get();
        }
    }

    private static class StatusHolder {
        boolean handled = false;
        int status;

        private StatusHolder() {
        }
    }
}

