/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.testng.ClassMethodMap;
import org.testng.IClassListener;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IConfigInvoker;
import org.testng.internal.ITestInvoker;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.TestMethodComparator;
import org.testng.thread.IWorker;

public class TestMethodWorker
implements IWorker<ITestNGMethod> {
    private List<IMethodInstance> m_methodInstances;
    private final Map<String, String> m_parameters;
    private List<ITestResult> m_testResults = Lists.newArrayList();
    private final ConfigurationGroupMethods m_groupMethods;
    private final ClassMethodMap m_classMethodMap;
    private final ITestContext m_testContext;
    private final List<IClassListener> m_listeners;
    private long currentThreadId;
    private long threadIdToRunOn = -1L;
    private boolean completed = true;
    private final ITestInvoker m_testInvoker;
    private final IConfigInvoker m_configInvoker;

    public TestMethodWorker(ITestInvoker iTestInvoker, IConfigInvoker iConfigInvoker, List<IMethodInstance> list, Map<String, String> map, ConfigurationGroupMethods configurationGroupMethods, ClassMethodMap classMethodMap, ITestContext iTestContext, List<IClassListener> list2) {
        this.m_testInvoker = iTestInvoker;
        this.m_configInvoker = iConfigInvoker;
        this.m_methodInstances = list;
        this.m_parameters = map;
        this.m_groupMethods = configurationGroupMethods;
        this.m_classMethodMap = classMethodMap;
        this.m_testContext = iTestContext;
        this.m_listeners = list2;
    }

    @Override
    public long getTimeOut() {
        long l = 0L;
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            ITestNGMethod iTestNGMethod = iMethodInstance.getMethod();
            if (iTestNGMethod.getTimeOut() <= l) continue;
            l = iTestNGMethod.getTimeOut();
        }
        return l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Worker thread:" + Thread.currentThread().getId() + " priority:" + this.getPriority() + " ");
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            stringBuilder.append(iMethodInstance.getMethod()).append(" ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.currentThreadId = Thread.currentThread().getId();
        if (RuntimeBehavior.enforceThreadAffinity() && this.doesTaskHavePreRequistes() && this.currentThreadId != this.threadIdToRunOn) {
            this.completed = false;
            return;
        }
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            ITestNGMethod iTestNGMethod = iMethodInstance.getMethod();
            if (this.canInvokeBeforeClassMethods()) {
                ITestClass iTestClass = iTestNGMethod.getTestClass();
                synchronized (iTestClass) {
                    this.invokeBeforeClassMethods(iTestNGMethod.getTestClass(), iMethodInstance);
                }
            }
            try {
                this.invokeTestMethods(iTestNGMethod, iMethodInstance.getInstance());
            }
            finally {
                this.invokeAfterClassMethods(iTestNGMethod.getTestClass(), iMethodInstance);
            }
        }
    }

    private boolean doesTaskHavePreRequistes() {
        return this.threadIdToRunOn != -1L;
    }

    protected void invokeTestMethods(ITestNGMethod iTestNGMethod, Object object) {
        List<ITestResult> list = this.m_testInvoker.invokeTestMethods(iTestNGMethod, this.m_groupMethods, object, this.m_testContext);
        if (list != null) {
            this.m_testResults.addAll(list);
        }
    }

    private boolean canInvokeBeforeClassMethods() {
        return this.m_classMethodMap != null;
    }

    protected void invokeBeforeClassMethods(ITestClass iTestClass2, IMethodInstance iMethodInstance) {
        Object object;
        Map<ITestClass, Set<Object>> map = this.m_classMethodMap.getInvokedBeforeClassMethods();
        Set set = map.computeIfAbsent(iTestClass2, iTestClass -> Sets.newHashSet());
        if (!set.contains(object = iMethodInstance.getInstance())) {
            set.add(object);
            for (IClassListener iClassListener : this.m_listeners) {
                iClassListener.onBeforeClass(iTestClass2);
            }
            ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().forTestClass(iTestClass2).usingConfigMethodsAs(iTestClass2.getBeforeClassMethods()).forSuite(this.m_testContext.getSuite().getXmlSuite()).usingParameters(this.m_parameters).usingInstance(object).build();
            this.m_configInvoker.invokeConfigurations(configMethodArguments);
        }
    }

    protected void invokeAfterClassMethods(ITestClass iTestClass2, IMethodInstance iMethodInstance) {
        Object object;
        if (this.m_classMethodMap == null) {
            return;
        }
        List list = Lists.newArrayList();
        ITestNGMethod iTestNGMethod = iMethodInstance.getMethod();
        boolean bl = this.m_classMethodMap.removeAndCheckIfLast(iTestNGMethod, iMethodInstance.getInstance());
        if (!bl) {
            return;
        }
        Map<ITestClass, Set<Object>> map = this.m_classMethodMap.getInvokedAfterClassMethods();
        Set set = map.computeIfAbsent(iTestClass2, iTestClass -> Sets.newHashSet());
        if (!set.contains(object = iMethodInstance.getInstance())) {
            list.add(object);
        }
        for (IClassListener iClassListener : this.m_listeners) {
            iClassListener.onAfterClass(iTestClass2);
        }
        for (IClassListener iClassListener : list) {
            ConfigMethodArguments configMethodArguments = new ConfigMethodArguments.Builder().forTestClass(iTestClass2).usingConfigMethodsAs(iTestClass2.getAfterClassMethods()).forSuite(this.m_testContext.getSuite().getXmlSuite()).usingParameters(this.m_parameters).usingInstance(iClassListener).build();
            this.m_configInvoker.invokeConfigurations(configMethodArguments);
        }
    }

    protected int indexOf(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        for (int i = 0; i < iTestNGMethodArray.length; ++i) {
            if (iTestNGMethodArray[i] != iTestNGMethod) continue;
            return i;
        }
        return -1;
    }

    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    @Override
    public List<ITestNGMethod> getTasks() {
        List list = Lists.newArrayList();
        for (IMethodInstance iMethodInstance : this.m_methodInstances) {
            list.add(iMethodInstance.getMethod());
        }
        return list;
    }

    @Override
    public int compareTo(@Nonnull IWorker<ITestNGMethod> iWorker) {
        if (this.m_methodInstances.isEmpty()) {
            return 0;
        }
        List<ITestNGMethod> list = iWorker.getTasks();
        if (list.isEmpty()) {
            return 0;
        }
        return TestMethodComparator.compareStatic(this.m_methodInstances.get(0).getMethod(), list.get(0));
    }

    @Override
    public int getPriority() {
        return this.m_methodInstances.size() > 0 ? this.m_methodInstances.get(0).getMethod().getPriority() : 0;
    }

    @Override
    public long getCurrentThreadId() {
        return this.currentThreadId;
    }

    @Override
    public void setThreadIdToRunOn(long l) {
        this.threadIdToRunOn = l;
    }

    @Override
    public boolean completed() {
        return this.completed;
    }
}

