/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IDataProviderListener;
import org.testng.IInstanceInfo;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.FactoryMethod;
import org.testng.internal.IConfiguration;
import org.testng.internal.IParameterInfo;
import org.testng.internal.ObjectFactoryImpl;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;

public class TestNGClassFinder
extends BaseClassFinder {
    private static final String PREFIX = "[TestNGClassFinder]";
    private final ITestContext m_testContext;
    private final Map<Class<?>, List<Object>> m_instanceMap = Maps.newHashMap();
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> m_dataProviderListeners;
    private final ITestObjectFactory objectFactory;
    private final IAnnotationFinder annotationFinder;
    private String m_factoryCreationFailedMessage = null;

    public String getFactoryCreationFailedMessage() {
        return this.m_factoryCreationFailedMessage;
    }

    public TestNGClassFinder(ClassInfoMap classInfoMap, Map<Class<?>, List<Object>> map, IConfiguration iConfiguration, ITestContext iTestContext, Map<Class<? extends IDataProviderListener>, IDataProviderListener> map2) {
        if (map == null) {
            throw new IllegalArgumentException("instanceMap must not be null");
        }
        this.m_testContext = iTestContext;
        this.m_dataProviderListeners = map2;
        this.annotationFinder = iConfiguration.getAnnotationFinder();
        Set<Class<?>> set = classInfoMap.getClasses();
        this.objectFactory = iConfiguration.getObjectFactory() == null ? this.createObjectFactory(set) : iConfiguration.getObjectFactory();
        for (Class<?> object : set) {
            this.processClass(classInfoMap, map, iConfiguration, object);
        }
        for (Map.Entry entry : this.m_instanceMap.entrySet()) {
            Class clazz = (Class)entry.getKey();
            for (Object e : (List)entry.getValue()) {
                IClass iClass = this.getIClass(clazz);
                if (null == iClass) continue;
                iClass.addInstance(e);
            }
        }
    }

    private void processClass(ClassInfoMap classInfoMap, Map<Class<?>, List<Object>> map, IConfiguration iConfiguration, Class<?> clazz) {
        Object object;
        if (null == clazz) {
            Utils.log(PREFIX, 5, "[WARN] FOUND NULL CLASS");
            return;
        }
        if (TestNGClassFinder.isNotTestNGClass(clazz, this.annotationFinder)) {
            Utils.log(PREFIX, 3, "SKIPPING CLASS " + clazz + " no TestNG annotations found");
            return;
        }
        List<Object> list = map.get(clazz);
        Object object2 = object = list != null && !list.isEmpty() ? list.get(0) : null;
        if (null == object && Modifier.isAbstract(clazz.getModifiers())) {
            Utils.log("", 5, "[WARN] Found an abstract class with no valid instance attached: " + clazz);
            return;
        }
        if (null == object && clazz.isAnonymousClass()) {
            Utils.log("", 5, "[WARN] Found an anonymous class with no valid instance attached" + clazz);
            return;
        }
        IClass iClass = this.findOrCreateIClass(this.m_testContext, clazz, classInfoMap.getXmlClass(clazz), object, this.annotationFinder, this.objectFactory);
        if (iClass == null) {
            return;
        }
        this.putIClass(clazz, iClass);
        List<ConstructorOrMethod> list2 = ClassHelper.findDeclaredFactoryMethods(clazz, this.annotationFinder);
        for (ConstructorOrMethod constructorOrMethod : list2) {
            this.processMethod(iConfiguration, iClass, constructorOrMethod);
        }
    }

    private void processMethod(IConfiguration iConfiguration, IClass iClass, ConstructorOrMethod constructorOrMethod) {
        if (!constructorOrMethod.getEnabled()) {
            return;
        }
        ClassInfoMap classInfoMap = this.processFactory(iClass, constructorOrMethod);
        if (classInfoMap.isEmpty()) {
            return;
        }
        TestNGClassFinder testNGClassFinder = new TestNGClassFinder(classInfoMap, this.m_instanceMap, iConfiguration, this.m_testContext, Collections.emptyMap());
        for (IClass iClass2 : testNGClassFinder.findTestClasses()) {
            this.putIClass(iClass2.getRealClass(), iClass2);
        }
    }

    private static boolean excludeFactory(FactoryMethod factoryMethod, ITestContext iTestContext) {
        return factoryMethod.getGroups().length != 0 && iTestContext.getCurrentXmlTest().getExcludedGroups().containsAll(Arrays.asList(factoryMethod.getGroups()));
    }

    private ClassInfoMap processFactory(IClass iClass, ConstructorOrMethod constructorOrMethod) {
        Object[] objectArray = iClass.getInstances(false);
        Object object = objectArray.length != 0 ? objectArray[0] : null;
        FactoryMethod factoryMethod = new FactoryMethod(constructorOrMethod, object, this.annotationFinder, this.m_testContext, this.objectFactory, this.m_dataProviderListeners);
        ClassInfoMap classInfoMap = new ClassInfoMap();
        if (TestNGClassFinder.excludeFactory(factoryMethod, this.m_testContext)) {
            return classInfoMap;
        }
        int n = 0;
        for (IParameterInfo iParameterInfo : factoryMethod.invoke()) {
            Class<Object> clazz;
            if (iParameterInfo == null) {
                throw new TestNGException("The factory " + factoryMethod + " returned a null instanceat index " + n);
            }
            Object object2 = IParameterInfo.embeddedInstance(iParameterInfo);
            if (IInstanceInfo.class.isAssignableFrom(object2.getClass())) {
                IInstanceInfo iInstanceInfo = (IInstanceInfo)object2;
                this.addInstance(iInstanceInfo);
                clazz = iInstanceInfo.getInstanceClass();
            } else {
                this.addInstance(iParameterInfo);
                clazz = object2.getClass();
            }
            if (!this.classExists(clazz)) {
                classInfoMap.addClass(clazz);
            }
            ++n;
        }
        this.m_factoryCreationFailedMessage = factoryMethod.getFactoryCreationFailedMessage();
        return classInfoMap;
    }

    private ITestObjectFactory createObjectFactory(Set<Class<?>> set) {
        ITestObjectFactory iTestObjectFactory = new ObjectFactoryImpl();
        for (Class<?> clazz : set) {
            try {
                Method[] methodArray;
                if (clazz == null) continue;
                try {
                    methodArray = clazz.getMethods();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Utils.log(PREFIX, 5, "[WARN] Can't link and determine methods of " + clazz + "(" + noClassDefFoundError.getMessage() + ")");
                    methodArray = new Method[]{};
                }
                for (Method method : methodArray) {
                    IObjectFactoryAnnotation iObjectFactoryAnnotation = this.annotationFinder.findAnnotation(method, IObjectFactoryAnnotation.class);
                    if (iObjectFactoryAnnotation == null) continue;
                    if (!ITestObjectFactory.class.isAssignableFrom(method.getReturnType())) {
                        throw new TestNGException("Return type of " + method + " is not IObjectFactory");
                    }
                    try {
                        Object obj = clazz.newInstance();
                        iTestObjectFactory = method.getParameterTypes().length > 0 && method.getParameterTypes()[0].equals(ITestContext.class) ? (ITestObjectFactory)method.invoke(obj, this.m_testContext) : (ITestObjectFactory)method.invoke(obj, new Object[0]);
                        return iTestObjectFactory;
                    }
                    catch (Exception exception) {
                        throw new TestNGException("Error creating object factory: " + clazz, exception);
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Utils.log(PREFIX, 1, "Unable to read methods on class " + clazz.getName() + " - unable to resolve class reference " + noClassDefFoundError.getMessage());
                for (XmlClass xmlClass : this.m_testContext.getCurrentXmlTest().getXmlClasses()) {
                    if (!xmlClass.loadClasses() || !xmlClass.getName().equals(clazz.getName())) continue;
                    throw noClassDefFoundError;
                }
            }
        }
        return iTestObjectFactory;
    }

    private static boolean isNotTestNGClass(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        return !TestNGClassFinder.isTestNGClass(clazz, iAnnotationFinder);
    }

    private static boolean isTestNGClass(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        Class<?> clazz2 = clazz;
        try {
            for (Class clazz3 : AnnotationHelper.getAllAnnotations()) {
                for (clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    for (Method method : ClassHelper.getAvailableMethods(clazz2)) {
                        Object a = iAnnotationFinder.findAnnotation(clazz2, method, clazz3);
                        if (null == a) continue;
                        return true;
                    }
                    Iterator<Method> iterator = iAnnotationFinder.findAnnotation(clazz2, clazz3);
                    if (null != iterator) {
                        return true;
                    }
                    for (Constructor<?> constructor : clazz2.getConstructors()) {
                        Object a = iAnnotationFinder.findAnnotation(constructor, clazz3);
                        if (null == a) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Utils.log(PREFIX, 1, "Unable to read methods on class " + clazz2.getName() + " - unable to resolve class reference " + noClassDefFoundError.getMessage());
            return false;
        }
    }

    private <T> void addInstance(IInstanceInfo<T> iInstanceInfo) {
        this.addInstance(iInstanceInfo.getInstanceClass(), iInstanceInfo.getInstance());
    }

    private void addInstance(Object object) {
        this.addInstance(IParameterInfo.embeddedInstance(object).getClass(), object);
    }

    private <T, S extends T> void addInstance(Class<S> clazz2, T t) {
        List list = this.m_instanceMap.computeIfAbsent(clazz2, clazz -> Lists.newArrayList());
        list.add(t);
    }
}

