/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.testng.IDataProviderMethod;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.CustomAttribute;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.InstanceCreator;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

public class TestNGMethod
extends BaseTestMethod {
    private int m_threadPoolSize = 0;
    private int m_invocationCount = 1;
    private int m_successPercentage = 100;
    private boolean isDataDriven = false;
    private CustomAttribute[] m_attributes = new CustomAttribute[0];
    private IDataProviderMethod dataProviderMethod = null;

    public TestNGMethod(Method method, IAnnotationFinder iAnnotationFinder, XmlTest xmlTest, Object object) {
        this(method, iAnnotationFinder, true, xmlTest, object);
    }

    private TestNGMethod(Method method, IAnnotationFinder iAnnotationFinder, boolean bl, XmlTest xmlTest, Object object) {
        super(method.getName(), new ConstructorOrMethod(method), iAnnotationFinder, object);
        this.setXmlTest(xmlTest);
        if (bl) {
            this.init(xmlTest);
        }
    }

    @Override
    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    @Override
    public int getSuccessPercentage() {
        return this.m_successPercentage;
    }

    @Override
    public boolean isTest() {
        return true;
    }

    private void init(XmlTest xmlTest) {
        this.setXmlTest(xmlTest);
        String string = this.m_method.getDeclaringClass().getName();
        Object object = this.getInstance();
        if (object != null) {
            string = object.getClass().getName();
        }
        this.setInvocationNumbers(xmlTest.getInvocationNumbers(string + "." + this.m_method.getName()));
        ITestAnnotation iTestAnnotation = AnnotationHelper.findTest((IAnnotationFinder)this.getAnnotationFinder(), (Method)this.m_method.getMethod());
        if (iTestAnnotation == null) {
            iTestAnnotation = AnnotationHelper.findTest((IAnnotationFinder)this.getAnnotationFinder(), this.m_method.getDeclaringClass());
        }
        if (null != iTestAnnotation) {
            this.setTimeOut(iTestAnnotation.getTimeOut());
            this.m_successPercentage = iTestAnnotation.getSuccessPercentage();
            this.isDataDriven = TestNGMethod.doesTestAnnotationHaveADataProvider(iTestAnnotation);
            this.setInvocationCount(iTestAnnotation.getInvocationCount());
            this.setThreadPoolSize(iTestAnnotation.getThreadPoolSize());
            this.setAlwaysRun(iTestAnnotation.getAlwaysRun());
            this.setDescription(this.findDescription(iTestAnnotation, xmlTest));
            this.setEnabled(iTestAnnotation.getEnabled());
            this.setRetryAnalyzer(TestNGMethod.cloneInstance(iTestAnnotation.getRetryAnalyzer()));
            this.setRetryAnalyzerClass(iTestAnnotation.getRetryAnalyzerClass());
            this.setSkipFailedInvocations(iTestAnnotation.skipFailedInvocations());
            this.setInvocationTimeOut(iTestAnnotation.invocationTimeOut());
            this.setIgnoreMissingDependencies(iTestAnnotation.ignoreMissingDependencies());
            this.setPriority(iTestAnnotation.getPriority());
            this.m_attributes = iTestAnnotation.getAttributes();
        }
        this.initGroups(ITestAnnotation.class);
    }

    private static boolean doesTestAnnotationHaveADataProvider(ITestAnnotation iTestAnnotation) {
        return !iTestAnnotation.getDataProvider().trim().isEmpty() || iTestAnnotation.getDataProviderClass() != null;
    }

    private String findDescription(ITestAnnotation iTestAnnotation, XmlTest xmlTest) {
        String string = iTestAnnotation.getDescription();
        if (string != null) {
            return string;
        }
        List<XmlClass> list = xmlTest.getXmlClasses();
        return list.stream().filter(this::classNameMatcher).flatMap(xmlClass -> xmlClass.getIncludedMethods().stream()).filter(this::methodNameMatcher).map(XmlInclude::getDescription).filter(Objects::nonNull).findFirst().orElse("");
    }

    private boolean classNameMatcher(XmlClass xmlClass) {
        return xmlClass.getName().equals(this.m_method.getMethod().getDeclaringClass().getName());
    }

    private boolean methodNameMatcher(XmlInclude xmlInclude) {
        return xmlInclude.getName().equals(this.m_method.getName());
    }

    @Override
    public int getThreadPoolSize() {
        return this.m_threadPoolSize;
    }

    @Override
    public void setThreadPoolSize(int n) {
        this.m_threadPoolSize = n;
    }

    @Override
    public void setInvocationCount(int n) {
        this.m_invocationCount = n;
    }

    @Override
    public BaseTestMethod clone() {
        TestNGMethod testNGMethod = new TestNGMethod(this.getConstructorOrMethod().getMethod(), this.getAnnotationFinder(), false, this.getXmlTest(), this.getInstance());
        ITestClass iTestClass = this.getTestClass();
        NoOpTestClass noOpTestClass = new NoOpTestClass(iTestClass);
        noOpTestClass.setBeforeTestMethods(TestNGMethod.clone(iTestClass.getBeforeTestMethods()));
        noOpTestClass.setAfterTestMethod(TestNGMethod.clone(iTestClass.getAfterTestMethods()));
        testNGMethod.m_testClass = noOpTestClass;
        testNGMethod.setDate(this.getDate());
        testNGMethod.setGroups(this.getGroups());
        testNGMethod.setGroupsDependedUpon(this.getGroupsDependedUpon(), Collections.emptyList());
        testNGMethod.setMethodsDependedUpon(this.getMethodsDependedUpon());
        testNGMethod.setAlwaysRun(this.isAlwaysRun());
        testNGMethod.m_beforeGroups = this.getBeforeGroups();
        testNGMethod.m_afterGroups = this.getAfterGroups();
        testNGMethod.m_currentInvocationCount = this.m_currentInvocationCount;
        testNGMethod.setMissingGroup(this.getMissingGroup());
        testNGMethod.setThreadPoolSize(this.getThreadPoolSize());
        testNGMethod.setDescription(this.getDescription());
        testNGMethod.setEnabled(this.getEnabled());
        testNGMethod.setParameterInvocationCount(this.getParameterInvocationCount());
        testNGMethod.setInvocationCount(this.getInvocationCount());
        testNGMethod.m_successPercentage = this.getSuccessPercentage();
        testNGMethod.setTimeOut(this.getTimeOut());
        testNGMethod.setRetryAnalyzer(this.getRetryAnalyzer());
        testNGMethod.setRetryAnalyzerClass(this.getRetryAnalyzerClass());
        testNGMethod.setSkipFailedInvocations(this.skipFailedInvocations());
        testNGMethod.setInvocationNumbers(this.getInvocationNumbers());
        testNGMethod.setPriority(this.getPriority());
        return testNGMethod;
    }

    private static ITestNGMethod[] clone(ITestNGMethod[] iTestNGMethodArray) {
        return (ITestNGMethod[])Arrays.stream(iTestNGMethodArray).map(ITestNGMethod::clone).toArray(ITestNGMethod[]::new);
    }

    private static IRetryAnalyzer cloneInstance(IRetryAnalyzer iRetryAnalyzer) {
        if (iRetryAnalyzer == null) {
            return null;
        }
        return (IRetryAnalyzer)InstanceCreator.newInstance(iRetryAnalyzer.getClass());
    }

    @Override
    public boolean isDataDriven() {
        return this.isDataDriven;
    }

    @Override
    public CustomAttribute[] getAttributes() {
        return this.m_attributes;
    }

    @Override
    public IDataProviderMethod getDataProviderMethod() {
        return this.dataProviderMethod;
    }

    public void setDataProviderMethod(IDataProviderMethod iDataProviderMethod) {
        this.dataProviderMethod = iDataProviderMethod;
    }
}

