/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import org.testng.IClass;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.Utils;

class TestNgMethodUtils {
    private TestNgMethodUtils() {
    }

    static boolean isConfigurationMethod(ITestNGMethod iTestNGMethod) {
        return TestNgMethodUtils.isConfigurationMethod(iTestNGMethod, false);
    }

    private static boolean isConfigurationMethod(ITestNGMethod iTestNGMethod, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = iTestNGMethod.isBeforeMethodConfiguration() || iTestNGMethod.isAfterMethodConfiguration() || iTestNGMethod.isBeforeTestConfiguration() || iTestNGMethod.isAfterTestConfiguration() || iTestNGMethod.isBeforeClassConfiguration() || iTestNGMethod.isAfterClassConfiguration() || iTestNGMethod.isBeforeSuiteConfiguration() || iTestNGMethod.isAfterSuiteConfiguration();
        if (bl) {
            bl2 = bl2 || iTestNGMethod.isBeforeGroupsConfiguration() || iTestNGMethod.isAfterGroupsConfiguration();
        }
        return bl2;
    }

    private static boolean containsConfigurationMethod(ITestNGMethod iTestNGMethod, List<ITestNGMethod> list) {
        return TestNgMethodUtils.isConfigurationMethod(iTestNGMethod, true) && list.contains(iTestNGMethod);
    }

    static ITestNGMethod[] filterBeforeTestMethods(ITestClass iTestClass, BiPredicate<ITestNGMethod, IClass> biPredicate) {
        return TestNgMethodUtils.filterMethods(iTestClass, iTestClass.getBeforeTestMethods(), biPredicate);
    }

    static ITestNGMethod[] filterAfterTestMethods(ITestClass iTestClass, BiPredicate<ITestNGMethod, IClass> biPredicate) {
        return TestNgMethodUtils.filterMethods(iTestClass, iTestClass.getAfterTestMethods(), biPredicate);
    }

    static ITestNGMethod[] filterMethods(IClass iClass, ITestNGMethod[] iTestNGMethodArray, BiPredicate<ITestNGMethod, IClass> biPredicate) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            String string;
            if (biPredicate.test(iTestNGMethod, iClass) && !TestNgMethodUtils.containsConfigurationMethod(iTestNGMethod, list)) {
                string = "Keeping method " + iTestNGMethod + " for class " + iClass;
                list.add(iTestNGMethod);
            } else {
                string = "Filtering out method " + iTestNGMethod + " for class " + iClass;
            }
            Utils.log("Invoker " + Thread.currentThread().hashCode(), 10, string);
        }
        return list.toArray(new ITestNGMethod[0]);
    }

    static ITestNGMethod[] filterSetupConfigurationMethods(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
            ConfigurationMethod configurationMethod = (ConfigurationMethod)iTestNGMethod2;
            if (!TestNgMethodUtils.doesSetupMethodPassFirstTimeFilter(configurationMethod, iTestNGMethod) || !TestNgMethodUtils.doesConfigMethodPassGroupFilters(configurationMethod, iTestNGMethod)) continue;
            list.add(iTestNGMethod2);
        }
        return list.toArray(new ITestNGMethod[0]);
    }

    static ITestNGMethod[] filterTeardownConfigurationMethods(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray) {
            ConfigurationMethod configurationMethod = (ConfigurationMethod)iTestNGMethod2;
            if (!TestNgMethodUtils.doesTeardownMethodPassLastTimeFilter(configurationMethod, iTestNGMethod) || !TestNgMethodUtils.doesConfigMethodPassGroupFilters(configurationMethod, iTestNGMethod)) continue;
            list.add(iTestNGMethod2);
        }
        return list.toArray(new ITestNGMethod[0]);
    }

    static boolean cannotRunMethodIndependently(ITestNGMethod iTestNGMethod) {
        String[] stringArray = iTestNGMethod.getMethodsDependedUpon();
        return null != stringArray && stringArray.length > 0;
    }

    static Object getMethodInvocationToken(ITestNGMethod iTestNGMethod, Object object) {
        return String.format("%s+%d+%d", object.toString(), iTestNGMethod.getCurrentInvocationCount(), iTestNGMethod.getParameterInvocationCount());
    }

    private static boolean doesSetupMethodPassFirstTimeFilter(ConfigurationMethod configurationMethod, ITestNGMethod iTestNGMethod) {
        return !configurationMethod.isFirstTimeOnly() || configurationMethod.isFirstTimeOnly() && iTestNGMethod.getCurrentInvocationCount() == 0;
    }

    private static boolean doesTeardownMethodPassLastTimeFilter(ConfigurationMethod configurationMethod, ITestNGMethod iTestNGMethod) {
        return !configurationMethod.isLastTimeOnly() || configurationMethod.isLastTimeOnly() && !iTestNGMethod.hasMoreInvocation();
    }

    private static boolean doesConfigMethodPassGroupFilters(ConfigurationMethod configurationMethod, ITestNGMethod iTestNGMethod) {
        Object[] objectArray = configurationMethod.getGroupFilters();
        if (objectArray.length == 0) {
            return true;
        }
        Object[] objectArray2 = iTestNGMethod.getGroups();
        if (objectArray2.length == 0) {
            return false;
        }
        return !Collections.disjoint(Sets.newHashSet((Object[])objectArray2), Sets.newHashSet((Object[])objectArray));
    }
}

