/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.Attributes;
import org.testng.internal.IParameterInfo;

public class TestResult
implements ITestResult {
    private ITestNGMethod m_method = null;
    private List<ITestNGMethod> skippedDueTo = Lists.newArrayList();
    private boolean skipAnalysed = false;
    private int m_status = -1;
    private Throwable m_throwable = null;
    private long m_startMillis = 0L;
    private long m_endMillis = 0L;
    private String m_name = null;
    private String m_host;
    private Object[] m_parameters = new Object[0];
    private String m_instanceName;
    private ITestContext m_context;
    private int parameterIndex;
    private boolean m_wasRetried;
    private final IAttributes m_attributes = new Attributes();

    private TestResult() {
    }

    public static TestResult newEmptyTestResult() {
        return new TestResult();
    }

    public static TestResult newTestResultFor(ITestNGMethod iTestNGMethod) {
        return TestResult.newContextAwareTestResult(iTestNGMethod, null);
    }

    public static TestResult newContextAwareTestResult(ITestNGMethod iTestNGMethod, ITestContext iTestContext) {
        TestResult testResult = TestResult.newEmptyTestResult();
        long l = System.currentTimeMillis();
        testResult.init(iTestNGMethod, iTestContext, null, l, 0L);
        return testResult;
    }

    public static TestResult newTestResultWithCauseAs(ITestNGMethod iTestNGMethod, ITestContext iTestContext, Throwable throwable) {
        TestResult testResult = TestResult.newEmptyTestResult();
        long l = System.currentTimeMillis();
        testResult.init(iTestNGMethod, iTestContext, throwable, l, l);
        return testResult;
    }

    public static TestResult newEndTimeAwareTestResult(ITestNGMethod iTestNGMethod, ITestContext iTestContext, Throwable throwable, long l) {
        TestResult testResult = TestResult.newEmptyTestResult();
        long l2 = System.currentTimeMillis();
        testResult.init(iTestNGMethod, iTestContext, throwable, l, l2);
        return testResult;
    }

    public static TestResult newTestResultFrom(TestResult testResult, ITestNGMethod iTestNGMethod, ITestContext iTestContext, long l) {
        TestResult testResult2 = TestResult.newEmptyTestResult();
        testResult2.setHost(testResult.getHost());
        testResult2.setParameters(testResult.getParameters());
        testResult2.init(iTestNGMethod, iTestContext, null, l, 0L);
        TestResult.copyAttributes(testResult, testResult2);
        return testResult2;
    }

    private void init(ITestNGMethod iTestNGMethod, ITestContext iTestContext, Throwable throwable, long l, long l2) {
        this.m_throwable = throwable;
        this.m_instanceName = iTestNGMethod.getTestClass().getName();
        if (null == this.m_throwable) {
            this.m_status = 1;
        }
        this.m_startMillis = l;
        this.m_endMillis = l2;
        this.m_method = iTestNGMethod;
        this.m_context = iTestContext;
        Object object = iTestNGMethod.getInstance();
        if (object == null) {
            this.m_name = this.m_method.getMethodName();
            return;
        }
        if (object instanceof ITest) {
            this.m_name = ((ITest)object).getTestName();
            if (this.m_name != null) {
                return;
            }
            this.m_name = this.m_method.getMethodName();
            if (TestRunner.getVerbose() > 1) {
                String string = String.format("Warning: [%s] implementation on class [%s] returned null. Defaulting to method name", ITest.class.getName(), object.getClass().getName());
                System.err.println(string);
            }
            return;
        }
        if (iTestNGMethod.getTestClass().getTestName() != null) {
            this.m_name = iTestNGMethod.getTestClass().getTestName();
            return;
        }
        String string = object.toString();
        this.m_name = this.getMethod().getMethodName();
        try {
            if (!Object.class.getMethod("toString", new Class[0]).equals(object.getClass().getMethod("toString", new Class[0]))) {
                this.m_instanceName = string.startsWith("class ") ? string.substring("class ".length()) : string;
                this.m_name = this.m_name + " on " + this.m_instanceName;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public void setEndMillis(long l) {
        this.m_endMillis = l;
    }

    @Override
    public String getTestName() {
        if (this.m_method == null) {
            return null;
        }
        Object object = this.m_method.getInstance();
        if (object instanceof ITest) {
            return ((ITest)object).getTestName();
        }
        if (this.m_method.getTestClass().getTestName() != null) {
            return this.m_method.getTestClass().getTestName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public ITestNGMethod getMethod() {
        return this.m_method;
    }

    public void setMethod(ITestNGMethod iTestNGMethod) {
        this.m_method = iTestNGMethod;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int n) {
        this.m_status = n;
    }

    @Override
    public boolean isSuccess() {
        return 1 == this.m_status;
    }

    @Override
    public IClass getTestClass() {
        return this.m_method.getTestClass();
    }

    @Override
    public Throwable getThrowable() {
        return this.m_throwable;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.m_throwable = throwable;
    }

    @Override
    public long getEndMillis() {
        return this.m_endMillis;
    }

    @Override
    public long getStartMillis() {
        return this.m_startMillis;
    }

    public String toString() {
        List list = Reporter.getOutput((ITestResult)this);
        return Objects.toStringHelper(this.getClass()).omitNulls().omitEmptyStrings().add("name", this.getName()).add("status", TestResult.toString(this.m_status)).add("method", (Object)this.m_method).add("output", list != null && list.size() > 0 ? (String)list.get(0) : null).toString();
    }

    private static String toString(int n) {
        switch (n) {
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "FAILURE";
            }
            case 3: {
                return "SKIP";
            }
            case 4: {
                return "SUCCESS WITHIN PERCENTAGE";
            }
            case 16: {
                return "STARTED";
            }
            case -1: {
                return "CREATED";
            }
        }
        throw new TestNGException("Encountered an un-defined test status of [" + n + "].");
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    public void setHost(String string) {
        this.m_host = string;
    }

    @Override
    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public void setParameters(Object[] objectArray) {
        this.m_parameters = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Cloneable) {
                try {
                    Method method = objectArray[i].getClass().getDeclaredMethod("clone", new Class[0]);
                    this.m_parameters[i] = method.invoke(objectArray[i], new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    this.m_parameters[i] = objectArray[i];
                }
                continue;
            }
            this.m_parameters[i] = objectArray[i];
        }
    }

    @Override
    public Object getInstance() {
        return IParameterInfo.embeddedInstance(this.m_method.getInstance());
    }

    @Override
    public Object[] getFactoryParameters() {
        IParameterInfo iParameterInfo = this.m_method.getFactoryMethodParamsInfo();
        if (iParameterInfo != null) {
            return iParameterInfo.getParameters();
        }
        return new Object[0];
    }

    @Override
    public Object getAttribute(String string) {
        return this.m_attributes.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.m_attributes.setAttribute(string, object);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String string) {
        return this.m_attributes.removeAttribute(string);
    }

    @Override
    public ITestContext getTestContext() {
        return this.m_context;
    }

    public void setContext(ITestContext iTestContext) {
        this.m_context = iTestContext;
    }

    @Override
    public int compareTo(@Nonnull ITestResult iTestResult) {
        return Long.compare(this.getStartMillis(), iTestResult.getStartMillis());
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    @Override
    public void setTestName(String string) {
        this.m_name = string;
    }

    void setParameterIndex(int n) {
        this.parameterIndex = n;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public boolean wasRetried() {
        return this.m_wasRetried;
    }

    @Override
    public void setWasRetried(boolean bl) {
        this.m_wasRetried = bl;
    }

    @Override
    public List<ITestNGMethod> getSkipCausedBy() {
        List<String> list;
        if (this.m_status != 3 || this.skipAnalysed) {
            return Collections.unmodifiableList(this.skippedDueTo);
        }
        this.skipAnalysed = true;
        Set<ITestResult> set = this.m_context.getFailedConfigurations().getAllResults();
        for (ITestResult object2 : set) {
            if (TestResult.isGlobalFailure(object2) || this.isRelated(object2)) {
                this.skippedDueTo.add(object2.getMethod());
            }
            if (!this.belongToSameGroup(object2)) continue;
            this.skippedDueTo.add(object2.getMethod());
        }
        if (!this.skippedDueTo.isEmpty()) {
            return Collections.unmodifiableList(this.skippedDueTo);
        }
        if (this.m_method.getMethodsDependedUpon().length == 0) {
            if (this.m_method.getGroupsDependedUpon().length == 0) {
                return Collections.emptyList();
            }
            list = Arrays.asList(this.m_method.getGroupsDependedUpon());
            List list2 = Lists.merge(this.m_context.getFailedTests().getAllResults(), this.m_context.getFailedButWithinSuccessPercentageTests().getAllResults());
            this.skippedDueTo = list2.stream().map(ITestResult::getMethod).filter(iTestNGMethod -> {
                List<String> list2 = Arrays.asList(iTestNGMethod.getGroups());
                List list3 = Lists.intersection((List)list, list2);
                return !list3.isEmpty();
            }).collect(Collectors.toList());
            return Collections.unmodifiableList(this.skippedDueTo);
        }
        list = Arrays.asList(this.m_method.getMethodsDependedUpon());
        List list3 = Lists.merge(this.m_context.getFailedTests().getAllResults(), this.m_context.getFailedButWithinSuccessPercentageTests().getAllResults());
        this.skippedDueTo = list3.stream().map(ITestResult::getMethod).filter(iTestNGMethod -> list.contains(iTestNGMethod.getQualifiedName())).collect(Collectors.toList());
        return Collections.unmodifiableList(this.skippedDueTo);
    }

    private static boolean isGlobalFailure(ITestResult iTestResult) {
        ITestNGMethod iTestNGMethod = iTestResult.getMethod();
        return iTestNGMethod.isBeforeTestConfiguration() || iTestNGMethod.isBeforeSuiteConfiguration();
    }

    private boolean isRelated(ITestResult iTestResult) {
        ITestNGMethod iTestNGMethod = iTestResult.getMethod();
        if (!iTestNGMethod.isBeforeClassConfiguration() && !iTestNGMethod.isBeforeMethodConfiguration()) {
            return false;
        }
        Object object = this.getInstance();
        Object object2 = iTestResult.getInstance();
        return object.getClass().isAssignableFrom(object2.getClass()) || object2.getClass().isAssignableFrom(object.getClass());
    }

    private boolean belongToSameGroup(ITestResult iTestResult) {
        ITestNGMethod iTestNGMethod = iTestResult.getMethod();
        if (!iTestNGMethod.isBeforeGroupsConfiguration()) {
            return false;
        }
        String[] stringArray = this.m_method.getGroups();
        if (stringArray.length == 0 || iTestNGMethod.getGroups().length == 0) {
            return false;
        }
        List<String> list = Arrays.asList(iTestNGMethod.getGroups());
        return Arrays.stream(stringArray).anyMatch(list::contains);
    }

    static void copyAttributes(ITestResult iTestResult, ITestResult iTestResult2) {
        iTestResult.getAttributeNames().forEach(string -> iTestResult2.setAttribute((String)string, iTestResult.getAttribute((String)string)));
    }
}

