/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.internal.RuntimeBehavior;
import org.testng.log4testng.Logger;
import org.testng.reporters.XMLStringBuffer;

public final class Utils {
    private static final String LINE_SEP = RuntimeBehavior.getDefaultLineSeparator();
    private static final char[] SPECIAL_CHARACTERS = new char[]{'*', '/', '\\', '?', '%', ':', ';', '<', '>', '&', '~', '|'};
    public static final char CHAR_REPLACEMENT = '_';
    public static final char UNICODE_REPLACEMENT = '\ufffd';
    private static final String FORMAT = String.format("[%s]", Utils.class.getSimpleName());
    private static final Logger LOG = Logger.getLogger(Utils.class);
    private static final Map<Character, String> ESCAPES = new HashMap<Character, String>();

    private Utils() {
    }

    public static void writeUtf8File(@Nullable String string, String string2, XMLStringBuffer xMLStringBuffer, String string3) {
        try {
            File file;
            File file2;
            File file3 = file2 = string != null ? new File(string) : new File("").getAbsoluteFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (!(file = new File(file2, string2)).exists()) {
                file.createNewFile();
            }
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                if (string3 != null) {
                    outputStreamWriter.append(string3);
                }
                xMLStringBuffer.toWriter(outputStreamWriter);
            }
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage(), iOException);
        }
    }

    public static void writeUtf8File(@Nullable String string, String string2, String string3) {
        String string4 = string != null ? string : "";
        File file = new File(string4);
        Utils.writeFile(file, string2, Utils.escapeUnicode(string3), "UTF-8");
    }

    public static void writeFile(@Nullable String string, String string2, String string3) {
        String string4 = string != null ? string : "";
        File file = new File(string4);
        Utils.writeFile(file, string2, string3, null);
    }

    private static void writeFile(@Nullable File file, String string, String string2, @Nullable String string3) {
        File file2 = file;
        String string4 = string;
        try {
            if (file2 == null) {
                file2 = new File("").getAbsoluteFile();
            }
            if (!file2.exists()) {
                file2.mkdirs();
            }
            string4 = Utils.replaceSpecialCharacters(string4);
            File file3 = new File(file2, string4);
            file3.delete();
            Utils.log(FORMAT, 3, "Attempting to create " + file3);
            Utils.log(FORMAT, 3, "  Directory " + file2 + " exists: " + file2.exists());
            file3.createNewFile();
            Utils.writeFile(file3, string2, string3);
        }
        catch (IOException iOException) {
            if (TestRunner.getVerbose() > 1) {
                LOG.error(iOException.getMessage(), iOException);
            }
            Utils.log(FORMAT, 1, iOException.getMessage());
        }
    }

    private static void writeFile(File file, String string, @Nullable String string2) {
        try (BufferedWriter bufferedWriter = Utils.openWriter(file, string2);){
            bufferedWriter.write(string);
            Utils.log("", 3, "Creating " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            if (TestRunner.getVerbose() > 1) {
                LOG.error("ERROR WHILE WRITING TO " + file, iOException);
            }
            Utils.log(FORMAT, 1, "Error while writing to " + file + ": " + iOException.getMessage());
        }
    }

    public static BufferedWriter openWriter(@Nullable String string, String string2) throws IOException {
        String string3 = string2;
        String string4 = string != null ? string : "";
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
        }
        string3 = Utils.replaceSpecialCharacters(string3);
        File file2 = new File(file, string3);
        file2.delete();
        return Utils.openWriter(file2, null);
    }

    private static BufferedWriter openWriter(File file, @Nullable String string) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        OutputStreamWriter outputStreamWriter = null != string ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), string) : new OutputStreamWriter(new FileOutputStream(file));
        return new BufferedWriter(outputStreamWriter);
    }

    public static void log(String string) {
        Utils.log("Utils", 2, string);
    }

    public static void log(String string, int n, String string2) {
        if (TestRunner.getVerbose() >= n) {
            if (string.length() > 0) {
                LOG.info("[" + string + "] " + string2);
            } else {
                LOG.info(string2);
            }
        }
    }

    public static void error(String string) {
        LOG.error("[Error] " + string);
    }

    public static String[] split(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n = 0;
        int n2 = string.indexOf(string2, n);
        int n3 = string2.length();
        List list = Lists.newArrayList();
        while (n2 != -1) {
            list.add(string.substring(n, n2).trim());
            n = n2 + n3;
            n2 = string.indexOf(string2, n);
        }
        list.add(string.substring(n).trim());
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResourceToFile(File file, String string, Class<?> clazz) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream("/" + string);
        if (inputStream == null) {
            LOG.error("Couldn't find resource on the class path: " + string);
            return;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[4096];
            while (0 < (n = inputStream.read(byArray))) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static String defaultIfStringEmpty(String string, String string2) {
        return Utils.isStringEmpty(string) ? string2 : string;
    }

    public static boolean isStringBlank(String string) {
        return string == null || "".equals(string.trim());
    }

    public static boolean isStringEmpty(String string) {
        return string == null || "".equals(string);
    }

    public static boolean isStringNotBlank(String string) {
        return !Utils.isStringBlank(string);
    }

    public static boolean isStringNotEmpty(String string) {
        return !Utils.isStringEmpty(string);
    }

    public static String longStackTrace(Throwable throwable, boolean bl) {
        return Utils.buildStackTrace(throwable, bl, StackTraceType.FULL);
    }

    public static String shortStackTrace(Throwable throwable, boolean bl) {
        return Utils.buildStackTrace(throwable, bl, StackTraceType.SHORT);
    }

    private static String buildStackTrace(Throwable throwable, boolean bl, StackTraceType stackTraceType) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        String string = stringWriter.getBuffer().toString();
        if (stackTraceType == StackTraceType.SHORT && !Utils.isTooVerbose()) {
            string = Utils.filterTrace(stringWriter.getBuffer().toString());
        }
        if (bl) {
            string = Utils.escapeHtml(string);
        }
        return string;
    }

    private static boolean isTooVerbose() {
        return RuntimeBehavior.showTestNGStackFrames() || TestRunner.getVerbose() >= 2;
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = ESCAPES.get(Character.valueOf(c));
            if (string2 != null) {
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escapeUnicode(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = Character.isDefined(c) ? c : (char)'\ufffd';
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    static String filterTrace(String string) {
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                return "";
            }
            stringBuilder.append(string2).append(LINE_SEP);
            String[] stringArray = new String[]{"org.testng", "reflect", "org.gradle", "org.apache.maven.surefire"};
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                boolean bl = false;
                for (String string3 : stringArray) {
                    if (!string2.contains(string3)) continue;
                    bl = true;
                    ++n;
                    break;
                }
                if (bl) continue;
                stringBuilder.append(string2).append(LINE_SEP);
            }
            if (n > 0) {
                stringBuilder.append("... Removed ").append(n).append(" stack frames");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String toString(Object object, Class<?> clazz) {
        if (null == object) {
            return "null";
        }
        String string = object.toString();
        if (Utils.isStringEmpty(string)) {
            return "\"\"";
        }
        if (String.class.equals(clazz)) {
            return "\"" + string + '\"';
        }
        return string;
    }

    public static String detailedMethodName(ITestNGMethod iTestNGMethod, boolean bl) {
        String string = Utils.annotationFormFor(iTestNGMethod);
        if (!string.isEmpty()) {
            string = string + " ";
        }
        return string + (bl ? iTestNGMethod.toString() : iTestNGMethod.getMethodName());
    }

    public static String annotationFormFor(ITestNGMethod iTestNGMethod) {
        if (iTestNGMethod.isBeforeSuiteConfiguration()) {
            return "@BeforeSuite";
        }
        if (iTestNGMethod.isBeforeTestConfiguration()) {
            return "@BeforeTest";
        }
        if (iTestNGMethod.isBeforeClassConfiguration()) {
            return "@BeforeClass";
        }
        if (iTestNGMethod.isBeforeGroupsConfiguration()) {
            return "@BeforeGroups";
        }
        if (iTestNGMethod.isBeforeMethodConfiguration()) {
            return "@BeforeMethod";
        }
        if (iTestNGMethod.isAfterMethodConfiguration()) {
            return "@AfterMethod";
        }
        if (iTestNGMethod.isAfterGroupsConfiguration()) {
            return "@AfterGroups";
        }
        if (iTestNGMethod.isAfterClassConfiguration()) {
            return "@AfterClass";
        }
        if (iTestNGMethod.isAfterTestConfiguration()) {
            return "@AfterTest";
        }
        if (iTestNGMethod.isAfterSuiteConfiguration()) {
            return "@AfterSuite";
        }
        return "";
    }

    public static String arrayToString(String[] stringArray) {
        return String.join((CharSequence)", ", stringArray);
    }

    public static String replaceSpecialCharacters(String string) {
        String string2 = string;
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        for (char c : SPECIAL_CHARACTERS) {
            string2 = string2.replace(c, '_');
        }
        return string2;
    }

    public static <T> String join(List<T> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(list.get(i).toString());
        }
        return stringBuilder.toString();
    }

    public static void checkInstanceOrStatic(Object object, Method method) {
        if (object == null && method != null && !Modifier.isStatic(method.getModifiers())) {
            throw new TestNGException("Can't invoke " + method + ": either make it static or add a no-args constructor to your class");
        }
    }

    public static void checkReturnType(Method method, Class<?> ... classArray) {
        if (method == null) {
            return;
        }
        for (Class<?> clazz : classArray) {
            if (method.getReturnType() != clazz) continue;
            return;
        }
        throw new TestNGException(method.getDeclaringClass().getName() + "." + method.getName() + " MUST return " + Utils.toString(classArray) + " but returns " + method.getReturnType().getName());
    }

    private static String toString(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder("[ ");
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (clazz.isArray()) {
                stringBuilder.append(clazz.getComponentType().getName()).append("[]");
            } else {
                stringBuilder.append(clazz.getName());
            }
            if (i + 1 >= classArray.length) continue;
            stringBuilder.append(" or ");
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public static String toString(Object object) {
        String string = object != null ? (object instanceof boolean[] ? Arrays.toString((boolean[])object) : (object instanceof byte[] ? Arrays.toString((byte[])object) : (object instanceof char[] ? Arrays.toString((char[])object) : (object instanceof double[] ? Arrays.toString((double[])object) : (object instanceof float[] ? Arrays.toString((float[])object) : (object instanceof int[] ? Arrays.toString((int[])object) : (object instanceof long[] ? Arrays.toString((long[])object) : (object instanceof Object[] ? Arrays.deepToString((Object[])object) : (object instanceof short[] ? Arrays.toString((short[])object) : object.toString()))))))))) : "null";
        return string;
    }

    static {
        ESCAPES.put(Character.valueOf('<'), "&lt;");
        ESCAPES.put(Character.valueOf('>'), "&gt;");
        ESCAPES.put(Character.valueOf('\''), "&apos;");
        ESCAPES.put(Character.valueOf('\"'), "&quot;");
        ESCAPES.put(Character.valueOf('&'), "&amp;");
    }

    private static enum StackTraceType {
        SHORT,
        FULL;

    }
}

