/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.ScriptMethodSelector;
import org.testng.internal.ScriptSelectorFactory;
import org.testng.internal.Utils;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlScript;

public class XmlMethodSelector
implements IMethodSelector {
    private static final String QUOTED_DOLLAR = Matcher.quoteReplacement("\\$");
    private final ListMultiMap<String, XmlInclude> m_includedMethods = Maps.newListMultiMap();
    private final Map<String, String> m_logged = Maps.newHashMap();
    private Map<String, String> m_includedGroups = Maps.newHashMap();
    private Map<String, String> m_excludedGroups = Maps.newHashMap();
    private List<XmlClass> m_classes = Collections.emptyList();
    private ScriptMethodSelector scriptSelector;
    private boolean m_isInitialized = false;
    private List<ITestNGMethod> m_testMethods = Collections.emptyList();

    @Override
    public boolean includeMethod(IMethodSelectorContext iMethodSelectorContext, ITestNGMethod iTestNGMethod, boolean bl) {
        if (!this.m_isInitialized) {
            this.m_isInitialized = true;
            this.init(iMethodSelectorContext);
        }
        if (this.scriptSelector != null) {
            return this.scriptSelector.includeMethodFromExpression(iTestNGMethod);
        }
        return this.includeMethodFromIncludeExclude(iTestNGMethod, bl);
    }

    private boolean includeMethodFromIncludeExclude(ITestNGMethod iTestNGMethod, boolean bl) {
        String[] stringArray;
        boolean bl2 = false;
        ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
        Map<String, String> map = this.m_includedGroups;
        Map<String, String> map2 = this.m_excludedGroups;
        boolean bl3 = iTestNGMethod.getTestClass() != null;
        String string = bl3 ? XmlMethodSelector.makeMethodName(iTestNGMethod.getTestClass().getRealClass().getName(), constructorOrMethod.getName()) : MethodHelper.calculateMethodCanonicalName(iTestNGMethod);
        List list = (List)this.m_includedMethods.get(string);
        if (map.isEmpty() && map2.isEmpty() && !this.hasIncludedMethods() && !this.hasExcludedMethods()) {
            bl2 = true;
        } else if (map.isEmpty() && map2.isEmpty() && !bl) {
            bl2 = true;
        } else if (!list.isEmpty()) {
            bl2 = true;
        } else {
            boolean bl4 = false;
            stringArray = iTestNGMethod.getGroups();
            boolean bl5 = XmlMethodSelector.isIncluded(this.m_includedGroups.values(), bl4, stringArray);
            boolean bl6 = XmlMethodSelector.isExcluded(this.m_excludedGroups.values(), stringArray);
            if (bl5 && !bl6) {
                bl2 = true;
            } else if (bl6) {
                bl2 = false;
            }
            if (bl) {
                Class<?> clazz = constructorOrMethod.getDeclaringClass();
                String string2 = XmlMethodSelector.makeMethodName(clazz.getName(), constructorOrMethod.getName());
                bl4 = this.m_includedGroups.isEmpty() && this.m_excludedGroups.isEmpty();
                for (XmlClass xmlClass : this.m_classes) {
                    Class<?> clazz2 = xmlClass.getSupportClass();
                    if (!XmlMethodSelector.assignable(clazz, clazz2)) continue;
                    List<String> list2 = XmlMethodSelector.createQualifiedMethodNames(xmlClass, XmlMethodSelector.toStringList(xmlClass.getIncludedMethods()));
                    boolean bl7 = XmlMethodSelector.isIncluded(list2, bl4, string2);
                    List<String> list3 = XmlMethodSelector.createQualifiedMethodNames(xmlClass, xmlClass.getExcludedMethods());
                    boolean bl8 = XmlMethodSelector.isExcluded(list3, string2);
                    if (!bl2) continue;
                    if (!xmlClass.getIncludedMethods().isEmpty()) {
                        bl2 = bl7;
                    }
                    if (xmlClass.getExcludedMethods().isEmpty()) continue;
                    bl2 = bl2 && !bl8;
                }
            }
        }
        Package package_ = constructorOrMethod.getDeclaringClass().getPackage();
        stringArray = package_ != null ? package_.getName() + "." + constructorOrMethod.getName() : constructorOrMethod.getName();
        this.logInclusion(bl2 ? "Including" : "Excluding", "method", (String)stringArray + "()");
        return bl2;
    }

    private static boolean assignable(Class<?> clazz, Class<?> clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz);
    }

    private void logInclusion(String string, String string2, String string3) {
        if (!this.m_logged.containsKey(string3)) {
            XmlMethodSelector.log(string + " " + string2 + " " + string3);
            this.m_logged.put(string3, string3);
        }
    }

    private boolean hasIncludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getIncludedMethods().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getExcludedMethods().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static List<String> toStringList(List<XmlInclude> list) {
        List list2 = Lists.newArrayList();
        for (XmlInclude xmlInclude : list) {
            list2.add(xmlInclude.getName());
        }
        return list2;
    }

    private static List<String> createQualifiedMethodNames(XmlClass xmlClass, List<String> list) {
        List list2 = Lists.newArrayList();
        for (Class<?> clazz = xmlClass.getSupportClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (String string : list) {
                Method[] methodArray;
                Pattern pattern = Pattern.compile(XmlMethodSelector.methodName(string));
                for (Method method : methodArray = ReflectionHelper.getLocalMethods(clazz)) {
                    if (!pattern.matcher(method.getName()).matches()) continue;
                    list2.add(XmlMethodSelector.makeMethodName(method.getDeclaringClass().getName(), method.getName()));
                }
            }
        }
        return list2;
    }

    private static String methodName(String string) {
        if (string.contains("\\$")) {
            return string;
        }
        return string.replaceAll("\\Q$\\E", QUOTED_DOLLAR);
    }

    private static String makeMethodName(String string, String string2) {
        return string + "." + string2;
    }

    private static void checkMethod(Class<?> clazz, String string) {
        Pattern pattern = Pattern.compile(string);
        for (Method method : clazz.getMethods()) {
            if (!pattern.matcher(method.getName()).matches()) continue;
            return;
        }
        Utils.log("Warning", 2, "The regular expression \"" + string + "\" didn't match any method in class " + clazz.getName());
    }

    public void setXmlClasses(List<XmlClass> list) {
        this.m_classes = list;
        for (XmlClass xmlClass : list) {
            for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                XmlMethodSelector.checkMethod(xmlClass.getSupportClass(), xmlInclude.getName());
                String string = XmlMethodSelector.makeMethodName(xmlClass.getName(), xmlInclude.getName());
                this.m_includedMethods.put(string, xmlInclude);
            }
        }
    }

    public Map<String, String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public Map<String, String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void setExcludedGroups(Map<String, String> map) {
        this.m_excludedGroups = map;
    }

    public void setIncludedGroups(Map<String, String> map) {
        this.m_includedGroups = map;
    }

    private static boolean isIncluded(Collection<String> collection, boolean bl, String ... stringArray) {
        if (bl) {
            return XmlMethodSelector.isMemberOf(collection, stringArray);
        }
        return collection.isEmpty() || XmlMethodSelector.isMemberOf(collection, stringArray);
    }

    private static boolean isExcluded(Collection<String> collection, String ... stringArray) {
        return XmlMethodSelector.isMemberOf(collection, stringArray);
    }

    private static boolean isMemberOf(Collection<String> collection, String ... stringArray) {
        for (String string : stringArray) {
            for (String string2 : collection) {
                String string3 = XmlMethodSelector.methodName(string2);
                if (!Pattern.matches(string3, string)) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(String string) {
        Utils.log("XmlMethodSelector", 4, string);
    }

    @Deprecated
    public void setExpression(String string) {
        XmlScript xmlScript = new XmlScript();
        xmlScript.setLanguage("BeanShell");
        xmlScript.setExpression(string);
        this.setScript(xmlScript);
    }

    public void setScript(XmlScript xmlScript) {
        this.scriptSelector = xmlScript == null ? null : ScriptSelectorFactory.getScriptSelector((XmlScript)xmlScript);
    }

    @Override
    public void setTestMethods(List<ITestNGMethod> list) {
        this.m_testMethods = list;
    }

    private void init(IMethodSelectorContext iMethodSelectorContext) {
        String[] stringArray = this.m_includedGroups.keySet().toArray(new String[0]);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<ITestNGMethod> hashSet2 = new HashSet<ITestNGMethod>();
        List list = Lists.newArrayList();
        for (ITestNGMethod object : this.m_testMethods) {
            if (!this.includeMethod(iMethodSelectorContext, object, true)) continue;
            list.add(object);
        }
        MethodGroupsHelper.findGroupTransitiveClosure(list, this.m_testMethods, stringArray, hashSet, hashSet2);
        if (!this.m_includedGroups.isEmpty()) {
            for (String string : hashSet) {
                XmlMethodSelector.log("Including group " + (this.m_includedGroups.containsKey(string) ? ": " : "(implicitly): ") + string);
                this.m_includedGroups.put(string, string);
            }
            for (ITestNGMethod iTestNGMethod : hashSet2) {
                String string = iTestNGMethod.getQualifiedName();
                XmlInclude xmlInclude = new XmlInclude(string);
                this.m_includedMethods.put(string, xmlInclude);
                this.logInclusion("Including", "method ", string);
            }
        }
    }
}

