/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.collections.Lists;

public class ReflectionHelper {
    public static Method[] getLocalMethods(Class<?> clazz) {
        Method[] methodArray = ReflectionHelper.excludingMain(clazz);
        List<Method> list = ReflectionHelper.getDefaultMethods(clazz);
        if (list.isEmpty()) {
            List list2 = Lists.newArrayList();
            for (Method method : methodArray) {
                if (method.isBridge()) continue;
                list2.add(method);
            }
            return list2.toArray(new Method[0]);
        }
        Method[] methodArray2 = new Method[methodArray.length + list.size()];
        System.arraycopy(methodArray, 0, methodArray2, 0, methodArray.length);
        int n = methodArray.length;
        Iterator<Method> iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method;
            methodArray2[n] = method = iterator.next();
            ++n;
        }
        return methodArray2;
    }

    public static Method[] excludingMain(Class<?> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        LinkedList<Method> linkedList = new LinkedList<Method>();
        for (Method method : methodArray) {
            if ("main".equals(method.getName()) && ReflectionHelper.isStaticVoid(method) && ReflectionHelper.acceptsStringArray(method)) continue;
            linkedList.add(method);
        }
        return linkedList.toArray(new Method[0]);
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> clazz2) {
        if (clazz == null || clazz2 == null) {
            return null;
        }
        T t = null;
        for (Class<?> clazz3 = clazz; clazz3 != null && clazz3 != Object.class && (t = (T)clazz3.getAnnotation(clazz2)) == null; clazz3 = clazz3.getSuperclass()) {
        }
        return t;
    }

    private static boolean isStaticVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE) && Modifier.isStatic(method.getModifiers());
    }

    private static boolean acceptsStringArray(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            return false;
        }
        Class<?> clazz = classArray[0];
        return clazz.isArray() && clazz.isInstance(new String[0]);
    }

    private static List<Method> getDefaultMethods(Class<?> clazz2) {
        return Arrays.stream(clazz2.getInterfaces()).flatMap(clazz -> Arrays.stream(clazz.getMethods())).filter(method -> !Modifier.isAbstract(method.getModifiers())).collect(Collectors.toList());
    }
}

