/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.NoInjection;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.reflect.InjectableParameter;
import org.testng.internal.reflect.MethodMatcherException;
import org.testng.internal.reflect.Parameter;
import org.testng.xml.XmlTest;

public final class ReflectionRecipes {
    private static final Map<Class, Class> PRIMITIVE_MAPPING = new HashMap<Class, Class>();
    private static final Map<Class, List<Class>> ASSIGNABLE_MAPPING = new HashMap<Class, List<Class>>();

    private static void initPrimitiveMapping() {
        PRIMITIVE_MAPPING.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_MAPPING.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAPPING.put(Short.TYPE, Short.class);
        PRIMITIVE_MAPPING.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAPPING.put(Long.TYPE, Long.class);
        PRIMITIVE_MAPPING.put(Float.TYPE, Float.class);
        PRIMITIVE_MAPPING.put(Double.TYPE, Double.class);
        PRIMITIVE_MAPPING.put(Character.TYPE, Character.class);
        PRIMITIVE_MAPPING.put(Void.TYPE, Void.class);
    }

    private static void initAssignableMapping() {
        ASSIGNABLE_MAPPING.put(Double.TYPE, Arrays.asList(Float.class, Long.class, Integer.class, Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Float.TYPE, Arrays.asList(Long.class, Integer.class, Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Long.TYPE, Arrays.asList(Integer.class, Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Integer.TYPE, Arrays.asList(Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Short.TYPE, Arrays.asList(Character.class, Byte.class));
    }

    private ReflectionRecipes() {
        throw new TestNGException("Service is not meant to have instances");
    }

    public static boolean isInstanceOf(Class clazz, Object object) {
        boolean bl;
        if (object == null) {
            return !clazz.isPrimitive();
        }
        boolean bl2 = clazz.isInstance(object);
        if (!bl2 && clazz.isPrimitive()) {
            bl = PRIMITIVE_MAPPING.get(clazz).isInstance(object);
            if (!bl) {
                bl = ASSIGNABLE_MAPPING.get(clazz).contains(object.getClass());
            }
        } else {
            bl = bl2;
        }
        return bl;
    }

    public static boolean isOrImplementsInterface(Class<?> clazz, Class<?> clazz2) {
        boolean bl = false;
        if (clazz.isInterface()) {
            if (clazz.equals(clazz2)) {
                bl = true;
            } else {
                Class<?> clazz3;
                Class<?>[] classArray;
                Class<?>[] classArray2 = classArray = clazz2.getInterfaces();
                int n = classArray2.length;
                for (int i = 0; i < n && !(bl = (clazz3 = classArray2[i]).equals(clazz)); ++i) {
                }
            }
        }
        return bl;
    }

    public static boolean isOrExtends(Class<?> clazz, Class<?> clazz2) {
        boolean bl = false;
        if (clazz2 != null && !clazz.isInterface()) {
            bl = clazz.equals(clazz2) ? true : ReflectionRecipes.isOrExtends(clazz, clazz2.getSuperclass());
        }
        return bl;
    }

    public static Class<?>[] classesFromParameters(Parameter[] parameterArray) {
        Class[] classArray = new Class[parameterArray.length];
        int n = 0;
        for (Parameter parameter : parameterArray) {
            classArray[n] = parameter.getType();
            ++n;
        }
        return classArray;
    }

    public static Parameter[] getMethodParameters(Method method) {
        if (method == null) {
            return new Parameter[0];
        }
        return ReflectionRecipes.getParameters(method.getParameterTypes(), method.getParameterAnnotations());
    }

    public static Parameter[] getConstructorParameters(Constructor constructor) {
        if (constructor == null) {
            return new Parameter[0];
        }
        return ReflectionRecipes.getParameters(constructor.getParameterTypes(), constructor.getParameterAnnotations());
    }

    private static Parameter[] getParameters(Class<?>[] classArray, Annotation[][] annotationArray) {
        Parameter[] parameterArray = new Parameter[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            parameterArray[i] = new Parameter(i, classArray[i], annotationArray[i]);
        }
        return parameterArray;
    }

    public static boolean matchArrayEnding(Parameter[] parameterArray, Object[] objectArray) {
        return ReflectionRecipes.matchArrayEnding(ReflectionRecipes.classesFromParameters(parameterArray), objectArray);
    }

    public static boolean matchArrayEnding(Class<?>[] classArray, Object[] objectArray) {
        if (classArray.length < 1) {
            return false;
        }
        if (!classArray[classArray.length - 1].isArray()) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        if (classArray.length <= objectArray.length) {
            for (Class<?> clazz : classArray) {
                if (n >= classArray.length - 1) break;
                bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]);
                ++n;
                if (bl) {
                    continue;
                }
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            Class<?> clazz = classArray[classArray.length - 1].getComponentType();
            while (n < objectArray.length && (bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]))) {
                ++n;
            }
        }
        return bl;
    }

    public static boolean exactMatch(Parameter[] parameterArray, Object[] objectArray) {
        return ReflectionRecipes.exactMatch(ReflectionRecipes.classesFromParameters(parameterArray), objectArray);
    }

    public static boolean exactMatch(Class<?>[] classArray, Object[] objectArray) {
        boolean bl = true;
        if (classArray.length == objectArray.length) {
            int n = 0;
            for (Class<?> clazz : classArray) {
                bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]);
                ++n;
                if (bl) {
                    continue;
                }
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean lenientMatch(Parameter[] parameterArray, Object[] objectArray) {
        return ReflectionRecipes.lenientMatch(ReflectionRecipes.classesFromParameters(parameterArray), objectArray);
    }

    public static boolean lenientMatch(Class<?>[] classArray, Object[] objectArray) {
        boolean bl = true;
        int n = 0;
        for (Class<?> clazz : classArray) {
            bl = ReflectionRecipes.isInstanceOf(clazz, objectArray[n]);
            ++n;
            if (!bl) break;
        }
        return bl;
    }

    public static Parameter[] filter(Parameter[] parameterArray, Set<InjectableParameter> set) {
        boolean bl;
        boolean bl2 = bl = set != null && !set.isEmpty();
        if (!bl) {
            return parameterArray;
        }
        boolean bl3 = false;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(parameterArray.length);
        for (Parameter parameter : parameterArray) {
            boolean bl4 = false;
            for (InjectableParameter injectableParameter : set) {
                bl4 = ReflectionRecipes.canInject(parameter, injectableParameter);
                if (injectableParameter == InjectableParameter.CURRENT_TEST_METHOD) {
                    if (bl4 && !bl3) {
                        bl3 = true;
                    } else {
                        bl4 = false;
                    }
                }
                if (!bl4) continue;
                break;
            }
            if (bl4) continue;
            arrayList.add(parameter);
        }
        return arrayList.toArray(new Parameter[0]);
    }

    public static Object[] inject(Parameter[] parameterArray, Set<InjectableParameter> set, Object[] objectArray, Method method, ITestContext iTestContext, ITestResult iTestResult) {
        return ReflectionRecipes.nativelyInject(parameterArray, set, objectArray, method, iTestContext, iTestResult);
    }

    private static Object[] nativelyInject(Parameter[] parameterArray, Set<InjectableParameter> set, Object[] objectArray, Object object, ITestContext iTestContext, ITestResult iTestResult) {
        if (set == null || set.isEmpty()) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        ListBackedImmutableQueue<Object> listBackedImmutableQueue = new ListBackedImmutableQueue<Object>(objectArray);
        boolean bl = false;
        for (Parameter parameter : parameterArray) {
            boolean bl2 = false;
            Object object2 = null;
            for (InjectableParameter injectableParameter : set) {
                bl2 = ReflectionRecipes.canInject(parameter, injectableParameter);
                if (!bl2) continue;
                switch (injectableParameter) {
                    case CURRENT_TEST_METHOD: {
                        if (!bl) {
                            bl = true;
                            object2 = object;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    case ITEST_CONTEXT: {
                        object2 = iTestContext;
                        break;
                    }
                    case ITEST_RESULT: {
                        object2 = iTestResult;
                        break;
                    }
                    case XML_TEST: {
                        object2 = iTestContext != null ? iTestContext.getCurrentXmlTest() : null;
                        break;
                    }
                }
                if (!bl2) continue;
                arrayList.add(object2);
                break;
            }
            if (bl2 || ((ListBackedImmutableQueue)listBackedImmutableQueue).backingList.isEmpty()) continue;
            arrayList.add(listBackedImmutableQueue.poll());
        }
        if (!((ListBackedImmutableQueue)listBackedImmutableQueue).backingList.isEmpty()) {
            String string = "Missing one or more parameters that are being injected by the data provider. Please add the below arguments to the ";
            String string2 = null;
            if (object instanceof Method) {
                string2 = MethodMatcherException.generateMessage(string + "method.", (Method)object, ((ListBackedImmutableQueue)listBackedImmutableQueue).backingList.toArray());
            } else if (object instanceof Constructor) {
                string2 = MethodMatcherException.generateMessage(string + "constructor.", (Constructor)object, ((ListBackedImmutableQueue)listBackedImmutableQueue).backingList.toArray());
            }
            int n = RuntimeBehavior.useStrictParameterMatching() ? 1 : 0;
            if (n != 0) {
                throw new MethodMatcherException(string2);
            }
            System.err.println(":::WARNING:::\n" + string2);
        }
        Object[] objectArray2 = new Object[arrayList.size()];
        return arrayList.toArray(objectArray2);
    }

    public static Object[] inject(Parameter[] parameterArray, Set<InjectableParameter> set, Object[] objectArray, Constructor constructor, ITestContext iTestContext, ITestResult iTestResult) {
        return ReflectionRecipes.nativelyInject(parameterArray, set, objectArray, constructor, iTestContext, iTestResult);
    }

    private static boolean canInject(Parameter parameter, InjectableParameter injectableParameter) {
        boolean bl = false;
        if (parameter != null) {
            boolean bl2 = !parameter.isAnnotationPresent(NoInjection.class);
            switch (injectableParameter) {
                case CURRENT_TEST_METHOD: {
                    boolean bl3 = ReflectionRecipes.isOrExtends(Method.class, parameter.getType());
                    bl = bl2 && bl3;
                    break;
                }
                case ITEST_CONTEXT: {
                    bl = bl2 && ReflectionRecipes.isOrImplementsInterface(ITestContext.class, parameter.getType());
                    break;
                }
                case ITEST_RESULT: {
                    bl = bl2 && ReflectionRecipes.isOrImplementsInterface(ITestResult.class, parameter.getType());
                    break;
                }
                case XML_TEST: {
                    bl = bl2 && ReflectionRecipes.isOrExtends(XmlTest.class, parameter.getType());
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    static {
        ReflectionRecipes.initPrimitiveMapping();
        ReflectionRecipes.initAssignableMapping();
    }

    private static class ListBackedImmutableQueue<T> {
        private final List<T> backingList;

        ListBackedImmutableQueue(T[] TArray) {
            this.backingList = new ArrayList<T>(TArray.length);
            Collections.addAll(this.backingList, TArray);
        }

        T poll() {
            if (!this.backingList.isEmpty()) {
                return this.backingList.remove(0);
            }
            throw new TestNGException("Queue exhausted");
        }
    }
}

