/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.util.Collection;
import java.util.List;
import org.testng.IInvokedMethodListener;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.ClassHelper;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.Utils;

public interface IJUnitTestRunner {
    public static final String JUNIT_TESTRUNNER = "org.testng.junit.JUnitTestRunner";
    public static final String JUNIT_4_TESTRUNNER = "org.testng.junit.JUnit4TestRunner";

    public void setInvokedMethodListeners(Collection<IInvokedMethodListener> var1);

    public void setTestResultNotifier(ITestResultNotifier var1);

    public void run(Class var1, String ... var2);

    public List<ITestNGMethod> getTestMethods();

    public static IJUnitTestRunner createTestRunner(TestRunner testRunner) {
        IJUnitTestRunner iJUnitTestRunner = null;
        try {
            Class.forName("org.junit.Test");
            Class<?> clazz = ClassHelper.forName(JUNIT_4_TESTRUNNER);
            if (clazz != null) {
                iJUnitTestRunner = (IJUnitTestRunner)clazz.newInstance();
                iJUnitTestRunner.setTestResultNotifier(testRunner);
            }
        }
        catch (Throwable throwable) {
            Utils.log(IJUnitTestRunner.class.getSimpleName(), 2, "JUnit 4 was not found on the classpath");
            try {
                Class.forName("junit.framework.Test");
                Class<?> clazz = ClassHelper.forName(JUNIT_TESTRUNNER);
                if (clazz != null) {
                    iJUnitTestRunner = (IJUnitTestRunner)clazz.newInstance();
                    iJUnitTestRunner.setTestResultNotifier(testRunner);
                }
            }
            catch (Exception exception) {
                Utils.log(IJUnitTestRunner.class.getSimpleName(), 2, "JUnit 3 was not found on the classpath");
                throw new TestNGException("Cannot create JUnit runner", exception);
            }
        }
        return iJUnitTestRunner;
    }
}

