/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.TestNGMethod;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.junit.INameFilter;
import org.testng.xml.XmlTest;

public class JUnitMethodFinder
implements ITestMethodFinder {
    private final String m_testName;
    private final IAnnotationFinder m_annotationFinder;

    public JUnitMethodFinder(String string, IAnnotationFinder iAnnotationFinder) {
        this.m_testName = string;
        this.m_annotationFinder = iAnnotationFinder;
    }

    public ITestNGMethod[] getTestMethods(Class clazz, XmlTest xmlTest) {
        return this.privateFindTestMethods(constructorOrMethod -> constructorOrMethod.getName().startsWith("test") && constructorOrMethod.getParameterTypes().length == 0, clazz);
    }

    private ITestNGMethod[] privateFindTestMethods(INameFilter iNameFilter, Class clazz) {
        List list = Lists.newArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method : methodArray = ReflectionHelper.excludingMain(clazz2)) {
                TestNGMethod testNGMethod = new TestNGMethod(method, this.m_annotationFinder, null, null);
                ConstructorOrMethod constructorOrMethod = testNGMethod.getConstructorOrMethod();
                String string = constructorOrMethod.getName();
                if (!iNameFilter.accept(constructorOrMethod) || hashSet.contains(string)) continue;
                list.add(testNGMethod);
                hashSet.add(string);
            }
        }
        return list.toArray(new ITestNGMethod[0]);
    }

    public ITestNGMethod[] getBeforeTestMethods(Class clazz) {
        return this.privateFindTestMethods(constructorOrMethod -> "setUp".equals(constructorOrMethod.getName()), clazz);
    }

    public ITestNGMethod[] getAfterTestMethods(Class clazz) {
        return this.privateFindTestMethods(constructorOrMethod -> "tearDown".equals(constructorOrMethod.getName()), clazz);
    }

    public ITestNGMethod[] getAfterClassMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeClassMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeSuiteMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getAfterSuiteMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getBeforeGroupsConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }

    public ITestNGMethod[] getAfterGroupsConfigurationMethods(Class clazz) {
        return new ITestNGMethod[0];
    }
}

