/*
 * Decompiled with CFR 0.152.
 */
package org.testng.util;

import java.util.Map;
import org.testng.collections.Maps;

public final class Strings {
    private static final Map<String, String> ESCAPE_HTML_MAP = Maps.newLinkedHashMap();

    private Strings() {
    }

    public static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNotNullAndNotEmpty(String string) {
        return !Strings.isNullOrEmpty(string);
    }

    public static String getValueOrEmpty(String string) {
        return Strings.isNotNullAndNotEmpty(string) ? string : "";
    }

    public static String escapeHtml(String string) {
        String string2 = string;
        for (Map.Entry<String, String> entry : ESCAPE_HTML_MAP.entrySet()) {
            string2 = string2.replace(entry.getKey(), entry.getValue());
        }
        return string2;
    }

    public static String valueOf(Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : map.values()) {
            stringBuilder.append(obj).append(" ");
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i]).append(string);
        }
        if (stringArray.length > 1) {
            stringBuilder.append(stringArray[stringArray.length - 1]);
        }
        return stringBuilder.toString();
    }

    static {
        ESCAPE_HTML_MAP.put("&", "&amp;");
        ESCAPE_HTML_MAP.put("<", "&lt;");
        ESCAPE_HTML_MAP.put(">", "&gt;");
    }
}

