/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.Properties;
import org.testng.TestNGException;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlScript;
import org.testng.xml.XmlSuite;
import org.testng.xml.dom.OnElement;

public class XmlMethodSelector {
    private String m_className;
    private int m_priority;
    private XmlScript m_script;

    public void setClassName(String string) {
        this.m_className = string;
    }

    public String getClassName() {
        return this.m_className;
    }

    @OnElement(tag="selector-class", attributes={"name", "priority"})
    public void setElement(String string, String string2) {
        this.setName(string);
        this.setPriority(Integer.parseInt(string2));
    }

    public void setName(String string) {
        this.m_className = string;
    }

    public XmlScript getScript() {
        return this.m_script;
    }

    public void setScript(XmlScript xmlScript) {
        this.m_script = xmlScript;
    }

    @Deprecated
    public String getExpression() {
        if (this.m_script == null) {
            return null;
        }
        return this.m_script.getExpression();
    }

    @Deprecated
    public void setExpression(String string) {
        if (this.m_script == null) {
            this.m_script = new XmlScript();
        }
        this.m_script.setExpression(string);
    }

    @Deprecated
    public String getLanguage() {
        if (this.m_script == null) {
            return null;
        }
        return this.m_script.getLanguage();
    }

    @Deprecated
    public void setLanguage(String string) {
        if (this.m_script == null) {
            this.m_script = new XmlScript();
        }
        this.m_script.setLanguage(string);
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setPriority(int n) {
        this.m_priority = n;
    }

    public String toXml(String string) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        xMLStringBuffer.push("method-selector");
        if (null != this.m_className) {
            Properties properties = new Properties();
            properties.setProperty("name", this.getClassName());
            if (this.getPriority() != -1) {
                properties.setProperty("priority", String.valueOf(this.getPriority()));
            }
            xMLStringBuffer.addEmptyElement("selector-class", properties);
        } else if (this.getScript() != null && this.getScript().getLanguage() != null) {
            Properties properties = new Properties();
            properties.setProperty("language", this.getScript().getLanguage());
            xMLStringBuffer.push("script", properties);
            xMLStringBuffer.addCDATA(this.getScript().getExpression());
            xMLStringBuffer.pop("script");
        } else {
            throw new TestNGException("Invalid Method Selector:  found neither class name nor language");
        }
        xMLStringBuffer.pop("method-selector");
        return xMLStringBuffer.toXML();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_className == null ? 0 : this.m_className.hashCode());
        if (this.getScript() != null) {
            n = 31 * n + (this.getScript().getExpression() == null ? 0 : this.getScript().getExpression().hashCode());
            n = 31 * n + (this.getScript().getLanguage() == null ? 0 : this.getScript().getLanguage().hashCode());
        }
        n = 31 * n + this.m_priority;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != object.getClass()) {
            return XmlSuite.f();
        }
        XmlMethodSelector xmlMethodSelector = (XmlMethodSelector)object;
        if (this.m_className == null ? xmlMethodSelector.m_className != null : !this.m_className.equals(xmlMethodSelector.m_className)) {
            return XmlSuite.f();
        }
        if (this.getScript() == null || this.getScript().getExpression() == null ? xmlMethodSelector.getScript() != null && xmlMethodSelector.getScript().getExpression() != null : !this.getScript().getExpression().equals(xmlMethodSelector.getScript() == null ? null : xmlMethodSelector.getScript().getExpression())) {
            return XmlSuite.f();
        }
        if (this.getScript() == null || this.getScript().getLanguage() == null ? xmlMethodSelector.getScript() != null && xmlMethodSelector.getScript().getLanguage() != null : !this.getScript().getLanguage().equals(xmlMethodSelector.getScript() == null ? null : xmlMethodSelector.getScript().getLanguage())) {
            return XmlSuite.f();
        }
        if (this.m_priority != xmlMethodSelector.m_priority) {
            return XmlSuite.f();
        }
        return true;
    }
}

