/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlDependencies;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlRun;
import org.testng.xml.XmlScript;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlWeaver;
import org.testng.xml.dom.ParentSetter;

public class XmlTest
implements Cloneable {
    public static final int DEFAULT_TIMEOUT_MS = Integer.MAX_VALUE;
    private XmlSuite m_suite;
    private String m_name;
    private Integer m_verbose = XmlSuite.DEFAULT_VERBOSE;
    private Boolean m_isJUnit = XmlSuite.DEFAULT_JUNIT;
    private int m_threadCount = -1;
    private List<XmlClass> m_xmlClasses = Lists.newArrayList();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private XmlSuite.ParallelMode m_parallel;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_timeOut;
    private Boolean m_skipFailedInvocationCounts = XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    private Map<String, List<Integer>> m_failedInvocationNumbers = null;
    private Boolean m_preserveOrder = XmlSuite.DEFAULT_PRESERVE_ORDER;
    private int m_index;
    private Boolean m_groupByInstances;
    private Boolean m_allowReturnValues = null;
    private Map<String, String> m_xmlDependencyGroups = Maps.newHashMap();
    private XmlGroups m_xmlGroups;

    public XmlTest(XmlSuite xmlSuite, int n) {
        this.init(xmlSuite, n);
    }

    public XmlTest(XmlSuite xmlSuite) {
        this.init(xmlSuite, 0);
    }

    private void init(XmlSuite xmlSuite, int n) {
        this.m_suite = xmlSuite;
        this.m_suite.getTests().add(this);
        this.m_index = n;
        this.m_name = "Command line test " + UUID.randomUUID().toString();
    }

    public XmlTest() {
    }

    public void setXmlPackages(List<XmlPackage> list) {
        this.m_xmlPackages = Lists.newArrayList(list);
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getXmlPackages();
    }

    public void setPackages(List<XmlPackage> list) {
        this.setXmlPackages(list);
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> list) {
        this.m_methodSelectors = Lists.newArrayList(list);
    }

    public final XmlSuite getSuite() {
        if (this.m_suite == null) {
            throw new IllegalStateException("Current [XmlTest] object is not associated with any [XmlSuite] yet.");
        }
        return this.m_suite;
    }

    public List<String> getIncludedGroups() {
        List list = Lists.newArrayList();
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            list.addAll(this.m_xmlGroups.getRun().getIncludes());
        }
        list.addAll(this.getSuite().getIncludedGroups());
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    public void setClassNames(List<XmlClass> list) {
        this.m_xmlClasses = list;
    }

    public List<XmlClass> getXmlClasses() {
        return this.m_xmlClasses;
    }

    public List<XmlClass> getClasses() {
        return this.getXmlClasses();
    }

    public void setClasses(List<XmlClass> list) {
        this.setXmlClasses(list);
    }

    public void setXmlClasses(List<XmlClass> list) {
        this.m_xmlClasses = list;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setVerbose(int n) {
        this.m_verbose = n;
    }

    public int getThreadCount() {
        return this.m_threadCount > 0 ? this.m_threadCount : this.getSuite().getThreadCount();
    }

    public void setThreadCount(int n) {
        this.m_threadCount = n;
    }

    public void setIncludedGroups(List<String> list) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        if (this.m_xmlGroups.getRun() == null) {
            this.m_xmlGroups.setRun(new XmlRun());
        }
        List<String> list2 = this.m_xmlGroups.getRun().getIncludes();
        list2.clear();
        list2.addAll(list);
    }

    public void setExcludedGroups(List<String> list) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        if (this.m_xmlGroups.getRun() == null) {
            this.m_xmlGroups.setRun(new XmlRun());
        }
        List<String> list2 = this.m_xmlGroups.getRun().getExcludes();
        list2.clear();
        list2.addAll(list);
    }

    public List<String> getExcludedGroups() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_xmlGroups != null && this.m_xmlGroups.getRun() != null) {
            arrayList.addAll(this.m_xmlGroups.getRun().getExcludes());
        }
        arrayList.addAll(this.getSuite().getExcludedGroups());
        return Collections.unmodifiableList(arrayList);
    }

    public void addIncludedGroup(String string) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
            this.m_xmlGroups.setRun(new XmlRun());
        }
        this.m_xmlGroups.getRun().getIncludes().add(string);
    }

    public void addExcludedGroup(String string) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        if (this.m_xmlGroups.getRun() == null) {
            this.m_xmlGroups.setRun(new XmlRun());
        }
        this.m_xmlGroups.getRun().getExcludes().add(string);
    }

    public int getVerbose() {
        Integer n = this.m_verbose;
        if (null == n || XmlSuite.DEFAULT_VERBOSE.equals(this.m_verbose)) {
            n = this.getSuite().getVerbose();
        }
        if (null != n) {
            return n;
        }
        return 1;
    }

    public boolean getGroupByInstances() {
        Boolean bl = this.m_groupByInstances;
        if (bl == null || XmlSuite.DEFAULT_GROUP_BY_INSTANCES.equals(this.m_groupByInstances)) {
            bl = this.getSuite().getGroupByInstances();
        }
        if (bl != null) {
            return bl;
        }
        return XmlSuite.DEFAULT_GROUP_BY_INSTANCES;
    }

    public void setGroupByInstances(boolean bl) {
        this.m_groupByInstances = bl;
    }

    public boolean isJUnit() {
        Boolean bl = this.m_isJUnit;
        if (null == bl || XmlSuite.DEFAULT_JUNIT.equals(bl)) {
            bl = this.getSuite().isJUnit();
        }
        return bl;
    }

    public void setJUnit(boolean bl) {
        this.m_isJUnit = bl;
    }

    public void setJunit(boolean bl) {
        this.setJUnit(bl);
    }

    public void setSkipFailedInvocationCounts(boolean bl) {
        this.m_skipFailedInvocationCounts = bl;
    }

    public boolean skipFailedInvocationCounts() {
        Boolean bl = this.m_skipFailedInvocationCounts;
        if (null == bl) {
            bl = this.getSuite().skipFailedInvocationCounts();
        }
        return bl;
    }

    public void addMetaGroup(String string, List<String> list) {
        if (this.m_xmlGroups == null) {
            this.m_xmlGroups = new XmlGroups();
        }
        XmlDefine xmlDefine = new XmlDefine();
        xmlDefine.setName(string);
        xmlDefine.getIncludes().addAll(list);
        this.m_xmlGroups.getDefines().add(xmlDefine);
    }

    public void addMetaGroup(String string, String ... stringArray) {
        this.addMetaGroup(string, Arrays.asList(stringArray));
    }

    public void setMetaGroups(Map<String, List<String>> map) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this.addMetaGroup(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, List<String>> getMetaGroups() {
        if (this.m_xmlGroups == null) {
            return Collections.emptyMap();
        }
        Map map = Maps.newHashMap();
        List<XmlDefine> list = this.m_xmlGroups.getDefines();
        for (XmlDefine xmlDefine : list) {
            map.put(xmlDefine.getName(), xmlDefine.getIncludes());
        }
        return map;
    }

    public void setParameters(Map<String, String> map) {
        this.m_parameters = map;
    }

    public void addParameter(String string, String string2) {
        this.m_parameters.put(string, string2);
    }

    public String getParameter(String string) {
        String string2 = this.m_parameters.get(string);
        if (null == string2) {
            string2 = this.getSuite().getParameter(string);
        }
        return string2;
    }

    public Map<String, String> getAllParameters() {
        Map map = Maps.newHashMap();
        map.putAll(this.getSuite().getParameters());
        map.putAll(this.m_parameters);
        return map;
    }

    public Map<String, String> getLocalParameters() {
        return this.m_parameters;
    }

    @Deprecated
    public Map<String, String> getParameters() {
        return this.getAllParameters();
    }

    @Deprecated
    public Map<String, String> getTestParameters() {
        return this.getLocalParameters();
    }

    public void setParallel(XmlSuite.ParallelMode parallelMode) {
        this.m_parallel = XmlSuite.ParallelMode.skipDeprecatedValues(parallelMode);
    }

    public XmlSuite.ParallelMode getParallel() {
        XmlSuite.ParallelMode parallelMode = this.getSuite().getParallel();
        if (null != this.m_parallel) {
            parallelMode = this.m_parallel;
        }
        return parallelMode;
    }

    public String getTimeOut() {
        String string = this.getSuite().getTimeOut();
        if (null != this.m_timeOut) {
            string = this.m_timeOut;
        }
        return string;
    }

    public long getTimeOut(long l) {
        long l2 = l;
        if (this.getTimeOut() != null) {
            l2 = Long.parseLong(this.getTimeOut());
        }
        return l2;
    }

    public void setTimeOut(long l) {
        this.m_timeOut = Long.toString(l);
    }

    private void setTimeOut(String string) {
        this.m_timeOut = string;
    }

    @Deprecated
    public void setExpression(String string) {
        this.setBeanShellExpression(string);
    }

    @Deprecated
    public void setBeanShellExpression(String string) {
        if (string != null) {
            XmlScript xmlScript = new XmlScript();
            xmlScript.setExpression(string);
            xmlScript.setLanguage("BeanShell");
        }
    }

    public void setScript(XmlScript xmlScript) {
        List<XmlMethodSelector> list = this.getMethodSelectors();
        if (list.size() > 0) {
            XmlMethodSelector xmlMethodSelector = list.get(0);
            xmlMethodSelector.setScript(xmlScript);
        } else if (xmlScript != null) {
            XmlMethodSelector xmlMethodSelector = new XmlMethodSelector();
            list.add(xmlMethodSelector);
            xmlMethodSelector.setScript(xmlScript);
        }
    }

    @Deprecated
    public String getExpression() {
        XmlScript xmlScript = this.getScript();
        if (xmlScript == null) {
            return null;
        }
        return xmlScript.getExpression();
    }

    public XmlScript getScript() {
        List<XmlMethodSelector> list = this.getMethodSelectors();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0).getScript();
    }

    public String toXml(String string) {
        return XmlWeaver.asXml((XmlTest)this, (String)string);
    }

    public Object clone() {
        XmlTest xmlTest = new XmlTest(this.getSuite());
        xmlTest.setName(this.getName());
        xmlTest.setIncludedGroups(this.getIncludedGroups());
        xmlTest.setExcludedGroups(this.getExcludedGroups());
        xmlTest.setJUnit(this.isJUnit());
        xmlTest.setParallel(this.getParallel());
        xmlTest.setVerbose(this.getVerbose());
        xmlTest.setParameters(this.getLocalParameters());
        xmlTest.setXmlPackages(this.getXmlPackages());
        xmlTest.setTimeOut(this.getTimeOut());
        Map<String, List<String>> map = this.getMetaGroups();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            xmlTest.addMetaGroup(entry.getKey(), entry.getValue());
        }
        return xmlTest;
    }

    public List<Integer> getInvocationNumbers(String string) {
        Object object;
        if (this.m_failedInvocationNumbers == null) {
            this.m_failedInvocationNumbers = Maps.newHashMap();
            object = this.getXmlClasses().iterator();
            while (object.hasNext()) {
                XmlClass xmlClass = (XmlClass)object.next();
                for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                    List<Integer> list = xmlInclude.getInvocationNumbers();
                    if (list.size() <= 0) continue;
                    String string2 = xmlClass.getName() + "." + xmlInclude.getName();
                    this.m_failedInvocationNumbers.put(string2, list);
                }
            }
        }
        if ((object = this.m_failedInvocationNumbers.get(string)) == null) {
            return Lists.newArrayList();
        }
        return object;
    }

    @Deprecated
    public void setPreserveOrder(String string) {
        this.setPreserveOrder(Boolean.valueOf(string));
    }

    public void setPreserveOrder(Boolean bl) {
        this.m_preserveOrder = bl;
    }

    public Boolean getPreserveOrder() {
        if (this.m_preserveOrder == null) {
            return this.getSuite().getPreserveOrder();
        }
        return this.m_preserveOrder;
    }

    public void setSuite(XmlSuite xmlSuite) {
        this.m_suite = xmlSuite;
    }

    public Boolean getAllowReturnValues() {
        if (this.m_allowReturnValues != null) {
            return this.m_allowReturnValues;
        }
        return this.getSuite().getAllowReturnValues();
    }

    public void setAllowReturnValues(Boolean bl) {
        this.m_allowReturnValues = bl;
    }

    public int getIndex() {
        return this.m_index;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_xmlGroups == null || this.m_xmlGroups.getRun() == null ? 0 : this.m_xmlGroups.getRun().getExcludes().hashCode());
        n = 31 * n + (this.m_failedInvocationNumbers == null ? 0 : this.m_failedInvocationNumbers.hashCode());
        n = 31 * n + (this.m_xmlGroups == null || this.m_xmlGroups.getRun() == null ? 0 : this.m_xmlGroups.getRun().getIncludes().hashCode());
        n = 31 * n + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        n = 31 * n + (this.m_xmlGroups == null ? 0 : this.m_xmlGroups.getDefines().hashCode());
        n = 31 * n + (this.m_methodSelectors == null ? 0 : this.m_methodSelectors.hashCode());
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        n = 31 * n + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        n = 31 * n + (this.m_parameters == null ? 0 : this.m_parameters.hashCode());
        n = 31 * n + (this.m_preserveOrder == null ? 0 : this.m_preserveOrder.hashCode());
        n = 31 * n + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        n = 31 * n + this.m_threadCount;
        n = 31 * n + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        n = 31 * n + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        n = 31 * n + (this.m_xmlClasses == null ? 0 : this.m_xmlClasses.hashCode());
        n = 31 * n + (this.m_xmlPackages == null ? 0 : this.m_xmlPackages.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != object.getClass()) {
            return XmlSuite.f();
        }
        XmlTest xmlTest = (XmlTest)object;
        if (this.m_xmlGroups == null) {
            if (xmlTest.m_xmlGroups != null) {
                return XmlSuite.f();
            }
        } else {
            if (xmlTest.m_xmlGroups == null) {
                return false;
            }
            if (this.m_xmlGroups.getRun() == null && xmlTest.m_xmlGroups != null || this.m_xmlGroups.getRun() != null && xmlTest.m_xmlGroups == null) {
                return false;
            }
            if (!this.m_xmlGroups.getRun().getExcludes().equals(xmlTest.m_xmlGroups.getRun().getExcludes())) {
                return XmlSuite.f();
            }
            if (!this.m_xmlGroups.getRun().getIncludes().equals(xmlTest.m_xmlGroups.getRun().getIncludes())) {
                return XmlSuite.f();
            }
            if (!this.m_xmlGroups.getDefines().equals(xmlTest.m_xmlGroups.getDefines())) {
                return false;
            }
        }
        if (this.m_failedInvocationNumbers == null ? xmlTest.m_failedInvocationNumbers != null : !this.m_failedInvocationNumbers.equals(xmlTest.m_failedInvocationNumbers)) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? xmlTest.m_isJUnit != null && !xmlTest.m_isJUnit.equals(XmlSuite.DEFAULT_JUNIT) : !this.m_isJUnit.equals(xmlTest.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? xmlTest.m_methodSelectors != null : !this.m_methodSelectors.equals(xmlTest.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? xmlTest.m_name != null : !this.m_name.equals(xmlTest.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? xmlTest.m_parallel != null : !this.m_parallel.equals((Object)xmlTest.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_parameters == null ? xmlTest.m_parameters != null : !this.m_parameters.equals(xmlTest.m_parameters)) {
            return XmlSuite.f();
        }
        if (this.m_preserveOrder == null ? xmlTest.m_preserveOrder != null : !this.m_preserveOrder.equals(xmlTest.m_preserveOrder)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? xmlTest.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(xmlTest.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != xmlTest.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? xmlTest.m_timeOut != null : !this.m_timeOut.equals(xmlTest.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? xmlTest.m_verbose != null : !this.m_verbose.equals(xmlTest.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlClasses == null ? xmlTest.m_xmlClasses != null : !this.m_xmlClasses.equals(xmlTest.m_xmlClasses)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? xmlTest.m_xmlPackages != null : !this.m_xmlPackages.equals(xmlTest.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }

    public void addXmlDependencyGroup(String string, String string2) {
        if (this.m_xmlDependencyGroups.containsKey(string)) {
            throw new TestNGException("Duplicate group dependency found for group \"" + string + "\", use a space-separated list of groups in the \"depends-on\" attribute");
        }
        this.m_xmlDependencyGroups.put(string, string2);
    }

    public Map<String, String> getXmlDependencyGroups() {
        Map<String, String> map = this.m_xmlDependencyGroups;
        if (this.m_xmlGroups != null) {
            List<XmlDependencies> list = this.m_xmlGroups.getDependencies();
            for (XmlDependencies xmlDependencies : list) {
                map.putAll(xmlDependencies.getDependencies());
            }
        }
        return map;
    }

    @ParentSetter
    public void setXmlSuite(XmlSuite xmlSuite) {
        this.m_suite = xmlSuite;
    }

    public void setGroups(XmlGroups xmlGroups) {
        this.m_xmlGroups = xmlGroups;
    }

    public XmlGroups getXmlGroups() {
        return this.m_xmlGroups;
    }

    public boolean nameMatchesAny(List<String> list) {
        return list.contains(this.getName());
    }
}

