/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CloudWatchLogsConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfigurationType> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(LogConfigurationType.getter(LogConfigurationType::logLevelAsString)).setter(LogConfigurationType.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(LogConfigurationType.getter(LogConfigurationType::eventSourceAsString)).setter(LogConfigurationType.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<CloudWatchLogsConfigurationType> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogsConfiguration").getter(LogConfigurationType.getter(LogConfigurationType::cloudWatchLogsConfiguration)).setter(LogConfigurationType.setter(Builder::cloudWatchLogsConfiguration)).constructor(CloudWatchLogsConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD, EVENT_SOURCE_FIELD, CLOUD_WATCH_LOGS_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logLevel;
    private final String eventSource;
    private final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;

    private LogConfigurationType(BuilderImpl builder) {
        this.logLevel = builder.logLevel;
        this.eventSource = builder.eventSource;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final EventSourceName eventSource() {
        return EventSourceName.fromValue(this.eventSource);
    }

    public final String eventSourceAsString() {
        return this.eventSource;
    }

    public final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration() {
        return this.cloudWatchLogsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurationType)) {
            return false;
        }
        LogConfigurationType other = (LogConfigurationType)obj;
        return Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.eventSourceAsString(), other.eventSourceAsString()) && Objects.equals(this.cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfigurationType").add("LogLevel", (Object)this.logLevelAsString()).add("EventSource", (Object)this.eventSourceAsString()).add("CloudWatchLogsConfiguration", (Object)this.cloudWatchLogsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSourceAsString()));
            }
            case "CloudWatchLogsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfigurationType, T> g) {
        return obj -> g.apply((LogConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logLevel;
        private String eventSource;
        private CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfigurationType model) {
            this.logLevel(model.logLevel);
            this.eventSource(model.eventSource);
            this.cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSourceName eventSource) {
            this.eventSource(eventSource == null ? null : eventSource.toString());
            return this;
        }

        public final CloudWatchLogsConfigurationType.Builder getCloudWatchLogsConfiguration() {
            return this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfigurationType.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public LogConfigurationType build() {
            return new LogConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfigurationType> {
        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder eventSource(String var1);

        public Builder eventSource(EventSourceName var1);

        public Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType var1);

        default public Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfigurationType.Builder> cloudWatchLogsConfiguration) {
            return this.cloudWatchLogsConfiguration((CloudWatchLogsConfigurationType)((CloudWatchLogsConfigurationType.Builder)CloudWatchLogsConfigurationType.builder().applyMutation(cloudWatchLogsConfiguration)).build());
        }
    }
}

