/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RiskDecisionType {
    NO_RISK("NoRisk"),
    ACCOUNT_TAKEOVER("AccountTakeover"),
    BLOCK("Block"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RiskDecisionType> VALUE_MAP;
    private final String value;

    private RiskDecisionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RiskDecisionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RiskDecisionType> knownValues() {
        EnumSet<RiskDecisionType> knownValues = EnumSet.allOf(RiskDecisionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RiskDecisionType.class, RiskDecisionType::toString);
    }
}

