/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType;

public class ListResourceServersPublisher
implements SdkPublisher<ListResourceServersResponse> {
    private final CognitoIdentityProviderAsyncClient client;
    private final ListResourceServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceServersPublisher(CognitoIdentityProviderAsyncClient client, ListResourceServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceServersPublisher(CognitoIdentityProviderAsyncClient client, ListResourceServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceServerType> resourceServers() {
        Function<ListResourceServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceServers() != null) {
                return response.resourceServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceServersResponseFetcher
    implements AsyncPageFetcher<ListResourceServersResponse> {
        private ListResourceServersResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceServersResponse> nextPage(ListResourceServersResponse previousPage) {
            if (previousPage == null) {
                return ListResourceServersPublisher.this.client.listResourceServers(ListResourceServersPublisher.this.firstRequest);
            }
            return ListResourceServersPublisher.this.client.listResourceServers((ListResourceServersRequest)((Object)ListResourceServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

