/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfirmationState {
    CONFIRMED("Confirmed"),
    DENIED("Denied"),
    NONE("None"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfirmationState> VALUE_MAP;
    private final String value;

    private ConfirmationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfirmationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfirmationState> knownValues() {
        EnumSet<ConfirmationState> knownValues = EnumSet.allOf(ConfirmationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfirmationState.class, ConfirmationState::toString);
    }
}

