/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.privatenetworks.model.HealthStatus;
import software.amazon.awssdk.services.privatenetworks.model.NameValuePair;
import software.amazon.awssdk.services.privatenetworks.model.NameValuePairsCopier;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResourceType;
import software.amazon.awssdk.services.privatenetworks.model.Position;
import software.amazon.awssdk.services.privatenetworks.model.ReturnInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkResource> {
    private static final SdkField<List<NameValuePair>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(NetworkResource.getter(NetworkResource::attributes)).setter(NetworkResource.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NameValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(NetworkResource.getter(NetworkResource::createdAt)).setter(NetworkResource.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(NetworkResource.getter(NetworkResource::description)).setter(NetworkResource.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("health").getter(NetworkResource.getter(NetworkResource::healthAsString)).setter(NetworkResource.setter(Builder::health)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("model").getter(NetworkResource.getter(NetworkResource::model)).setter(NetworkResource.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()}).build();
    private static final SdkField<String> NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkArn").getter(NetworkResource.getter(NetworkResource::networkArn)).setter(NetworkResource.setter(Builder::networkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkArn").build()}).build();
    private static final SdkField<String> NETWORK_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkResourceArn").getter(NetworkResource.getter(NetworkResource::networkResourceArn)).setter(NetworkResource.setter(Builder::networkResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkResourceArn").build()}).build();
    private static final SdkField<String> NETWORK_SITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkSiteArn").getter(NetworkResource.getter(NetworkResource::networkSiteArn)).setter(NetworkResource.setter(Builder::networkSiteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSiteArn").build()}).build();
    private static final SdkField<String> ORDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orderArn").getter(NetworkResource.getter(NetworkResource::orderArn)).setter(NetworkResource.setter(Builder::orderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderArn").build()}).build();
    private static final SdkField<Position> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("position").getter(NetworkResource.getter(NetworkResource::position)).setter(NetworkResource.setter(Builder::position)).constructor(Position::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<ReturnInformation> RETURN_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("returnInformation").getter(NetworkResource.getter(NetworkResource::returnInformation)).setter(NetworkResource.setter(Builder::returnInformation)).constructor(ReturnInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnInformation").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serialNumber").getter(NetworkResource.getter(NetworkResource::serialNumber)).setter(NetworkResource.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(NetworkResource.getter(NetworkResource::statusAsString)).setter(NetworkResource.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(NetworkResource.getter(NetworkResource::statusReason)).setter(NetworkResource.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(NetworkResource.getter(NetworkResource::typeAsString)).setter(NetworkResource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendor").getter(NetworkResource.getter(NetworkResource::vendor)).setter(NetworkResource.setter(Builder::vendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, HEALTH_FIELD, MODEL_FIELD, NETWORK_ARN_FIELD, NETWORK_RESOURCE_ARN_FIELD, NETWORK_SITE_ARN_FIELD, ORDER_ARN_FIELD, POSITION_FIELD, RETURN_INFORMATION_FIELD, SERIAL_NUMBER_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TYPE_FIELD, VENDOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<NameValuePair> attributes;
    private final Instant createdAt;
    private final String description;
    private final String health;
    private final String model;
    private final String networkArn;
    private final String networkResourceArn;
    private final String networkSiteArn;
    private final String orderArn;
    private final Position position;
    private final ReturnInformation returnInformation;
    private final String serialNumber;
    private final String status;
    private final String statusReason;
    private final String type;
    private final String vendor;

    private NetworkResource(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.health = builder.health;
        this.model = builder.model;
        this.networkArn = builder.networkArn;
        this.networkResourceArn = builder.networkResourceArn;
        this.networkSiteArn = builder.networkSiteArn;
        this.orderArn = builder.orderArn;
        this.position = builder.position;
        this.returnInformation = builder.returnInformation;
        this.serialNumber = builder.serialNumber;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.type = builder.type;
        this.vendor = builder.vendor;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<NameValuePair> attributes() {
        return this.attributes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final HealthStatus health() {
        return HealthStatus.fromValue(this.health);
    }

    public final String healthAsString() {
        return this.health;
    }

    public final String model() {
        return this.model;
    }

    public final String networkArn() {
        return this.networkArn;
    }

    public final String networkResourceArn() {
        return this.networkResourceArn;
    }

    public final String networkSiteArn() {
        return this.networkSiteArn;
    }

    public final String orderArn() {
        return this.orderArn;
    }

    public final Position position() {
        return this.position;
    }

    public final ReturnInformation returnInformation() {
        return this.returnInformation;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final NetworkResourceStatus status() {
        return NetworkResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final NetworkResourceType type() {
        return NetworkResourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String vendor() {
        return this.vendor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResource)) {
            return false;
        }
        NetworkResource other = (NetworkResource)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.healthAsString(), other.healthAsString()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.networkArn(), other.networkArn()) && Objects.equals(this.networkResourceArn(), other.networkResourceArn()) && Objects.equals(this.networkSiteArn(), other.networkSiteArn()) && Objects.equals(this.orderArn(), other.orderArn()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.returnInformation(), other.returnInformation()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.vendor(), other.vendor());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkResource").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("Health", (Object)this.healthAsString()).add("Model", (Object)this.model()).add("NetworkArn", (Object)this.networkArn()).add("NetworkResourceArn", (Object)this.networkResourceArn()).add("NetworkSiteArn", (Object)this.networkSiteArn()).add("OrderArn", (Object)this.orderArn()).add("Position", (Object)this.position()).add("ReturnInformation", (Object)this.returnInformation()).add("SerialNumber", (Object)this.serialNumber()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Type", (Object)this.typeAsString()).add("Vendor", (Object)this.vendor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.healthAsString()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "networkArn": {
                return Optional.ofNullable(clazz.cast(this.networkArn()));
            }
            case "networkResourceArn": {
                return Optional.ofNullable(clazz.cast(this.networkResourceArn()));
            }
            case "networkSiteArn": {
                return Optional.ofNullable(clazz.cast(this.networkSiteArn()));
            }
            case "orderArn": {
                return Optional.ofNullable(clazz.cast(this.orderArn()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "returnInformation": {
                return Optional.ofNullable(clazz.cast(this.returnInformation()));
            }
            case "serialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkResource, T> g) {
        return obj -> g.apply((NetworkResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<NameValuePair> attributes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String description;
        private String health;
        private String model;
        private String networkArn;
        private String networkResourceArn;
        private String networkSiteArn;
        private String orderArn;
        private Position position;
        private ReturnInformation returnInformation;
        private String serialNumber;
        private String status;
        private String statusReason;
        private String type;
        private String vendor;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResource model) {
            this.attributes(model.attributes);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.health(model.health);
            this.model(model.model);
            this.networkArn(model.networkArn);
            this.networkResourceArn(model.networkResourceArn);
            this.networkSiteArn(model.networkSiteArn);
            this.orderArn(model.orderArn);
            this.position(model.position);
            this.returnInformation(model.returnInformation);
            this.serialNumber(model.serialNumber);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.type(model.type);
            this.vendor(model.vendor);
        }

        public final List<NameValuePair.Builder> getAttributes() {
            List<NameValuePair.Builder> result = NameValuePairsCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<NameValuePair.BuilderImpl> attributes) {
            this.attributes = NameValuePairsCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<NameValuePair> attributes) {
            this.attributes = NameValuePairsCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(NameValuePair ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<NameValuePair.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (NameValuePair)((NameValuePair.Builder)NameValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHealth() {
            return this.health;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(HealthStatus health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getNetworkArn() {
            return this.networkArn;
        }

        public final void setNetworkArn(String networkArn) {
            this.networkArn = networkArn;
        }

        @Override
        public final Builder networkArn(String networkArn) {
            this.networkArn = networkArn;
            return this;
        }

        public final String getNetworkResourceArn() {
            return this.networkResourceArn;
        }

        public final void setNetworkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
        }

        @Override
        public final Builder networkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
            return this;
        }

        public final String getNetworkSiteArn() {
            return this.networkSiteArn;
        }

        public final void setNetworkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
        }

        @Override
        public final Builder networkSiteArn(String networkSiteArn) {
            this.networkSiteArn = networkSiteArn;
            return this;
        }

        public final String getOrderArn() {
            return this.orderArn;
        }

        public final void setOrderArn(String orderArn) {
            this.orderArn = orderArn;
        }

        @Override
        public final Builder orderArn(String orderArn) {
            this.orderArn = orderArn;
            return this;
        }

        public final Position.Builder getPosition() {
            return this.position != null ? this.position.toBuilder() : null;
        }

        public final void setPosition(Position.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(Position position) {
            this.position = position;
            return this;
        }

        public final ReturnInformation.Builder getReturnInformation() {
            return this.returnInformation != null ? this.returnInformation.toBuilder() : null;
        }

        public final void setReturnInformation(ReturnInformation.BuilderImpl returnInformation) {
            this.returnInformation = returnInformation != null ? returnInformation.build() : null;
        }

        @Override
        public final Builder returnInformation(ReturnInformation returnInformation) {
            this.returnInformation = returnInformation;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getVendor() {
            return this.vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public NetworkResource build() {
            return new NetworkResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkResource> {
        public Builder attributes(Collection<NameValuePair> var1);

        public Builder attributes(NameValuePair ... var1);

        public Builder attributes(Consumer<NameValuePair.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder health(String var1);

        public Builder health(HealthStatus var1);

        public Builder model(String var1);

        public Builder networkArn(String var1);

        public Builder networkResourceArn(String var1);

        public Builder networkSiteArn(String var1);

        public Builder orderArn(String var1);

        public Builder position(Position var1);

        default public Builder position(Consumer<Position.Builder> position) {
            return this.position((Position)((Position.Builder)Position.builder().applyMutation(position)).build());
        }

        public Builder returnInformation(ReturnInformation var1);

        default public Builder returnInformation(Consumer<ReturnInformation.Builder> returnInformation) {
            return this.returnInformation((ReturnInformation)((ReturnInformation.Builder)ReturnInformation.builder().applyMutation(returnInformation)).build());
        }

        public Builder serialNumber(String var1);

        public Builder status(String var1);

        public Builder status(NetworkResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder type(String var1);

        public Builder type(NetworkResourceType var1);

        public Builder vendor(String var1);
    }
}

