/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.Address;
import software.amazon.awssdk.services.privatenetworks.model.PrivateNetworksRequest;
import software.amazon.awssdk.services.privatenetworks.model.UpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartNetworkResourceUpdateRequest
extends PrivateNetworksRequest
implements ToCopyableBuilder<Builder, StartNetworkResourceUpdateRequest> {
    private static final SdkField<String> NETWORK_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkResourceArn").getter(StartNetworkResourceUpdateRequest.getter(StartNetworkResourceUpdateRequest::networkResourceArn)).setter(StartNetworkResourceUpdateRequest.setter(Builder::networkResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkResourceArn").build()}).build();
    private static final SdkField<String> RETURN_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("returnReason").getter(StartNetworkResourceUpdateRequest.getter(StartNetworkResourceUpdateRequest::returnReason)).setter(StartNetworkResourceUpdateRequest.setter(Builder::returnReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnReason").build()}).build();
    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("shippingAddress").getter(StartNetworkResourceUpdateRequest.getter(StartNetworkResourceUpdateRequest::shippingAddress)).setter(StartNetworkResourceUpdateRequest.setter(Builder::shippingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(StartNetworkResourceUpdateRequest.getter(StartNetworkResourceUpdateRequest::updateTypeAsString)).setter(StartNetworkResourceUpdateRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_RESOURCE_ARN_FIELD, RETURN_REASON_FIELD, SHIPPING_ADDRESS_FIELD, UPDATE_TYPE_FIELD));
    private final String networkResourceArn;
    private final String returnReason;
    private final Address shippingAddress;
    private final String updateType;

    private StartNetworkResourceUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.networkResourceArn = builder.networkResourceArn;
        this.returnReason = builder.returnReason;
        this.shippingAddress = builder.shippingAddress;
        this.updateType = builder.updateType;
    }

    public final String networkResourceArn() {
        return this.networkResourceArn;
    }

    public final String returnReason() {
        return this.returnReason;
    }

    public final Address shippingAddress() {
        return this.shippingAddress;
    }

    public final UpdateType updateType() {
        return UpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNetworkResourceUpdateRequest)) {
            return false;
        }
        StartNetworkResourceUpdateRequest other = (StartNetworkResourceUpdateRequest)((Object)obj);
        return Objects.equals(this.networkResourceArn(), other.networkResourceArn()) && Objects.equals(this.returnReason(), other.returnReason()) && Objects.equals(this.shippingAddress(), other.shippingAddress()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartNetworkResourceUpdateRequest").add("NetworkResourceArn", (Object)this.networkResourceArn()).add("ReturnReason", (Object)this.returnReason()).add("ShippingAddress", (Object)this.shippingAddress()).add("UpdateType", (Object)this.updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkResourceArn": {
                return Optional.ofNullable(clazz.cast(this.networkResourceArn()));
            }
            case "returnReason": {
                return Optional.ofNullable(clazz.cast(this.returnReason()));
            }
            case "shippingAddress": {
                return Optional.ofNullable(clazz.cast(this.shippingAddress()));
            }
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNetworkResourceUpdateRequest, T> g) {
        return obj -> g.apply((StartNetworkResourceUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PrivateNetworksRequest.BuilderImpl
    implements Builder {
        private String networkResourceArn;
        private String returnReason;
        private Address shippingAddress;
        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartNetworkResourceUpdateRequest model) {
            super(model);
            this.networkResourceArn(model.networkResourceArn);
            this.returnReason(model.returnReason);
            this.shippingAddress(model.shippingAddress);
            this.updateType(model.updateType);
        }

        public final String getNetworkResourceArn() {
            return this.networkResourceArn;
        }

        public final void setNetworkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
        }

        @Override
        public final Builder networkResourceArn(String networkResourceArn) {
            this.networkResourceArn = networkResourceArn;
            return this;
        }

        public final String getReturnReason() {
            return this.returnReason;
        }

        public final void setReturnReason(String returnReason) {
            this.returnReason = returnReason;
        }

        @Override
        public final Builder returnReason(String returnReason) {
            this.returnReason = returnReason;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return this.shippingAddress != null ? this.shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNetworkResourceUpdateRequest build() {
            return new StartNetworkResourceUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PrivateNetworksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartNetworkResourceUpdateRequest> {
        public Builder networkResourceArn(String var1);

        public Builder returnReason(String var1);

        public Builder shippingAddress(Address var1);

        default public Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return this.shippingAddress((Address)((Address.Builder)Address.builder().applyMutation(shippingAddress)).build());
        }

        public Builder updateType(String var1);

        public Builder updateType(UpdateType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

