/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksAsyncClient;
import software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse;

public class ListDeviceIdentifiersPublisher
implements SdkPublisher<ListDeviceIdentifiersResponse> {
    private final PrivateNetworksAsyncClient client;
    private final ListDeviceIdentifiersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeviceIdentifiersPublisher(PrivateNetworksAsyncClient client, ListDeviceIdentifiersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeviceIdentifiersPublisher(PrivateNetworksAsyncClient client, ListDeviceIdentifiersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeviceIdentifiersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeviceIdentifiersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeviceIdentifier> deviceIdentifiers() {
        Function<ListDeviceIdentifiersResponse, Iterator> getIterator = response -> {
            if (response != null && response.deviceIdentifiers() != null) {
                return response.deviceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeviceIdentifiersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeviceIdentifiersResponseFetcher
    implements AsyncPageFetcher<ListDeviceIdentifiersResponse> {
        private ListDeviceIdentifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceIdentifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeviceIdentifiersResponse> nextPage(ListDeviceIdentifiersResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceIdentifiersPublisher.this.client.listDeviceIdentifiers(ListDeviceIdentifiersPublisher.this.firstRequest);
            }
            return ListDeviceIdentifiersPublisher.this.client.listDeviceIdentifiers((ListDeviceIdentifiersRequest)((Object)ListDeviceIdentifiersPublisher.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

