/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.privatenetworks.PrivateNetworksAsyncClient;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest;
import software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResource;

public class ListNetworkResourcesPublisher
implements SdkPublisher<ListNetworkResourcesResponse> {
    private final PrivateNetworksAsyncClient client;
    private final ListNetworkResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNetworkResourcesPublisher(PrivateNetworksAsyncClient client, ListNetworkResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNetworkResourcesPublisher(PrivateNetworksAsyncClient client, ListNetworkResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNetworkResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNetworkResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkResource> networkResources() {
        Function<ListNetworkResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkResources() != null) {
                return response.networkResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNetworkResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNetworkResourcesResponseFetcher
    implements AsyncPageFetcher<ListNetworkResourcesResponse> {
        private ListNetworkResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNetworkResourcesResponse> nextPage(ListNetworkResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkResourcesPublisher.this.client.listNetworkResources(ListNetworkResourcesPublisher.this.firstRequest);
            }
            return ListNetworkResourcesPublisher.this.client.listNetworkResources((ListNetworkResourcesRequest)((Object)ListNetworkResourcesPublisher.this.firstRequest.toBuilder().startToken(previousPage.nextToken()).build()));
        }
    }
}

