/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.AxisLabelOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChartAxisLabelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChartAxisLabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(ChartAxisLabelOptions.getter(ChartAxisLabelOptions::visibilityAsString)).setter(ChartAxisLabelOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> SORT_ICON_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortIconVisibility").getter(ChartAxisLabelOptions.getter(ChartAxisLabelOptions::sortIconVisibilityAsString)).setter(ChartAxisLabelOptions.setter(Builder::sortIconVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortIconVisibility").build()}).build();
    private static final SdkField<List<AxisLabelOptions>> AXIS_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AxisLabelOptions").getter(ChartAxisLabelOptions.getter(ChartAxisLabelOptions::axisLabelOptions)).setter(ChartAxisLabelOptions.setter(Builder::axisLabelOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisLabelOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, SORT_ICON_VISIBILITY_FIELD, AXIS_LABEL_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final String sortIconVisibility;
    private final List<AxisLabelOptions> axisLabelOptions;

    private ChartAxisLabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.sortIconVisibility = builder.sortIconVisibility;
        this.axisLabelOptions = builder.axisLabelOptions;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final Visibility sortIconVisibility() {
        return Visibility.fromValue(this.sortIconVisibility);
    }

    public final String sortIconVisibilityAsString() {
        return this.sortIconVisibility;
    }

    public final boolean hasAxisLabelOptions() {
        return this.axisLabelOptions != null && !(this.axisLabelOptions instanceof SdkAutoConstructList);
    }

    public final List<AxisLabelOptions> axisLabelOptions() {
        return this.axisLabelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortIconVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAxisLabelOptions() ? this.axisLabelOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChartAxisLabelOptions)) {
            return false;
        }
        ChartAxisLabelOptions other = (ChartAxisLabelOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.sortIconVisibilityAsString(), other.sortIconVisibilityAsString()) && this.hasAxisLabelOptions() == other.hasAxisLabelOptions() && Objects.equals(this.axisLabelOptions(), other.axisLabelOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ChartAxisLabelOptions").add("Visibility", (Object)this.visibilityAsString()).add("SortIconVisibility", (Object)this.sortIconVisibilityAsString()).add("AxisLabelOptions", this.hasAxisLabelOptions() ? this.axisLabelOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "SortIconVisibility": {
                return Optional.ofNullable(clazz.cast(this.sortIconVisibilityAsString()));
            }
            case "AxisLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.axisLabelOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChartAxisLabelOptions, T> g) {
        return obj -> g.apply((ChartAxisLabelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private String sortIconVisibility;
        private List<AxisLabelOptions> axisLabelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChartAxisLabelOptions model) {
            this.visibility(model.visibility);
            this.sortIconVisibility(model.sortIconVisibility);
            this.axisLabelOptions(model.axisLabelOptions);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getSortIconVisibility() {
            return this.sortIconVisibility;
        }

        public final void setSortIconVisibility(String sortIconVisibility) {
            this.sortIconVisibility = sortIconVisibility;
        }

        @Override
        public final Builder sortIconVisibility(String sortIconVisibility) {
            this.sortIconVisibility = sortIconVisibility;
            return this;
        }

        @Override
        public final Builder sortIconVisibility(Visibility sortIconVisibility) {
            this.sortIconVisibility(sortIconVisibility == null ? null : sortIconVisibility.toString());
            return this;
        }

        public final List<AxisLabelOptions.Builder> getAxisLabelOptions() {
            List<AxisLabelOptions.Builder> result = AxisLabelOptionsListCopier.copyToBuilder(this.axisLabelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAxisLabelOptions(Collection<AxisLabelOptions.BuilderImpl> axisLabelOptions) {
            this.axisLabelOptions = AxisLabelOptionsListCopier.copyFromBuilder(axisLabelOptions);
        }

        @Override
        public final Builder axisLabelOptions(Collection<AxisLabelOptions> axisLabelOptions) {
            this.axisLabelOptions = AxisLabelOptionsListCopier.copy(axisLabelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder axisLabelOptions(AxisLabelOptions ... axisLabelOptions) {
            this.axisLabelOptions(Arrays.asList(axisLabelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder axisLabelOptions(Consumer<AxisLabelOptions.Builder> ... axisLabelOptions) {
            this.axisLabelOptions(Stream.of(axisLabelOptions).map(c -> (AxisLabelOptions)((AxisLabelOptions.Builder)AxisLabelOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ChartAxisLabelOptions build() {
            return new ChartAxisLabelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChartAxisLabelOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder sortIconVisibility(String var1);

        public Builder sortIconVisibility(Visibility var1);

        public Builder axisLabelOptions(Collection<AxisLabelOptions> var1);

        public Builder axisLabelOptions(AxisLabelOptions ... var1);

        public Builder axisLabelOptions(Consumer<AxisLabelOptions.Builder> ... var1);
    }
}

