/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.CustomActionColumnListCopier;
import software.amazon.awssdk.services.quicksight.model.SelectedFieldListCopier;
import software.amazon.awssdk.services.quicksight.model.SelectedFieldOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterOperationSelectedFieldsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterOperationSelectedFieldsConfiguration> {
    private static final SdkField<List<String>> SELECTED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedFields").getter(FilterOperationSelectedFieldsConfiguration.getter(FilterOperationSelectedFieldsConfiguration::selectedFields)).setter(FilterOperationSelectedFieldsConfiguration.setter(Builder::selectedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SELECTED_FIELD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectedFieldOptions").getter(FilterOperationSelectedFieldsConfiguration.getter(FilterOperationSelectedFieldsConfiguration::selectedFieldOptionsAsString)).setter(FilterOperationSelectedFieldsConfiguration.setter(Builder::selectedFieldOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFieldOptions").build()}).build();
    private static final SdkField<List<ColumnIdentifier>> SELECTED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedColumns").getter(FilterOperationSelectedFieldsConfiguration.getter(FilterOperationSelectedFieldsConfiguration::selectedColumns)).setter(FilterOperationSelectedFieldsConfiguration.setter(Builder::selectedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_FIELDS_FIELD, SELECTED_FIELD_OPTIONS_FIELD, SELECTED_COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> selectedFields;
    private final String selectedFieldOptions;
    private final List<ColumnIdentifier> selectedColumns;

    private FilterOperationSelectedFieldsConfiguration(BuilderImpl builder) {
        this.selectedFields = builder.selectedFields;
        this.selectedFieldOptions = builder.selectedFieldOptions;
        this.selectedColumns = builder.selectedColumns;
    }

    public final boolean hasSelectedFields() {
        return this.selectedFields != null && !(this.selectedFields instanceof SdkAutoConstructList);
    }

    public final List<String> selectedFields() {
        return this.selectedFields;
    }

    public final SelectedFieldOptions selectedFieldOptions() {
        return SelectedFieldOptions.fromValue(this.selectedFieldOptions);
    }

    public final String selectedFieldOptionsAsString() {
        return this.selectedFieldOptions;
    }

    public final boolean hasSelectedColumns() {
        return this.selectedColumns != null && !(this.selectedColumns instanceof SdkAutoConstructList);
    }

    public final List<ColumnIdentifier> selectedColumns() {
        return this.selectedColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedFields() ? this.selectedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedFieldOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedColumns() ? this.selectedColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterOperationSelectedFieldsConfiguration)) {
            return false;
        }
        FilterOperationSelectedFieldsConfiguration other = (FilterOperationSelectedFieldsConfiguration)obj;
        return this.hasSelectedFields() == other.hasSelectedFields() && Objects.equals(this.selectedFields(), other.selectedFields()) && Objects.equals(this.selectedFieldOptionsAsString(), other.selectedFieldOptionsAsString()) && this.hasSelectedColumns() == other.hasSelectedColumns() && Objects.equals(this.selectedColumns(), other.selectedColumns());
    }

    public final String toString() {
        return ToString.builder((String)"FilterOperationSelectedFieldsConfiguration").add("SelectedFields", this.hasSelectedFields() ? this.selectedFields() : null).add("SelectedFieldOptions", (Object)this.selectedFieldOptionsAsString()).add("SelectedColumns", this.hasSelectedColumns() ? this.selectedColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectedFields": {
                return Optional.ofNullable(clazz.cast(this.selectedFields()));
            }
            case "SelectedFieldOptions": {
                return Optional.ofNullable(clazz.cast(this.selectedFieldOptionsAsString()));
            }
            case "SelectedColumns": {
                return Optional.ofNullable(clazz.cast(this.selectedColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterOperationSelectedFieldsConfiguration, T> g) {
        return obj -> g.apply((FilterOperationSelectedFieldsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> selectedFields = DefaultSdkAutoConstructList.getInstance();
        private String selectedFieldOptions;
        private List<ColumnIdentifier> selectedColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterOperationSelectedFieldsConfiguration model) {
            this.selectedFields(model.selectedFields);
            this.selectedFieldOptions(model.selectedFieldOptions);
            this.selectedColumns(model.selectedColumns);
        }

        public final Collection<String> getSelectedFields() {
            if (this.selectedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedFields;
        }

        public final void setSelectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldListCopier.copy(selectedFields);
        }

        @Override
        public final Builder selectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldListCopier.copy(selectedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFields(String ... selectedFields) {
            this.selectedFields(Arrays.asList(selectedFields));
            return this;
        }

        public final String getSelectedFieldOptions() {
            return this.selectedFieldOptions;
        }

        public final void setSelectedFieldOptions(String selectedFieldOptions) {
            this.selectedFieldOptions = selectedFieldOptions;
        }

        @Override
        public final Builder selectedFieldOptions(String selectedFieldOptions) {
            this.selectedFieldOptions = selectedFieldOptions;
            return this;
        }

        @Override
        public final Builder selectedFieldOptions(SelectedFieldOptions selectedFieldOptions) {
            this.selectedFieldOptions(selectedFieldOptions == null ? null : selectedFieldOptions.toString());
            return this;
        }

        public final List<ColumnIdentifier.Builder> getSelectedColumns() {
            List<ColumnIdentifier.Builder> result = CustomActionColumnListCopier.copyToBuilder(this.selectedColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedColumns(Collection<ColumnIdentifier.BuilderImpl> selectedColumns) {
            this.selectedColumns = CustomActionColumnListCopier.copyFromBuilder(selectedColumns);
        }

        @Override
        public final Builder selectedColumns(Collection<ColumnIdentifier> selectedColumns) {
            this.selectedColumns = CustomActionColumnListCopier.copy(selectedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(ColumnIdentifier ... selectedColumns) {
            this.selectedColumns(Arrays.asList(selectedColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Consumer<ColumnIdentifier.Builder> ... selectedColumns) {
            this.selectedColumns(Stream.of(selectedColumns).map(c -> (ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FilterOperationSelectedFieldsConfiguration build() {
            return new FilterOperationSelectedFieldsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterOperationSelectedFieldsConfiguration> {
        public Builder selectedFields(Collection<String> var1);

        public Builder selectedFields(String ... var1);

        public Builder selectedFieldOptions(String var1);

        public Builder selectedFieldOptions(SelectedFieldOptions var1);

        public Builder selectedColumns(Collection<ColumnIdentifier> var1);

        public Builder selectedColumns(ColumnIdentifier ... var1);

        public Builder selectedColumns(Consumer<ColumnIdentifier.Builder> ... var1);
    }
}

