/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NumericSeparatorSymbol {
    COMMA("COMMA"),
    DOT("DOT"),
    SPACE("SPACE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NumericSeparatorSymbol> VALUE_MAP;
    private final String value;

    private NumericSeparatorSymbol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NumericSeparatorSymbol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NumericSeparatorSymbol> knownValues() {
        EnumSet<NumericSeparatorSymbol> knownValues = EnumSet.allOf(NumericSeparatorSymbol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NumericSeparatorSymbol.class, NumericSeparatorSymbol::toString);
    }
}

