/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse;
import software.amazon.awssdk.services.quicksight.model.TemplateSummary;

public class ListTemplatesIterable
implements SdkIterable<ListTemplatesResponse> {
    private final QuickSightClient client;
    private final ListTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplatesIterable(QuickSightClient client, ListTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTemplatesResponseFetcher();
    }

    public Iterator<ListTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateSummary> templateSummaryList() {
        Function<ListTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateSummaryList() != null) {
                return response.templateSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplatesResponseFetcher
    implements SyncPageFetcher<ListTemplatesResponse> {
        private ListTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplatesResponse nextPage(ListTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplatesIterable.this.client.listTemplates(ListTemplatesIterable.this.firstRequest);
            }
            return ListTemplatesIterable.this.client.listTemplates((ListTemplatesRequest)((Object)ListTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

